/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.transformer;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.customfields.converters.GroupConverter;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.searchers.transformer.AbstractCustomFieldSearchInputTransformer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.customfields.view.CustomFieldParamsImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SimpleNavigatorCollectorVisitor;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.Query;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operator.Operator;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class MultiGroupCustomFieldSearchInputTransformer
extends AbstractCustomFieldSearchInputTransformer
implements SearchInputTransformer {
    private final ClauseNames clauseNames;
    private final JqlOperandResolver jqlOperandResolver;
    private final GroupConverter groupConverter;

    public MultiGroupCustomFieldSearchInputTransformer(String urlParameterName, ClauseNames clauseNames, CustomField field, JqlOperandResolver jqlOperandResolver, CustomFieldInputHelper customFieldInputHelper, GroupConverter groupConverter) {
        super(field, urlParameterName, customFieldInputHelper);
        this.groupConverter = (GroupConverter)Assertions.notNull((String)"groupConverter", (Object)groupConverter);
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
        this.clauseNames = (ClauseNames)Assertions.notNull((String)"clauseNames", (Object)clauseNames);
    }

    protected Clause getClauseFromParams(User user, CustomFieldParams params) {
        Collection searchValues = params.getAllValues();
        searchValues.removeAll(CollectionBuilder.newBuilder((Object[])new String[]{"-1", ""}).asCollection());
        if (!searchValues.isEmpty()) {
            return new TerminalClauseImpl(this.getClauseName(user, this.clauseNames), searchValues.toArray(new String[searchValues.size()]));
        }
        return null;
    }

    protected CustomFieldParams getParamsFromSearchRequest(User user, Query query, SearchContext searchContext) {
        Collection<String> groupStrings = this.getGroupsFromQuery(user, query);
        if (groupStrings == null || groupStrings.isEmpty()) {
            return null;
        }
        Collection<String> validGroups = this.getValidGroups(groupStrings);
        if (validGroups == null || validGroups.isEmpty()) {
            return null;
        }
        return new CustomFieldParamsImpl(this.getCustomField(), validGroups);
    }

    private Collection<String> getValidGroups(Collection<String> rawGroups) {
        CollectionBuilder builder = CollectionBuilder.newBuilder();
        for (String rawGroup : rawGroups) {
            try {
                Group group = this.groupConverter.getGroup(rawGroup);
                if (group == null) continue;
                builder.add((Object)rawGroup);
            }
            catch (FieldValidationException e) {}
        }
        return builder.asList();
    }

    private Collection<String> getGroupsFromQuery(User user, Query query) {
        if (query != null && query.getWhereClause() != null) {
            List literals;
            TerminalClause clause;
            SimpleNavigatorCollectorVisitor visitor = new SimpleNavigatorCollectorVisitor(this.clauseNames.getJqlFieldNames());
            query.getWhereClause().accept((ClauseVisitor)visitor);
            if (visitor.isValid() && visitor.getClauses().size() == 1 && this.isValidOperatorForFitness((clause = (TerminalClause)visitor.getClauses().get(0)).getOperator()) && (literals = this.jqlOperandResolver.getValues(user, clause.getOperand(), clause)) != null && !literals.contains(new QueryLiteral())) {
                HashSet<String> valuesAsStrings = new HashSet<String>();
                for (QueryLiteral literal : literals) {
                    valuesAsStrings.add(literal.asString());
                }
                return valuesAsStrings;
            }
        }
        return null;
    }

    protected boolean isValidOperatorForFitness(Operator operator) {
        return operator == Operator.EQUALS || operator == Operator.IN;
    }

    public boolean doRelevantClausesFitFilterForm(User user, Query query, SearchContext searchContext) {
        Collection<String> rawGroups = this.getGroupsFromQuery(user, query);
        if (rawGroups == null) {
            return false;
        }
        Collection<String> validGroups = this.getValidGroups(rawGroups);
        return validGroups != null && rawGroups.size() == validGroups.size();
    }

    public void validateParams(User user, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, I18nHelper i18nHelper, ErrorCollection errors) {
    }
}

