/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers;

import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldValueProvider;
import com.atlassian.jira.issue.customfields.searchers.AbstractInitializationCustomFieldSearcher;
import com.atlassian.jira.issue.customfields.searchers.CustomFieldSearcherClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.SimpleCustomFieldValueGeneratingClauseHandler;
import com.atlassian.jira.issue.customfields.searchers.information.CustomFieldSearcherInformation;
import com.atlassian.jira.issue.customfields.searchers.renderer.CustomFieldRenderer;
import com.atlassian.jira.issue.customfields.searchers.transformer.CustomFieldInputHelper;
import com.atlassian.jira.issue.customfields.statistics.CustomFieldStattable;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.index.indexers.impl.CustomFieldLabelsIndexer;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.issue.search.searchers.information.SearcherInformation;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.search.searchers.transformer.CustomFieldLabelsSearchInputTransformer;
import com.atlassian.jira.issue.search.searchers.transformer.SearchInputTransformer;
import com.atlassian.jira.issue.statistics.CustomFieldLabelsStatisticsMapper;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.query.ClauseQueryFactory;
import com.atlassian.jira.jql.query.LabelsClauseQueryFactory;
import com.atlassian.jira.jql.validator.ClauseValidator;
import com.atlassian.jira.jql.validator.LabelsValidator;
import com.atlassian.jira.jql.values.ClauseValuesGenerator;
import com.atlassian.jira.jql.values.LabelsClauseValuesGenerator;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class CustomFieldLabelsSearcher
extends AbstractInitializationCustomFieldSearcher
implements CustomFieldSearcher,
CustomFieldStattable {
    private final FieldVisibilityManager fieldVisibilityManager;
    private final JqlOperandResolver jqlOperandResolver;
    private final LabelsClauseValuesGenerator labelsClauseValuesGenerator;
    private final JiraAuthenticationContext authenticationContext;
    private final CustomFieldInputHelper customFieldInputHelper;
    private CustomFieldSearcherInformation searcherInformation;
    private SearchRenderer searchRenderer;
    private SearchInputTransformer searchInputTransformer;
    private CustomFieldSearcherClauseHandler customFieldSearcherClauseHandler;

    public CustomFieldLabelsSearcher(FieldVisibilityManager fieldVisibilityManager, JqlOperandResolver jqlOperandResolver, LabelsClauseValuesGenerator labelsClauseValuesGenerator, JiraAuthenticationContext authenticationContext, CustomFieldInputHelper customFieldInputHelper) {
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.jqlOperandResolver = jqlOperandResolver;
        this.labelsClauseValuesGenerator = labelsClauseValuesGenerator;
        this.authenticationContext = authenticationContext;
        this.customFieldInputHelper = customFieldInputHelper;
    }

    public void init(CustomField customField) {
        ClauseNames names = customField.getClauseNames();
        CustomFieldLabelsIndexer fieldIndexer = new CustomFieldLabelsIndexer(this.fieldVisibilityManager, customField);
        LabelCustomFieldValueProvider customFieldValueProvider = new LabelCustomFieldValueProvider();
        this.searcherInformation = new CustomFieldSearcherInformation(customField.getId(), customField.getNameKey(), Arrays.asList(new FieldIndexer[]{fieldIndexer}), new AtomicReference<CustomField>(customField));
        this.searchRenderer = new CustomFieldRenderer(names, this.getDescriptor(), customField, (CustomFieldValueProvider)customFieldValueProvider, this.fieldVisibilityManager);
        this.searchInputTransformer = new CustomFieldLabelsSearchInputTransformer(customField, customField.getId(), this.customFieldInputHelper, names);
        this.customFieldSearcherClauseHandler = new SimpleCustomFieldValueGeneratingClauseHandler((ClauseValidator)new LabelsValidator(this.jqlOperandResolver), (ClauseQueryFactory)new LabelsClauseQueryFactory(this.jqlOperandResolver, customField.getId() + "_folded"), (ClauseValuesGenerator)this.labelsClauseValuesGenerator, SystemSearchConstants.forLabels().getSupportedOperators(), SystemSearchConstants.forLabels().getDataType());
    }

    public CustomFieldSearcherClauseHandler getCustomFieldSearcherClauseHandler() {
        return this.customFieldSearcherClauseHandler;
    }

    public SearcherInformation<CustomField> getSearchInformation() {
        return this.searcherInformation;
    }

    public SearchInputTransformer getSearchInputTransformer() {
        return this.searchInputTransformer;
    }

    public SearchRenderer getSearchRenderer() {
        return this.searchRenderer;
    }

    public StatisticsMapper getStatisticsMapper(CustomField customField) {
        return new CustomFieldLabelsStatisticsMapper(customField, this.customFieldInputHelper, this.authenticationContext, false);
    }

    static class LabelCustomFieldValueProvider
    implements CustomFieldValueProvider {
        LabelCustomFieldValueProvider() {
        }

        public Object getStringValue(CustomField customField, FieldValuesHolder fieldValuesHolder) {
            CustomFieldParams customFieldParams = customField.getCustomFieldValues((Map)fieldValuesHolder);
            Collection customFieldValues = customFieldParams.getAllValues();
            if (customFieldValues != null) {
                return Joiner.on((String)" ").join((Iterable)customFieldValues);
            }
            return "";
        }

        public Object getValue(CustomField customField, FieldValuesHolder fieldValuesHolder) {
            CustomFieldParams customFieldParams = customField.getCustomFieldValues((Map)fieldValuesHolder);
            return customField.getCustomFieldType().getValueFromCustomFieldParams(customFieldParams);
        }
    }
}

