/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.context.persistence;

import com.atlassian.annotations.Internal;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cache.GoogleCacheInstruments;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.manager.JiraContextTreeManager;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersisterImpl;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.map.CacheObject;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
@Internal
public class CachingFieldConfigContextPersister
implements FieldConfigContextPersister,
Startable {
    private static final Logger log = LoggerFactory.getLogger(CachingFieldConfigContextPersister.class);
    private final Cache<CacheKey, CacheObject> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, CacheObject>(){

        public CacheObject load(CacheKey key) throws Exception {
            return CacheObject.wrap(CachingFieldConfigContextPersister.this.delegate.retrieve((BandanaContext)key.contextNode, key.customField));
        }
    });
    private final FieldConfigContextPersister delegate;

    public CachingFieldConfigContextPersister(OfBizDelegator delegator, ProjectManager projectManager, JiraContextTreeManager treeManager) {
        this.delegate = new FieldConfigContextPersisterImpl(delegator, projectManager, treeManager);
    }

    public void start() throws Exception {
        new GoogleCacheInstruments(CachingFieldConfigContextPersister.class.getSimpleName()).addCache(this.cache).install();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent clearCacheEvent) {
        this.invalidateAll();
    }

    public List<JiraContextNode> getAllContextsForCustomField(String key) {
        return this.delegate.getAllContextsForCustomField(key);
    }

    public List<JiraContextNode> getAllContextsForConfigScheme(FieldConfigScheme fieldConfigScheme) {
        return this.delegate.getAllContextsForConfigScheme(fieldConfigScheme);
    }

    public void removeContextsForConfigScheme(Long fieldConfigSchemeId) {
        this.delegate.removeContextsForConfigScheme(fieldConfigSchemeId);
        this.invalidateMatchingValues(fieldConfigSchemeId);
    }

    public void removeContextsForProject(GenericValue project) {
        this.delegate.removeContextsForProject(project);
        this.invalidateMatchingKeys(new ProjectIdMatcher(project.getLong("id")));
    }

    public void removeContextsForProject(Project project) {
        this.delegate.removeContextsForProject(project);
        this.invalidateMatchingKeys(new ProjectIdMatcher(project.getId()));
    }

    public void removeContextsForProjectCategory(ProjectCategory projectCategory) {
        this.delegate.removeContextsForProjectCategory(projectCategory);
        this.invalidateMatchingKeys(new ProjectCategoryMatcher(projectCategory));
    }

    public Object retrieve(BandanaContext context, String key) {
        return ((CacheObject)this.cache.getUnchecked((Object)new CacheKey((JiraContextNode)context, key))).getValue();
    }

    public void store(BandanaContext context, String customField, Object fieldConfigScheme) {
        this.delegate.store(context, customField, fieldConfigScheme);
        this.invalidateMatchingKeys(new CustomFieldMatcher(customField));
    }

    public void flushCaches() {
        this.delegate.flushCaches();
        this.invalidateAll();
    }

    public void remove(BandanaContext context) {
        this.delegate.remove(context);
        this.invalidateMatchingKeys(new ContextMatcher(context));
    }

    public void remove(BandanaContext context, String customField) {
        this.delegate.remove(context, customField);
        this.invalidateMatchingKeys(new CustomFieldMatcher(customField));
    }

    private void invalidateAll() {
        this.cache.invalidateAll();
        if (log.isTraceEnabled()) {
            log.trace("called invalidateAll()", new Throwable());
        }
    }

    private void invalidateMatchingKeys(@Nonnull Predicate<CacheKey> predicate) {
        for (CacheKey key : this.cache.asMap().keySet()) {
            if (!predicate.apply((Object)key)) continue;
            this.cache.invalidate((Object)key);
        }
    }

    private void invalidateMatchingValues(@Nonnull Long fieldConfigSchemeId) {
        for (Map.Entry entry : this.cache.asMap().entrySet()) {
            if (!fieldConfigSchemeId.equals(((CacheObject)entry.getValue()).getValue())) continue;
            this.cache.invalidate(entry.getKey());
        }
    }

    private class ProjectCategoryMatcher
    implements Predicate<CacheKey> {
        private final ProjectCategory projectCategory;

        public ProjectCategoryMatcher(ProjectCategory projectCategory) {
            this.projectCategory = projectCategory;
        }

        public boolean apply(@Nullable CacheKey key) {
            if (key == null) {
                return false;
            }
            Project project = key.contextNode.getProjectObject();
            return project != null && this.projectCategory.equals(project.getProjectCategoryObject());
        }
    }

    private static class CustomFieldMatcher
    implements Predicate<CacheKey> {
        private final String customField;

        public CustomFieldMatcher(String customField) {
            this.customField = customField;
        }

        public boolean apply(@Nullable CacheKey input) {
            return input != null && Objects.equal((Object)input.customField, (Object)this.customField);
        }
    }

    private static class ContextMatcher
    implements Predicate<CacheKey> {
        private final BandanaContext context;

        public ContextMatcher(BandanaContext context) {
            this.context = context;
        }

        public boolean apply(CacheKey key) {
            return this.context.equals(key.contextNode);
        }
    }

    private static class ProjectIdMatcher
    implements Predicate<CacheKey> {
        private final Long projectId;

        public ProjectIdMatcher(Long projectId) {
            this.projectId = projectId;
        }

        public boolean apply(CacheKey key) {
            Project project = key.contextNode.getProjectObject();
            return project != null && this.projectId.equals(project.getId());
        }
    }

    static final class CacheKey {
        private final Map<String, Object> contextParams;
        private final String customField;
        private final JiraContextNode contextNode;

        CacheKey(JiraContextNode contextNode, String customField) {
            this.contextNode = contextNode;
            this.customField = customField;
            this.contextParams = Collections.unmodifiableMap(contextNode.appendToParamsMap(null));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.contextParams != null ? !((Object)this.contextParams).equals(cacheKey.contextParams) : cacheKey.contextParams != null) {
                return false;
            }
            return !(this.customField != null ? !this.customField.equals(cacheKey.customField) : cacheKey.customField != null);
        }

        public int hashCode() {
            int result = this.contextParams != null ? ((Object)this.contextParams).hashCode() : 0;
            result = 31 * result + (this.customField != null ? this.customField.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "CacheKey{" + this.contextParams + "/" + this.customField + '}';
        }
    }
}

