/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.changehistory;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryBatch;
import com.atlassian.jira.issue.changehistory.ChangeHistoryItem;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.dbc.Null;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityFieldMap;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class DefaultChangeHistoryManager
implements ChangeHistoryManager {
    private static final Logger log = Logger.getLogger(DefaultChangeHistoryManager.class);
    private final IssueManager issueManager;
    private final OfBizDelegator ofBizDelegator;
    private final PermissionManager permissionManager;
    private final ComponentLocator componentLocator;
    private final UserManager userManager;
    private static final String FIELD_KEY = "Key";
    private static final String ISSUEID_FIELD = "issueid";
    private static final List<String> FIELDS_TO_SELECT = ImmutableList.of((Object)"issueid");

    public DefaultChangeHistoryManager(IssueManager issueManager, OfBizDelegator ofBizDelegator, PermissionManager permissionManager, ComponentLocator componentLocator, UserManager userManager) {
        this.issueManager = issueManager;
        this.userManager = userManager;
        this.ofBizDelegator = ofBizDelegator;
        this.permissionManager = permissionManager;
        this.componentLocator = componentLocator;
    }

    public List<ChangeHistory> getChangeHistories(Issue issue) {
        return this.getAllChangeHistories((Iterable<Issue>)ImmutableList.of((Object)issue));
    }

    public List<ChangeHistory> getChangeHistoriesForUser(Issue issue, User remoteUser) {
        return this.getAllChangeHistories((Iterable<Issue>)ImmutableList.of((Object)issue));
    }

    public List<ChangeHistory> getChangeHistoriesForUser(Iterable<Issue> issues, User remoteUser) {
        return this.getAllChangeHistories(issues);
    }

    private List<ChangeHistory> getAllChangeHistories(Iterable<Issue> issues) {
        Assertions.notNull((String)"issues", issues);
        return ChangeHistoryBatch.createBatchForIssue(issues, this.ofBizDelegator, this.issueManager, this.userManager).asList();
    }

    public List<ChangeItemBean> getChangeItemsForField(Issue issue, String changeItemFieldName) {
        Assertions.notNull((String)"issue", (Object)issue);
        Assertions.notBlank((String)"changeItemFieldName", (String)changeItemFieldName);
        if (issue.getId() == null) {
            return Collections.emptyList();
        }
        List changeItemsForFieldGVs = this.ofBizDelegator.findByAnd("ChangeGroupChangeItemView", (Map)ImmutableMap.of((Object)"issue", (Object)issue.getId(), (Object)"field", (Object)changeItemFieldName), (List)ImmutableList.of((Object)"created ASC", (Object)"changeitemid ASC"));
        ArrayList<ChangeItemBean> changeItemsForField = new ArrayList<ChangeItemBean>(changeItemsForFieldGVs.size());
        for (GenericValue changeItemGV : changeItemsForFieldGVs) {
            changeItemsForField.add(new ChangeItemBean(changeItemGV.getString("fieldtype"), changeItemGV.getString("field"), changeItemGV.getString("oldvalue"), changeItemGV.getString("oldstring"), changeItemGV.getString("newvalue"), changeItemGV.getString("newstring"), changeItemGV.getTimestamp("created")));
        }
        return changeItemsForField;
    }

    public List<ChangeHistoryItem> getAllChangeItems(Issue issue) {
        Assertions.notNull((String)"issue", (Object)issue);
        if (issue.getId() == null) {
            return Collections.emptyList();
        }
        List changeItemsGVs = this.ofBizDelegator.findByAnd("ChangeGroupChangeItemView", (Map)ImmutableMap.of((Object)"issue", (Object)issue.getId()), (List)ImmutableList.of((Object)"created ASC", (Object)"changeitemid ASC"));
        HashMap fieldsPerChangeGroup = Maps.newHashMap();
        ArrayList builders = Lists.newArrayList();
        for (GenericValue changeItemGV : changeItemsGVs) {
            ChangeHistoryItem.Builder builder;
            Long changeGroupId = changeItemGV.getLong("changegroupid");
            String fieldName = changeItemGV.getString("field");
            HashMap<String, ChangeHistoryItem.Builder> buildersPerField = (HashMap<String, ChangeHistoryItem.Builder>)fieldsPerChangeGroup.get(changeGroupId);
            if (buildersPerField == null) {
                buildersPerField = new HashMap<String, ChangeHistoryItem.Builder>();
                fieldsPerChangeGroup.put(changeGroupId, buildersPerField);
            }
            if (buildersPerField.containsKey(fieldName)) {
                builder = (ChangeHistoryItem.Builder)buildersPerField.get(fieldName);
                builder.changedFrom(changeItemGV.getString("oldstring"), changeItemGV.getString("oldvalue"));
                builder.to(changeItemGV.getString("newstring"), changeItemGV.getString("newvalue"));
                continue;
            }
            builder = new ChangeHistoryItem.Builder().withId(changeItemGV.getLong("changeitemid")).inChangeGroup(changeGroupId).inProject(issue.getProjectObject().getId()).forIssue(issue.getId(), issue.getKey()).field(changeItemGV.getString("field")).on(changeItemGV.getTimestamp("created")).changedFrom(changeItemGV.getString("oldstring"), changeItemGV.getString("oldvalue")).to(changeItemGV.getString("newstring"), changeItemGV.getString("newvalue")).byUser(changeItemGV.getString("author"));
            buildersPerField.put(fieldName, builder);
            builders.add(builder);
        }
        return Lists.transform((List)builders, (Function)new Function<ChangeHistoryItem.Builder, ChangeHistoryItem>(){

            public ChangeHistoryItem apply(ChangeHistoryItem.Builder builder) {
                return builder.build();
            }
        });
    }

    public Issue findMovedIssue(String originalKey) {
        return this.issueManager.findMovedIssue(originalKey);
    }

    public Collection<String> getPreviousIssueKeys(Long issueId) {
        Null.not("issueId", issueId);
        try {
            EntityFieldMap condition = new EntityFieldMap((Map)ImmutableMap.of((Object)"issue", (Object)issueId, (Object)"field", (Object)FIELD_KEY), EntityOperator.AND);
            List gvs = this.ofBizDelegator.findByCondition("ChangeGroupChangeItemView", (EntityCondition)condition, (Collection)ImmutableList.of((Object)"group", (Object)"oldstring", (Object)"newstring"), (List)ImmutableList.of((Object)"group desc"));
            return this.collectPreviousIssueKeys(gvs);
        }
        catch (DataAccessException e) {
            return Collections.emptySet();
        }
    }

    public Collection<String> getPreviousIssueKeys(String issueKey) {
        Null.not("issueKey", issueKey);
        MutableIssue theIssue = this.issueManager.getIssueObject(issueKey);
        if (theIssue == null) {
            return Collections.emptySet();
        }
        return this.getPreviousIssueKeys(theIssue.getId());
    }

    public Collection<Issue> findUserHistory(User remoteUser, Collection<String> userkeys, int maxResults) {
        ArrayList<Long> projectIds = new ArrayList<Long>();
        for (Project project : this.permissionManager.getProjectObjects(10, remoteUser)) {
            projectIds.add(project.getId());
        }
        return this.doFindUserHistory(remoteUser, userkeys, projectIds, maxResults);
    }

    public Collection<Issue> findUserHistory(User remoteUser, Collection<String> userkeys, Collection<Project> projects, int maxResults) {
        ArrayList<Long> filteredProjectIds = new ArrayList<Long>();
        for (Project project : projects) {
            if (!this.permissionManager.hasPermission(10, project, remoteUser)) continue;
            filteredProjectIds.add(project.getId());
        }
        return this.doFindUserHistory(remoteUser, userkeys, filteredProjectIds, maxResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Map<String, String> findAllPossibleValues(String field) {
        Null.not("field", field);
        OfBizListIterator iterator = this.getAllChangeItemsContainingValueAndString(field);
        if (iterator != null) {
            try {
                Map<String, String> map = this.collectFieldValues(iterator);
                return map;
            }
            finally {
                iterator.close();
            }
        }
        return Collections.emptyMap();
    }

    @Nullable
    private OfBizListIterator getAllChangeItemsContainingValueAndString(String field) {
        EntityExpr condition = new EntityExpr((EntityCondition)new EntityFieldMap((Map)ImmutableMap.of((Object)"field", (Object)field), EntityOperator.AND), EntityOperator.AND, (EntityCondition)new EntityConditionList((List)ImmutableList.of((Object)new EntityExpr((EntityCondition)new EntityExpr("oldvalue", EntityOperator.NOT_EQUAL, null), EntityOperator.AND, (EntityCondition)new EntityExpr("oldstring", EntityOperator.NOT_EQUAL, null)), (Object)new EntityExpr((EntityCondition)new EntityExpr("newvalue", EntityOperator.NOT_EQUAL, null), EntityOperator.AND, (EntityCondition)new EntityExpr("newstring", EntityOperator.NOT_EQUAL, null))), EntityOperator.OR));
        try {
            return this.ofBizDelegator.findListIteratorByCondition("ChangeItem", (EntityCondition)condition, null, (Collection)ImmutableList.of((Object)"oldstring", (Object)"oldvalue", (Object)"newstring", (Object)"newvalue"), (List)ImmutableList.of((Object)"asc"), null);
        }
        catch (DataAccessException e) {
            log.error((Object)("Unable to retrieve values for " + field), (Throwable)e);
            return null;
        }
    }

    public void removeAllChangeItems(Issue issue) {
        ImmutableMap params = ImmutableMap.of((Object)"issue", (Object)issue.getId());
        List changeGroups = this.ofBizDelegator.findByAnd("ChangeGroup", (Map)params);
        for (GenericValue changeGroup : changeGroups) {
            this.ofBizDelegator.removeByAnd("ChangeItem", (Map)ImmutableMap.of((Object)"group", (Object)changeGroup.getLong("id")));
        }
        this.ofBizDelegator.removeByAnd("ChangeGroup", (Map)params);
    }

    private Map<String, String> collectFieldValues(OfBizListIterator genericValuesIterator) {
        MapBuilder builder = MapBuilder.newBuilder();
        for (GenericValue gv : genericValuesIterator) {
            if (StringUtils.isNotBlank((String)gv.getString("oldstring")) && StringUtils.isNotBlank((String)gv.getString("oldvalue"))) {
                builder.add((Object)gv.getString("oldstring").toLowerCase(), (Object)gv.getString("oldvalue").toLowerCase());
            }
            if (!StringUtils.isNotBlank((String)gv.getString("newstring")) || !StringUtils.isNotBlank((String)gv.getString("newvalue"))) continue;
            builder.add((Object)gv.getString("newstring").toLowerCase(), (Object)gv.getString("newvalue").toLowerCase());
        }
        return builder.toMap();
    }

    Collection<Issue> doFindUserHistory(User remoteUser, Collection<String> userkeys, Collection<Long> projects, int maxResults) {
        if (projects.isEmpty()) {
            return Collections.emptyList();
        }
        Collection<Long> issueIds = this.findMostRecentlyUpdatedIssueIds(maxResults, userkeys, projects);
        if (!issueIds.isEmpty()) {
            SearchResults searchResults;
            JqlClauseBuilder builder = JqlQueryBuilder.newBuilder().where().defaultAnd();
            builder.issue().in(issueIds.toArray(new Long[issueIds.size()])).endWhere().orderBy().createdDate(SortOrder.DESC);
            Query query = builder.buildQuery();
            SearchProvider searchProvider = (SearchProvider)this.componentLocator.getComponentInstanceOfType(SearchProvider.class);
            try {
                searchResults = searchProvider.search(query, remoteUser, PagerFilter.getUnlimitedFilter());
            }
            catch (SearchException e) {
                log.error((Object)("Error running query '" + query + "'"));
                return Collections.emptyList();
            }
            return Collections.unmodifiableList(searchResults.getIssues());
        }
        return Collections.emptyList();
    }

    private Collection<Long> findMostRecentlyUpdatedIssueIds(int maxResults, Collection<String> userkeys, Collection<Long> projects) {
        if (userkeys == null) {
            return this.findMostRecentlyUpdatedIssueIds(projects, maxResults);
        }
        return this.findMostRecentlyUpdatedIssueIdsByUsers(projects, userkeys, maxResults);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Long> findMostRecentlyUpdatedIssueIdsByUsers(Collection<Long> projects, @Nonnull Collection<String> userkeys, int maxResults) {
        LinkedHashSet<Long> issueIds = new LinkedHashSet<Long>();
        OfBizListIterator changeGroupIssueViewIt = null;
        OfBizListIterator actionIssueViewIt = null;
        try {
            EntityConditionList entityCondition = new EntityConditionList((List)ImmutableList.of((Object)new EntityExpr("project", EntityOperator.IN, projects), (Object)new EntityExpr("author", EntityOperator.IN, userkeys)), EntityOperator.AND);
            EntityFindOptions entityFindOptions = EntityFindOptions.findOptions().maxResults(maxResults);
            changeGroupIssueViewIt = this.ofBizDelegator.findListIteratorByCondition("ChangeGroupIssueView", (EntityCondition)entityCondition, null, FIELDS_TO_SELECT, (List)ImmutableList.of((Object)"created DESC"), entityFindOptions);
            issueIds.addAll(this.extractIssueIds(maxResults, changeGroupIssueViewIt));
            actionIssueViewIt = this.ofBizDelegator.findListIteratorByCondition("ActionIssueView", (EntityCondition)entityCondition, null, FIELDS_TO_SELECT, (List)ImmutableList.of((Object)"created DESC"), entityFindOptions);
            issueIds.addAll(this.extractIssueIds(maxResults, actionIssueViewIt));
            LinkedHashSet<Long> linkedHashSet = issueIds;
            return linkedHashSet;
        }
        finally {
            if (actionIssueViewIt != null) {
                actionIssueViewIt.close();
            }
            if (changeGroupIssueViewIt != null) {
                changeGroupIssueViewIt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Long> findMostRecentlyUpdatedIssueIds(Collection<Long> projects, int maxResults) {
        OfBizListIterator issuesIt = this.ofBizDelegator.findListIteratorByCondition("Issue", (EntityCondition)new EntityExpr("project", EntityOperator.IN, projects), null, (Collection)ImmutableList.of((Object)"id"), (List)ImmutableList.of((Object)"updated DESC"), EntityFindOptions.findOptions().maxResults(maxResults));
        try {
            LinkedHashSet issueIds = Sets.newLinkedHashSet();
            for (GenericValue issueIdGV : issuesIt) {
                issueIds.add(issueIdGV.getLong("id"));
            }
            LinkedHashSet linkedHashSet = issueIds;
            return linkedHashSet;
        }
        finally {
            issuesIt.close();
        }
    }

    private Set<Long> extractIssueIds(int maxResults, OfBizListIterator iterator) {
        LinkedHashSet<Long> issueIds = new LinkedHashSet<Long>();
        GenericValue issueIdGV = iterator.next();
        for (int issuesLeft = maxResults; issueIdGV != null && issuesLeft > 0; --issuesLeft) {
            issueIds.add(issueIdGV.getLong(ISSUEID_FIELD));
            issueIdGV = iterator.next();
        }
        return issueIds;
    }

    private Collection<String> collectPreviousIssueKeys(List<GenericValue> issueChangeItemIteratorGVs) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (GenericValue issueChangeItemIteratorGV : issueChangeItemIteratorGVs) {
            String oldString = issueChangeItemIteratorGV.getString("oldstring");
            if (!StringUtils.isNotEmpty((String)oldString)) continue;
            result.add(oldString);
        }
        return result;
    }

    private GenericValue getLastChangeItem(List<GenericValue> changeItems) {
        GenericValue lastChangeItem = null;
        for (GenericValue changeItem : changeItems) {
            if (lastChangeItem != null && lastChangeItem.getLong("id").compareTo(changeItem.getLong("id")) >= 0) continue;
            lastChangeItem = changeItem;
        }
        return lastChangeItem;
    }
}

