/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class IssueUtilsBean {
    private static final Logger log = Logger.getLogger(IssueUtilsBean.class);
    private final WorkflowManager workflowManager;
    private final JiraAuthenticationContext authenticationContext;
    private final IssueWorkflowManager issueWorkflowManager;

    public IssueUtilsBean(WorkflowManager workflowManager, JiraAuthenticationContext authenticationContext, IssueWorkflowManager issueWorkflowManager) {
        this.workflowManager = workflowManager;
        this.authenticationContext = authenticationContext;
        this.issueWorkflowManager = issueWorkflowManager;
    }

    public Map<Integer, ActionDescriptor> loadAvailableActions(Issue issueObject) {
        LinkedHashMap<Integer, ActionDescriptor> availableActions = new LinkedHashMap<Integer, ActionDescriptor>();
        for (ActionDescriptor actionDescriptor : this.issueWorkflowManager.getAvailableActions(issueObject)) {
            availableActions.put(actionDescriptor.getId(), actionDescriptor);
        }
        return availableActions;
    }

    public boolean isValidAction(Issue issue, int action) {
        return this.loadAvailableActions(issue).containsKey(action);
    }

    public Workflow getWorkflow() {
        return this.workflowManager.makeWorkflow(this.authenticationContext.getUser());
    }

    @Deprecated
    public GenericValue setPriority(GenericValue issue, User remoteUser, String priority) throws Exception {
        return IssueUtils.setPriority(issue, remoteUser, priority);
    }
}

