/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.portal.PortalPage;
import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.SharedEntityAccessor;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.OrderByImpl;
import com.atlassian.query.order.SearchSort;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SharedEntityResolver {
    private final SharedEntityAccessor.Factory accessorFactory;

    public SharedEntityResolver(SharedEntityAccessor.Factory accessorFactory) {
        this.accessorFactory = accessorFactory;
    }

    public Collection<SharedEntity> getSharedEntities(ReplicatedIndexOperation.SharedEntityType entityType, Set<Long> ids) {
        HashSet sharedEntities = Sets.newHashSet();
        SharedEntity.TypeDescriptor typeDescriptor = entityType.getTypeDescriptor();
        SharedEntityAccessor sharedEntityAccessor = this.accessorFactory.getSharedEntityAccessor(typeDescriptor);
        for (Long id : ids) {
            SharedEntity sharedEntity = sharedEntityAccessor.getSharedEntity(id);
            if (sharedEntity == null) continue;
            sharedEntities.add(sharedEntity);
        }
        return sharedEntities;
    }

    public Collection<SharedEntity> getDummySharedEntities(ReplicatedIndexOperation.SharedEntityType entityType, Set<Long> ids) {
        HashSet sharedEntities = Sets.newHashSet();
        for (Long id : ids) {
            if (entityType.getTypeDescriptor().equals((Object)SearchRequest.ENTITY_TYPE)) {
                sharedEntities.add(new SearchRequest((Query)new QueryImpl(null, (OrderBy)new OrderByImpl(new SearchSort[0]), null), "", "dummy", "dummyDescription", id, 0L));
                continue;
            }
            sharedEntities.add(PortalPage.name((String)"dummy").id(id).build());
        }
        return sharedEntities;
    }
}

