/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.index.ha.ReplicatedIndexOperationFactory;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class OfBizReplicatedIndexOperationStore {
    private final OfBizDelegator ofBizDelegator;
    private final LazyReference<ClusterManager> clusterManagerRef = new LazyReference<ClusterManager>(){

        protected ClusterManager create() throws Exception {
            return (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
        }
    };
    private final ReplicatedIndexOperationFactory operationFactory;
    private static final String MAX_VIEW = "IndexOperationMaxIdForNodeId";

    public OfBizReplicatedIndexOperationStore(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
        this.operationFactory = new ReplicatedIndexOperationFactory();
    }

    @Nullable
    public ReplicatedIndexOperation createIndexOperation(@Nonnull Timestamp indexTime, @Nonnull ReplicatedIndexOperation.AffectedIndex affectedIndex, @Nonnull ReplicatedIndexOperation.SharedEntityType entityType, @Nonnull ReplicatedIndexOperation.Operation operation, @Nonnull Set<Long> affectedIds) {
        String nodeId = ((ClusterManager)this.clusterManagerRef.get()).getNodeId();
        if (nodeId != null && (affectedIds.size() > 0 || affectedIndex.equals((Object)ReplicatedIndexOperation.AffectedIndex.ALL))) {
            Map indexOperationFields = this.getIndexOperationFields(indexTime, affectedIndex, entityType, operation, nodeId, affectedIds);
            return this.operationFactory.build(this.ofBizDelegator.createValue("ReplicatedIndexOperation", indexOperationFields));
        }
        return null;
    }

    public Set<ReplicatedIndexOperation> getIndexOperationsAfter(Date sinceTime) {
        HashSet replicatedIndexOperations = Sets.newHashSet();
        String nodeId = ((ClusterManager)this.clusterManagerRef.get()).getNodeId();
        ImmutableList entityConditions = ImmutableList.of((Object)new EntityExpr("nodeId", EntityOperator.NOT_EQUAL, (Object)nodeId), (Object)new EntityExpr("indexTime", EntityOperator.GREATER_THAN, (Object)sinceTime));
        List gvs = this.ofBizDelegator.findByAnd("ReplicatedIndexOperation", (List)entityConditions);
        for (GenericValue gv : gvs) {
            replicatedIndexOperations.add(this.operationFactory.build(gv));
        }
        return replicatedIndexOperations;
    }

    public int deleteOperationsBefore(Date before) {
        EntityExpr deleteCondition = new EntityExpr("indexTime", EntityOperator.LESS_THAN, (Object)new Timestamp(before.getTime()));
        return this.ofBizDelegator.removeByCondition("ReplicatedIndexOperation", (EntityCondition)deleteCondition);
    }

    public Set<ReplicatedIndexOperation> getIndexOperationsAfter(Long id) {
        HashSet replicatedIndexOperations = Sets.newHashSet();
        String nodeId = ((ClusterManager)this.clusterManagerRef.get()).getNodeId();
        ImmutableList entityConditions = ImmutableList.of((Object)new EntityExpr("nodeId", EntityOperator.NOT_EQUAL, (Object)nodeId), (Object)new EntityExpr("id", EntityOperator.GREATER_THAN, (Object)id));
        List gvs = this.ofBizDelegator.findByAnd("ReplicatedIndexOperation", (List)entityConditions);
        for (GenericValue gv : gvs) {
            replicatedIndexOperations.add(this.operationFactory.build(gv));
        }
        return replicatedIndexOperations;
    }

    public long largestIdForNode(Long nodeId) {
        Map<Long, Long> ids = this.getLargestIds();
        Long id = ids.get(nodeId);
        if (id == null) {
            id = new Long(0L);
        }
        return id;
    }

    public boolean contains(long id) {
        GenericValue gv = this.ofBizDelegator.findByPrimaryKey("ReplicatedIndexOperation", Long.valueOf(id));
        return gv != null;
    }

    private Map<Long, Long> getLargestIds() {
        List gvs = this.ofBizDelegator.findAll(MAX_VIEW);
        HashMap maximumIdsPerNode = Maps.newHashMap();
        for (GenericValue gv : gvs) {
            maximumIdsPerNode.put(gv.getLong("nodeId"), gv.getLong("max"));
        }
        return maximumIdsPerNode;
    }

    private String serialize(Set<Long> ids) {
        return StringUtils.join(ids, (String)",");
    }

    private Map getIndexOperationFields(Timestamp indexTime, ReplicatedIndexOperation.AffectedIndex affectedIndex, ReplicatedIndexOperation.SharedEntityType entityType, ReplicatedIndexOperation.Operation operation, String nodeId, Set<Long> affectedIds) {
        Map fields = MapBuilder.newBuilder().add((Object)"indexTime", (Object)indexTime).add((Object)"operation", (Object)operation.toString()).add((Object)"nodeId", (Object)nodeId).add((Object)"affectedIndex", (Object)affectedIndex.toString()).add((Object)"entityType", (Object)entityType.toString()).add((Object)"affectedIds", (Object)this.serialize(affectedIds)).toMap();
        return fields;
    }
}

