/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index;

import com.atlassian.jira.index.Index;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.util.concurrent.Timeout;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public final class CompositeResultBuilder {
    private final Collection<Index.Result> results = new LinkedBlockingQueue<Index.Result>();
    private final Collection<Runnable> completionTasks = new LinkedList<Runnable>();

    public CompositeResultBuilder add(@Nonnull Index.Result result) {
        this.removeDone();
        this.results.add((Index.Result)Assertions.notNull((String)"result", (Object)result));
        return this;
    }

    public CompositeResultBuilder addCompletionTask(@Nonnull Runnable runnable) {
        this.completionTasks.add((Runnable)Assertions.notNull((String)"runnable", (Object)runnable));
        return this;
    }

    public Index.Result toResult() {
        return new CompositeResult(this.results, this.completionTasks);
    }

    private void removeDone() {
        if (this.results.size() % 100 == 0) {
            Iterator<Index.Result> iterator = this.results.iterator();
            while (iterator.hasNext()) {
                Index.Result result = iterator.next();
                if (!result.isDone()) continue;
                iterator.remove();
            }
        }
    }

    static class CompositeResult
    implements Index.Result {
        private final Collection<Index.Result> results;
        private final Queue<Runnable> completionTasks;

        CompositeResult(Collection<Index.Result> results, Collection<Runnable> completionTasks) {
            this.results = new LinkedBlockingQueue<Index.Result>(results);
            this.completionTasks = new LinkedList<Runnable>(completionTasks);
        }

        @Override
        public void await() {
            Iterator<Index.Result> it = this.results.iterator();
            while (it.hasNext()) {
                it.next().await();
                it.remove();
            }
            this.complete();
        }

        private void complete() {
            while (!this.completionTasks.isEmpty()) {
                Runnable task = this.completionTasks.poll();
                if (task == null) continue;
                task.run();
            }
        }

        @Override
        public boolean await(long time, TimeUnit unit) {
            Timeout timeout = Timeout.getNanosTimeout((long)time, (TimeUnit)unit);
            Iterator<Index.Result> it = this.results.iterator();
            while (it.hasNext()) {
                Index.Result result = it.next();
                if (!result.await(timeout.getTime(), timeout.getUnit())) {
                    return false;
                }
                it.remove();
            }
            this.complete();
            return true;
        }

        @Override
        public boolean isDone() {
            for (Index.Result result : this.results) {
                if (result.isDone()) continue;
                return false;
            }
            return true;
        }
    }
}

