/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.validation;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldConfiguration;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomField;
import com.atlassian.jira.imports.project.mapper.CustomFieldMapper;
import com.atlassian.jira.imports.project.mapper.IssueTypeMapper;
import com.atlassian.jira.imports.project.validation.CustomFieldMapperValidator;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import java.util.Collection;

public class CustomFieldMapperValidatorImpl
implements CustomFieldMapperValidator {
    private final CustomFieldManager customFieldManager;
    private final ConstantsManager constantsManager;
    private final ProjectManager projectManager;

    public CustomFieldMapperValidatorImpl(CustomFieldManager customFieldManager, ConstantsManager constantsManager, ProjectManager projectManager) {
        this.customFieldManager = customFieldManager;
        this.constantsManager = constantsManager;
        this.projectManager = projectManager;
    }

    @Override
    public MessageSet validateMappings(I18nHelper i18nHelper, BackupProject backupProject, IssueTypeMapper issueTypeMapper, CustomFieldMapper customFieldMapper) {
        MessageSetImpl messageSet = new MessageSetImpl();
        for (String oldId : customFieldMapper.getRequiredOldIds()) {
            boolean customFieldMapped;
            boolean bl = customFieldMapped = customFieldMapper.getMappedId(oldId) != null;
            if (customFieldMapped) {
                this.validateMappedCustomField(i18nHelper, backupProject, issueTypeMapper, customFieldMapper, (MessageSet)messageSet, oldId);
                continue;
            }
            this.validateUnmappedCustomField(i18nHelper, backupProject, issueTypeMapper, customFieldMapper, (MessageSet)messageSet, oldId);
        }
        return messageSet;
    }

    private void validateMappedCustomField(I18nHelper i18nHelper, BackupProject backupProject, IssueTypeMapper issueTypeMapper, CustomFieldMapper customFieldMapper, MessageSet messageSet, String oldId) {
        ExternalCustomFieldConfiguration oldCustomFieldConfig = backupProject.getCustomFieldConfiguration(oldId);
        String newId = customFieldMapper.getMappedId(oldId);
        CustomField newCustomField = this.customFieldManager.getCustomFieldObject(new Long(newId));
        if (!this.customFieldTypeIsImportable(oldCustomFieldConfig.getCustomField().getTypeKey())) {
            String customFieldName = oldCustomFieldConfig.getCustomField().getName();
            messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.custom.field.not.importable", customFieldName));
            messageSet.addErrorMessageInEnglish("Unable to import custom field '" + customFieldName + "'. The custom field type does not support project imports.");
        } else if (!newCustomField.getCustomFieldType().getKey().equals(oldCustomFieldConfig.getCustomField().getTypeKey())) {
            String customFieldTypeKey = oldCustomFieldConfig.getCustomField().getTypeKey();
            messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.custom.field.wrong.type", customFieldMapper.getDisplayName(oldId), customFieldTypeKey));
            messageSet.addErrorMessageInEnglish("The custom field '" + customFieldMapper.getDisplayName(oldId) + "' in the backup project is of type '" + customFieldTypeKey + "' " + "but the field with the same name in the current JIRA instance is of a different type.");
        } else if (!this.customFieldIsValidForRequiredContexts(oldCustomFieldConfig, newCustomField, oldId, customFieldMapper, issueTypeMapper, backupProject.getProject().getKey())) {
            String issueTypeNames = this.getIssueTypeDisplayNames(oldCustomFieldConfig, customFieldMapper.getIssueTypeIdsForRequiredCustomField(oldId), issueTypeMapper, i18nHelper);
            messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.custom.field.wrong.context", customFieldMapper.getDisplayName(oldId), issueTypeNames));
            messageSet.addErrorMessageInEnglish("The custom field '" + customFieldMapper.getDisplayName(oldId) + "' in the backup project is used by issue types '" + issueTypeNames + "' but the field with the same name in the current JIRA instance is not available to those issue types in this project.");
        }
    }

    private void validateUnmappedCustomField(I18nHelper i18nHelper, BackupProject backupProject, IssueTypeMapper issueTypeMapper, CustomFieldMapper customFieldMapper, MessageSet messageSet, String oldId) {
        ExternalCustomFieldConfiguration oldCustomFieldConfig = backupProject.getCustomFieldConfiguration(oldId);
        if (oldCustomFieldConfig == null) {
            return;
        }
        String customFieldTypeKey = oldCustomFieldConfig.getCustomField().getTypeKey();
        CustomFieldType type = this.customFieldManager.getCustomFieldType(customFieldTypeKey);
        if (type == null) {
            String customFieldTypeName = oldCustomFieldConfig.getCustomField().getTypeKey();
            String customFieldDisplayName = customFieldMapper.getDisplayName(oldId);
            messageSet.addWarningMessage(i18nHelper.getText("admin.errors.project.import.custom.field.plugin.missing", customFieldDisplayName, customFieldTypeName));
            messageSet.addWarningMessageInEnglish("The custom field '" + customFieldDisplayName + "' will not be imported because the custom field type '" + customFieldTypeName + "' is not installed.");
            return;
        }
        if (!(type instanceof ProjectImportableCustomField)) {
            String customFieldDisplayName = oldCustomFieldConfig.getCustomField().getName();
            messageSet.addWarningMessage(i18nHelper.getText("admin.errors.project.import.custom.field.not.importable", customFieldDisplayName));
            messageSet.addWarningMessageInEnglish("Unable to import custom field '" + customFieldDisplayName + "'. The custom field type does not support project imports.");
            return;
        }
        Collection customFieldsWithName = this.customFieldManager.getCustomFieldObjectsByName(customFieldMapper.getKey(oldId));
        if (customFieldsWithName == null || customFieldsWithName.isEmpty()) {
            messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.custom.field.does.not.exist", customFieldMapper.getDisplayName(oldId), this.getCustomFieldTypeName(oldCustomFieldConfig)));
            messageSet.addErrorMessageInEnglish("The custom field '" + customFieldMapper.getDisplayName(oldId) + "' of type '" + this.getCustomFieldTypeName(oldCustomFieldConfig) + "' is required for the import but does not exist in the current JIRA instance.");
        } else {
            boolean customFieldIsRightType = this.customFieldIsRightType(customFieldsWithName, oldCustomFieldConfig.getCustomField().getTypeKey());
            if (!customFieldIsRightType) {
                messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.custom.field.wrong.type", customFieldMapper.getDisplayName(oldId), this.getCustomFieldTypeName(oldCustomFieldConfig)));
                messageSet.addErrorMessageInEnglish("The custom field '" + customFieldMapper.getDisplayName(oldId) + "' in the backup project is of type '" + this.getCustomFieldTypeName(oldCustomFieldConfig) + "' but the field with the same name in the current JIRA instance is of a different type.");
            } else {
                String issueTypeNames = this.getIssueTypeDisplayNames(oldCustomFieldConfig, customFieldMapper.getIssueTypeIdsForRequiredCustomField(oldId), issueTypeMapper, i18nHelper);
                messageSet.addErrorMessage(i18nHelper.getText("admin.errors.project.import.custom.field.wrong.context", customFieldMapper.getDisplayName(oldId), issueTypeNames));
                messageSet.addErrorMessageInEnglish("The custom field '" + customFieldMapper.getDisplayName(oldId) + "' in the backup project is used by issue types '" + issueTypeNames + "' but the field with the same name in the current JIRA instance is not available to those issue types in this project.");
            }
        }
    }

    private String getCustomFieldTypeName(ExternalCustomFieldConfiguration oldCustomFieldConfig) {
        CustomFieldType customFieldType = this.customFieldManager.getCustomFieldType(oldCustomFieldConfig.getCustomField().getTypeKey());
        return customFieldType == null ? oldCustomFieldConfig.getCustomField().getTypeKey() : customFieldType.getName();
    }

    private boolean customFieldIsRightType(Collection customFieldsWithName, String customFieldTypeKey) {
        for (Object aCustomFieldsWithName : customFieldsWithName) {
            CustomField newCustomField = (CustomField)aCustomFieldsWithName;
            if (!customFieldTypeKey.equals(newCustomField.getCustomFieldType().getKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean customFieldIsValidForRequiredContexts(ExternalCustomFieldConfiguration externalCustomFieldConfiguration, CustomField newCustomField, String oldCustomFieldId, CustomFieldMapper customFieldMapper, IssueTypeMapper issueTypeMapper, String projectKey) {
        Project newProject = this.projectManager.getProjectObjByKey(projectKey);
        Long newProjectId = newProject == null ? null : newProject.getId();
        Collection issueTypes = customFieldMapper.getIssueTypeIdsForRequiredCustomField(oldCustomFieldId);
        if (issueTypes == null) {
            return true;
        }
        for (Object issueType : issueTypes) {
            String newIssueTypeId;
            String oldIssueTypeId = (String)issueType;
            if (!externalCustomFieldConfiguration.isConstrainedForIssueType(oldIssueTypeId) || newCustomField.getRelevantConfig((IssueContext)new IssueContextImpl(newProjectId, newIssueTypeId = issueTypeMapper.getMappedId(oldIssueTypeId))) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean customFieldTypeIsImportable(String customFieldTypeKey) {
        CustomFieldType customFieldType = this.customFieldManager.getCustomFieldType(customFieldTypeKey);
        return customFieldType != null && customFieldType instanceof ProjectImportableCustomField;
    }

    String getIssueTypeDisplayNames(ExternalCustomFieldConfiguration oldCustomFieldConfig, Collection issueTypeIdsForRequiredCustomField, IssueTypeMapper issueTypeMapper, I18nHelper i18nHelper) {
        StringBuilder sb = new StringBuilder();
        if (issueTypeIdsForRequiredCustomField == null) {
            return i18nHelper.getText("common.words.none");
        }
        int i = 0;
        for (String oldIssueTypeId : issueTypeIdsForRequiredCustomField) {
            if (oldCustomFieldConfig.isConstrainedForIssueType(oldIssueTypeId)) {
                if (i != 0) {
                    sb.append(", ");
                }
                String newIssueTypeId = issueTypeMapper.getMappedId(oldIssueTypeId);
                sb.append(this.constantsManager.getIssueTypeObject(newIssueTypeId).getNameTranslation(i18nHelper));
            }
            ++i;
        }
        return sb.toString();
    }
}

