/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.validation;

import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.imports.project.validation.MapperValidator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import org.apache.log4j.Logger;

public abstract class AbstractSimpleMapperValidator
implements MapperValidator {
    private static final Logger log = Logger.getLogger(AbstractSimpleMapperValidator.class);

    @Override
    public MessageSet validateMappings(I18nHelper i18nHelper, SimpleProjectImportIdMapper simpleProjectImportIdMapper) {
        MessageSetImpl messageSet = new MessageSetImpl();
        for (String oldId : simpleProjectImportIdMapper.getRequiredOldIds()) {
            String newId = simpleProjectImportIdMapper.getMappedId(oldId);
            if (newId != null) continue;
            if (simpleProjectImportIdMapper.getKey(oldId) == null) {
                log.warn((Object)("Project Import: The " + this.getEntityName() + " with ID '" + oldId + "' is orphan data and will be ignored."));
                continue;
            }
            messageSet.addErrorMessage(i18nHelper.getText(this.getEntityDoesNotExistKey(), simpleProjectImportIdMapper.getDisplayName(oldId)));
            messageSet.addErrorMessageInEnglish("The " + this.getEntityName() + " '" + simpleProjectImportIdMapper.getDisplayName(oldId) + "' is required for the import but does not exist in the current JIRA instance.");
        }
        return messageSet;
    }

    protected abstract String getEntityDoesNotExistKey();

    protected abstract String getEntityName();
}

