/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.external.beans.ExternalNodeAssociation;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.handler.ImportEntityHandler;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.imports.project.parser.NodeAssociationParser;
import com.atlassian.jira.imports.project.parser.NodeAssociationParserImpl;
import java.util.Map;

public class ProjectIssueSecurityLevelMapperHandler
implements ImportEntityHandler {
    private final BackupProject backupProject;
    private final SimpleProjectImportIdMapper issueSecurityLevelMapper;
    private NodeAssociationParser nodeAssocationParser;
    private String issueSecurityLevelSchemeId;
    public static final String SCHEME_ISSUE_SECURITY_LEVELS_ENTITY_NAME = "SchemeIssueSecurityLevels";
    public static final String ISSUE_SECURITY_LEVEL_SCHEME = "scheme";
    public static final String ISSUE_SECURITY_LEVEL_ID = "id";
    public static final String ISSUE_SECURITY_LEVEL_NAME = "name";
    public static final String NODE_ASSOCIATION_ISSUE_SECURITY_SCHEME = "IssueSecurityScheme";

    public ProjectIssueSecurityLevelMapperHandler(BackupProject backupProject, SimpleProjectImportIdMapper issueSecurityLevelMapper) {
        this.backupProject = backupProject;
        this.issueSecurityLevelMapper = issueSecurityLevelMapper;
    }

    @Override
    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        if ("NodeAssociation".equals(entityName)) {
            this.handleNodeAssociations(attributes);
        } else if (SCHEME_ISSUE_SECURITY_LEVELS_ENTITY_NAME.equals(entityName)) {
            this.handleSchemeIssueSecurityLevels(attributes);
        }
    }

    private void handleSchemeIssueSecurityLevels(Map attributes) {
        String schemeId = (String)attributes.get(ISSUE_SECURITY_LEVEL_SCHEME);
        if (this.issueSecurityLevelSchemeId != null && this.issueSecurityLevelSchemeId.equals(schemeId)) {
            String securityLevelId = (String)attributes.get(ISSUE_SECURITY_LEVEL_ID);
            String securityLevelName = (String)attributes.get(ISSUE_SECURITY_LEVEL_NAME);
            this.issueSecurityLevelMapper.registerOldValue(securityLevelId, securityLevelName);
        }
    }

    private void handleNodeAssociations(Map attributes) throws ParseException {
        ExternalNodeAssociation externalNodeAssociation = this.getNodeAssociationParser().parse(attributes);
        if ("Project".equals(externalNodeAssociation.getSourceNodeEntity()) && NODE_ASSOCIATION_ISSUE_SECURITY_SCHEME.equals(externalNodeAssociation.getSinkNodeEntity())) {
            String projectId = externalNodeAssociation.getSourceNodeId();
            if (this.backupProject.getProject().getId().equals(projectId)) {
                this.issueSecurityLevelSchemeId = externalNodeAssociation.getSinkNodeId();
            }
        }
    }

    private NodeAssociationParser getNodeAssociationParser() {
        if (this.nodeAssocationParser == null) {
            this.nodeAssocationParser = new NodeAssociationParserImpl();
        }
        return this.nodeAssocationParser;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectIssueSecurityLevelMapperHandler that = (ProjectIssueSecurityLevelMapperHandler)o;
        if (this.backupProject != null ? !this.backupProject.equals(that.backupProject) : that.backupProject != null) {
            return false;
        }
        if (this.issueSecurityLevelMapper != null ? !this.issueSecurityLevelMapper.equals(that.issueSecurityLevelMapper) : that.issueSecurityLevelMapper != null) {
            return false;
        }
        return !(this.issueSecurityLevelSchemeId != null ? !this.issueSecurityLevelSchemeId.equals(that.issueSecurityLevelSchemeId) : that.issueSecurityLevelSchemeId != null);
    }

    public int hashCode() {
        int result = this.backupProject != null ? this.backupProject.hashCode() : 0;
        result = 31 * result + (this.issueSecurityLevelMapper != null ? this.issueSecurityLevelMapper.hashCode() : 0);
        result = 31 * result + (this.issueSecurityLevelSchemeId != null ? this.issueSecurityLevelSchemeId.hashCode() : 0);
        return result;
    }
}

