/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.imports.project.handler.ImportEntityHandler;
import com.atlassian.jira.util.dbc.Null;
import java.io.PrintWriter;
import org.ofbiz.core.entity.model.ModelEntity;

public abstract class AbstractImportPartitionHandler
implements ImportEntityHandler {
    private final PrintWriter printWriter;
    private final String encoding;

    public AbstractImportPartitionHandler(PrintWriter printWriter, String encoding) {
        this.printWriter = printWriter;
        this.encoding = encoding;
    }

    @Override
    public void startDocument() {
        this.printWriter.println("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
        this.printWriter.println("<entity-engine-xml>");
    }

    @Override
    public void endDocument() {
        this.printWriter.print("</entity-engine-xml>");
    }

    public void assertModelEntityForName(ModelEntity modelEntity, String expectedName) {
        Null.not("modelEntity", modelEntity);
        Null.not("expectedName", expectedName);
        if (!expectedName.equals(modelEntity.getEntityName())) {
            throw new IllegalArgumentException("This handler must only be created with a " + expectedName + " model entity");
        }
    }

    public String getEncoding() {
        return this.encoding;
    }
}

