/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.external.ExternalException;
import com.atlassian.jira.external.beans.ExternalComponent;
import com.atlassian.jira.external.beans.ExternalCustomField;
import com.atlassian.jira.external.beans.ExternalProject;
import com.atlassian.jira.external.beans.ExternalProjectRoleActor;
import com.atlassian.jira.external.beans.ExternalUser;
import com.atlassian.jira.external.beans.ExternalVersion;
import com.atlassian.jira.imports.project.ProjectImportManager;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.core.BackupOverview;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.MappingResult;
import com.atlassian.jira.imports.project.core.ProjectImportData;
import com.atlassian.jira.imports.project.core.ProjectImportDataImpl;
import com.atlassian.jira.imports.project.core.ProjectImportOptions;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldConfiguration;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomFieldParser;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AttachmentFileValidatorHandler;
import com.atlassian.jira.imports.project.handler.AttachmentPersisterHandler;
import com.atlassian.jira.imports.project.handler.BackupOverviewHandler;
import com.atlassian.jira.imports.project.handler.ChainedSaxHandler;
import com.atlassian.jira.imports.project.handler.ChangeGroupPersisterHandler;
import com.atlassian.jira.imports.project.handler.ChangeItemPersisterHandler;
import com.atlassian.jira.imports.project.handler.CommentPersisterHandler;
import com.atlassian.jira.imports.project.handler.ComponentPersisterHandler;
import com.atlassian.jira.imports.project.handler.CustomFieldMapperHandler;
import com.atlassian.jira.imports.project.handler.CustomFieldOptionsMapperHandler;
import com.atlassian.jira.imports.project.handler.CustomFieldValuePersisterHandler;
import com.atlassian.jira.imports.project.handler.CustomFieldValueValidatorHandler;
import com.atlassian.jira.imports.project.handler.GroupMapperHandler;
import com.atlassian.jira.imports.project.handler.ImportEntityHandler;
import com.atlassian.jira.imports.project.handler.IssueComponentMapperHandler;
import com.atlassian.jira.imports.project.handler.IssueLinkMapperHandler;
import com.atlassian.jira.imports.project.handler.IssueLinkPersisterHandler;
import com.atlassian.jira.imports.project.handler.IssueMapperHandler;
import com.atlassian.jira.imports.project.handler.IssuePartitonHandler;
import com.atlassian.jira.imports.project.handler.IssuePersisterHandler;
import com.atlassian.jira.imports.project.handler.IssueRelatedEntitiesPartionHandler;
import com.atlassian.jira.imports.project.handler.IssueTypeMapperHandler;
import com.atlassian.jira.imports.project.handler.IssueVersionMapperHandler;
import com.atlassian.jira.imports.project.handler.LabelsPersisterHandler;
import com.atlassian.jira.imports.project.handler.ProjectIssueSecurityLevelMapperHandler;
import com.atlassian.jira.imports.project.handler.ProjectMapperHandler;
import com.atlassian.jira.imports.project.handler.ProjectRoleActorMapperHandler;
import com.atlassian.jira.imports.project.handler.RegisterUserMapperHandler;
import com.atlassian.jira.imports.project.handler.RequiredProjectRolesMapperHandler;
import com.atlassian.jira.imports.project.handler.SimpleEntityMapperHandler;
import com.atlassian.jira.imports.project.handler.UserAssociationPersisterHandler;
import com.atlassian.jira.imports.project.handler.UserMapperHandler;
import com.atlassian.jira.imports.project.handler.VersionPersisterHandler;
import com.atlassian.jira.imports.project.handler.WorklogPersisterHandler;
import com.atlassian.jira.imports.project.mapper.AutomaticDataMapper;
import com.atlassian.jira.imports.project.mapper.CustomFieldMapper;
import com.atlassian.jira.imports.project.mapper.IssueTypeMapper;
import com.atlassian.jira.imports.project.mapper.MapperEntityRegister;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapperImpl;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.imports.project.mapper.UserMapper;
import com.atlassian.jira.imports.project.parser.CustomFieldValueParser;
import com.atlassian.jira.imports.project.parser.CustomFieldValueParserImpl;
import com.atlassian.jira.imports.project.parser.ProjectRoleActorParser;
import com.atlassian.jira.imports.project.parser.ProjectRoleActorParserImpl;
import com.atlassian.jira.imports.project.taskprogress.EntityCountTaskProgressProcessor;
import com.atlassian.jira.imports.project.taskprogress.EntityTypeTaskProgressProcessor;
import com.atlassian.jira.imports.project.taskprogress.TaskProgressInterval;
import com.atlassian.jira.imports.project.taskprogress.TaskProgressProcessor;
import com.atlassian.jira.imports.project.util.ProjectImportTemporaryFilesImpl;
import com.atlassian.jira.imports.project.validation.ProjectImportValidators;
import com.atlassian.jira.imports.xml.BackupXmlParser;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.CachingProjectRoleAndActorStore;
import com.atlassian.jira.security.roles.ProjectRoleAndActorStore;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.concurrent.BoundedExecutor;
import com.atlassian.jira.util.dbc.Null;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelReader;
import org.ofbiz.core.entity.model.ModelViewEntity;
import org.xml.sax.SAXException;

public class DefaultProjectImportManager
implements ProjectImportManager {
    private static final Logger log = Logger.getLogger(DefaultProjectImportManager.class);
    private final BackupXmlParser backupXmlParser;
    private final DelegatorInterface genericDelegator;
    private final ApplicationProperties applicationProperties;
    private final IssueManager issueManager;
    private final IssueLinkManager issueLinkManager;
    private final CustomFieldManager customFieldManager;
    private final AutomaticDataMapper automaticDataMapper;
    private final ProjectImportValidators projectImportValidators;
    private final ProjectImportPersister projectImportPersister;
    private final UserUtil userUtil;
    private final GroupManager groupManager;
    private final ProjectRoleManager projectRoleManager;
    private final ProjectManager projectManager;
    private final ProjectRoleAndActorStore projectRoleAndActorStore;
    private static final int DEFAULT_ENTITY_COUNT = 100;
    private static final int THREAD_POOL_SIZE = 10;
    private static final int THREAD_POOL_QUEUE_SIZE = 20;

    public DefaultProjectImportManager(BackupXmlParser backupXmlParser, DelegatorInterface genericDelegator, ApplicationProperties applicationProperties, IssueManager issueManager, IssueLinkManager issueLinkManager, CustomFieldManager customFieldManager, AutomaticDataMapper automaticDataMapper, ProjectImportValidators projectImportValidators, ProjectImportPersister projectImportPersister, UserUtil userUtil, GroupManager groupManager, ProjectRoleManager projectRoleManager, ProjectManager projectManager, ProjectRoleAndActorStore projectRoleAndActorStore) {
        this.backupXmlParser = backupXmlParser;
        this.genericDelegator = genericDelegator;
        this.applicationProperties = applicationProperties;
        this.issueManager = issueManager;
        this.issueLinkManager = issueLinkManager;
        this.customFieldManager = customFieldManager;
        this.automaticDataMapper = automaticDataMapper;
        this.projectImportValidators = projectImportValidators;
        this.projectImportPersister = projectImportPersister;
        this.userUtil = userUtil;
        this.groupManager = groupManager;
        this.projectRoleManager = projectRoleManager;
        this.projectManager = projectManager;
        this.projectRoleAndActorStore = projectRoleAndActorStore;
    }

    @Override
    public BackupOverview getBackupOverview(String pathToBackupXml, TaskProgressSink taskProgressSink, I18nHelper i18n) throws IOException, SAXException {
        Null.not("pathToBackupXml", pathToBackupXml);
        ChainedSaxHandler handler = this.getChainedHandler(new EntityTypeTaskProgressProcessor(this.getTotalEntitiesCount(), taskProgressSink, i18n));
        BackupOverviewHandler backupOverviewHandler = new BackupOverviewHandler();
        handler.registerHandler(backupOverviewHandler);
        this.backupXmlParser.parseBackupXml(pathToBackupXml, handler);
        return backupOverviewHandler.getBackupOverview();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectImportData getProjectImportData(ProjectImportOptions projectImportOptions, BackupProject backupProject, BackupSystemInformation backupSystemInformation, TaskProgressProcessor taskProgressProcessor) throws IOException, SAXException {
        Null.not("backupProject", backupProject);
        Null.not("projectImportOptions", projectImportOptions);
        Null.not("pathToBackupXml", projectImportOptions.getPathToBackupXml());
        Null.not("backupSystemInformation", backupSystemInformation);
        ChainedSaxHandler handler = this.getChainedHandler(taskProgressProcessor);
        String encoding = this.getApplicationEncoding();
        PrintWriter issueFileWriter = null;
        PrintWriter customFieldValuesWriter = null;
        PrintWriter issueRelatedEntitiesWriter = null;
        PrintWriter changeItemEntitiesWriter = null;
        PrintWriter fileAttachmentEntitiesWriter = null;
        ProjectImportTemporaryFilesImpl projectImportTemporaryFiles = new ProjectImportTemporaryFilesImpl(backupProject.getProject().getKey());
        try {
            File issueXml = projectImportTemporaryFiles.getIssuesXmlFile();
            issueXml.deleteOnExit();
            issueFileWriter = this.getWriter(issueXml, encoding);
            IssuePartitonHandler issuePartitonHandler = this.getIssuePartitioner(issueFileWriter, backupProject, encoding);
            handler.registerHandler(issuePartitonHandler);
            File customFieldValuesXml = projectImportTemporaryFiles.getCustomFieldValuesXmlFile();
            customFieldValuesXml.deleteOnExit();
            customFieldValuesWriter = this.getWriter(customFieldValuesXml, encoding);
            IssueRelatedEntitiesPartionHandler customFieldPartionHandler = this.getCustomFieldValuesHandler(customFieldValuesWriter, backupProject, encoding);
            handler.registerHandler(customFieldPartionHandler);
            File issueRelatedEntitiesXml = projectImportTemporaryFiles.getIssueRelatedEntitiesXmlFile();
            issueRelatedEntitiesXml.deleteOnExit();
            issueRelatedEntitiesWriter = this.getWriter(issueRelatedEntitiesXml, encoding);
            File changeItemEntitiesXml = projectImportTemporaryFiles.getChangeItemEntitiesXmlFile();
            changeItemEntitiesXml.deleteOnExit();
            changeItemEntitiesWriter = this.getWriter(changeItemEntitiesXml, encoding);
            IssueRelatedEntitiesPartionHandler relatedEntitiesPartionHandler = this.getIssueRelatedEntitesHandler(issueRelatedEntitiesWriter, changeItemEntitiesWriter, backupProject, encoding);
            handler.registerHandler(relatedEntitiesPartionHandler);
            IssueRelatedEntitiesPartionHandler fileAttachmentHandler = null;
            if (StringUtils.isNotEmpty((String)projectImportOptions.getAttachmentPath())) {
                File fileAttachmentEntitiesXml = projectImportTemporaryFiles.getFileAttachmentEntitiesXmlFile();
                fileAttachmentEntitiesXml.deleteOnExit();
                fileAttachmentEntitiesWriter = this.getWriter(fileAttachmentEntitiesXml, encoding);
                fileAttachmentHandler = this.getFileAttachmentHandler(fileAttachmentEntitiesWriter, backupProject, encoding);
                handler.registerHandler(fileAttachmentHandler);
            }
            ProjectImportMapperImpl projectImportMapper = new ProjectImportMapperImpl(this.userUtil, this.groupManager);
            this.populateCustomFieldMapperOldValues(backupProject, projectImportMapper.getCustomFieldMapper());
            this.populateVersionMapperOldValues(backupProject, projectImportMapper.getVersionMapper());
            this.populateComponentMapperOldValues(backupProject, projectImportMapper.getComponentMapper());
            handler.registerHandler(this.getUserMapperHandler(projectImportOptions, backupProject, projectImportMapper));
            handler.registerHandler(this.getGroupMapperHandler(backupProject, projectImportMapper));
            handler.registerHandler(this.getIssueMapperHandler(backupProject, projectImportMapper));
            handler.registerHandler(this.getProjectIssueSecurityLevelMapperHandler(backupProject, projectImportMapper));
            handler.registerHandler(this.getIssueTypeMapperHandler(projectImportMapper));
            handler.registerHandler(this.getPriorityMapperHandler(projectImportMapper));
            handler.registerHandler(this.getResolutionMapperHandler(projectImportMapper));
            handler.registerHandler(this.getStatusMapperHandler(projectImportMapper));
            handler.registerHandler(this.getCustomFieldMapperHandler(backupProject, projectImportMapper));
            handler.registerHandler(this.getProjectMapperHandler(projectImportMapper));
            handler.registerHandler(this.getCustomFieldOptionMapperHandler(projectImportMapper));
            handler.registerHandler(this.getProjectRoleRegistrationHandler(projectImportMapper));
            handler.registerHandler(this.getRequiredProjectRolesMapperHandler(backupProject, projectImportMapper));
            handler.registerHandler(this.getIssueVersionMapperHandler(backupProject, projectImportMapper));
            handler.registerHandler(this.getIssueComponentMapperHandler(backupProject, projectImportMapper));
            handler.registerHandler(this.getIssueLinkMapperHandler(backupProject, backupSystemInformation, projectImportMapper));
            handler.registerHandler(this.getRegisterUserMapperHandler(projectImportMapper));
            handler.registerHandler(this.getProjectRoleActorMapperHandler(backupProject, projectImportMapper));
            this.backupXmlParser.parseBackupXml(projectImportOptions.getPathToBackupXml(), handler);
            projectImportMapper.getCustomFieldMapper().registerIssueTypesInUse();
            int fileAttachmentCount = 0;
            if (fileAttachmentHandler != null) {
                fileAttachmentCount = fileAttachmentHandler.getEntityCount();
            }
            ProjectImportDataImpl projectImportDataImpl = new ProjectImportDataImpl(projectImportMapper, projectImportTemporaryFiles, issuePartitonHandler.getEntityCount(), customFieldPartionHandler.getEntityCount(), relatedEntitiesPartionHandler.getEntityCount(), fileAttachmentCount, relatedEntitiesPartionHandler.getChangeItemEntityCount());
            return projectImportDataImpl;
        }
        finally {
            if (issueFileWriter != null) {
                issueFileWriter.close();
            }
            if (customFieldValuesWriter != null) {
                customFieldValuesWriter.close();
            }
            if (issueRelatedEntitiesWriter != null) {
                issueRelatedEntitiesWriter.close();
            }
            if (changeItemEntitiesWriter != null) {
                changeItemEntitiesWriter.close();
            }
            if (fileAttachmentEntitiesWriter != null) {
                fileAttachmentEntitiesWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createMissingUsers(final UserMapper userMapper, final ProjectImportResults projectImportResults, TaskProgressInterval taskProgressInterval) throws AbortImportException {
        final I18nHelper i18n = projectImportResults.getI18n();
        Collection users = userMapper.getUsersToAutoCreate();
        final EntityCountTaskProgressProcessor taskProgressProcessor = new EntityCountTaskProgressProcessor(taskProgressInterval, i18n.getText("admin.message.project.import.manager.do.import.importing.users"), users.size(), i18n);
        final AtomicInteger count = new AtomicInteger(0);
        BoundedExecutor executor = this.createExecutor("ProjectImport: CreateUsers");
        try {
            for (final ExternalUser user : users) {
                if (projectImportResults.abortImport()) {
                    break;
                }
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        boolean userCreated = DefaultProjectImportManager.this.projectImportPersister.createUser(userMapper, user);
                        if (!userCreated) {
                            projectImportResults.addError(i18n.getText("admin.errors.project.import.could.not.create.user", user.getName()));
                        } else {
                            projectImportResults.incrementUsersCreatedCount();
                        }
                        int currentCount = count.incrementAndGet();
                        taskProgressProcessor.processTaskProgress(i18n.getText("admin.common.words.users"), currentCount);
                    }
                });
            }
        }
        finally {
            if (projectImportResults.abortImport()) {
                executor.shutdownAndIgnoreQueue();
                throw new AbortImportException();
            }
            executor.shutdownAndWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importProjectRoleMembers(Project project, final ProjectImportMapper projectImportMapper, final ProjectImportResults projectImportResults, TaskProgressInterval taskProgressInterval) throws AbortImportException {
        final I18nHelper i18n = projectImportResults.getI18n();
        this.projectRoleManager.removeAllRoleActorsByProject(project);
        final ProjectRoleActorParser projectRoleActorParser = this.getProjectRoleActorParser();
        Collection projectRoleActors = projectImportMapper.getProjectRoleActorMapper().getAllProjectRoleActors();
        final EntityCountTaskProgressProcessor taskProgressProcessor = new EntityCountTaskProgressProcessor(taskProgressInterval, i18n.getText("admin.common.words.projectrole"), projectRoleActors.size(), i18n);
        final AtomicInteger count = new AtomicInteger(0);
        BoundedExecutor executor = this.createExecutor("ProjectImport: CreateRoleMemebers");
        try {
            for (Object projectRoleActor1 : projectRoleActors) {
                if (projectImportResults.abortImport()) {
                    break;
                }
                final ExternalProjectRoleActor projectRoleActor = (ExternalProjectRoleActor)projectRoleActor1;
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (projectRoleActor.isUserActor()) {
                            DefaultProjectImportManager.this.createUserRoleActor(projectImportMapper, projectImportResults, projectRoleActorParser, projectRoleActor);
                        } else if (projectRoleActor.isGroupActor()) {
                            DefaultProjectImportManager.this.createGroupRoleActor(projectImportMapper, projectImportResults, projectRoleActorParser, projectRoleActor);
                        } else {
                            String projectRoleName = projectImportMapper.getProjectRoleMapper().getDisplayName(projectRoleActor.getRoleId());
                            log.warn((Object)("Project role '" + projectRoleName + "' contains a project role actor '" + projectRoleActor.getRoleActor() + "' with unknown role type '" + projectRoleActor.getRoleType() + "', we cannot add this actor to the project role."));
                        }
                        int currentCount = count.incrementAndGet();
                        taskProgressProcessor.processTaskProgress(i18n.getText("admin.common.words.projectrole"), currentCount);
                    }
                });
            }
        }
        finally {
            executor.shutdownAndWait();
            if (this.projectRoleAndActorStore instanceof CachingProjectRoleAndActorStore) {
                ((CachingProjectRoleAndActorStore)this.projectRoleAndActorStore).clearCaches();
            }
            if (projectImportResults.abortImport()) {
                throw new AbortImportException();
            }
        }
    }

    @Override
    public void importProject(ProjectImportOptions projectImportOptions, ProjectImportMapper projectImportMapper, BackupProject backupProject, ProjectImportResults projectImportResults, TaskProgressInterval taskProgressInterval) throws AbortImportException {
        Map<String, ProjectComponent> newComponents;
        Map<String, Version> newVersions;
        Project project;
        SimpleProjectImportIdMapper projectMapper = projectImportMapper.getProjectMapper();
        ExternalProject externalProject = backupProject.getProject();
        ExternalProject transformedProject = this.transformProject(externalProject, projectImportMapper);
        if (projectMapper.getMappedId(externalProject.getId()) == null) {
            try {
                project = this.projectImportPersister.createProject(transformedProject);
            }
            catch (ExternalException e) {
                log.error((Object)("An error occurred while trying to create the project '" + externalProject.getKey() + "' for project import. The import will be aborted."));
                throw new AbortImportException();
            }
            projectMapper.mapValue(externalProject.getId(), project.getId().toString());
        } else {
            project = projectImportOptions.overwriteProjectDetails() ? this.projectImportPersister.updateProjectDetails(transformedProject) : this.projectManager.getProjectObjByKey(externalProject.getKey());
        }
        projectImportResults.setImportedProject(project);
        try {
            this.projectImportPersister.updateProjectIssueCounter(backupProject, Long.parseLong(externalProject.getCounter()));
        }
        catch (NumberFormatException e) {
            log.warn((Object)("The backup project '" + externalProject.getKey() + "' has an invalid issue counter '" + externalProject.getCounter() + "'. The import will continue, but issue creation may produce warnings in the log."));
        }
        try {
            newVersions = this.projectImportPersister.createVersions(backupProject);
        }
        catch (DataAccessException e) {
            throw new AbortImportException();
        }
        this.populateVersionMapper(projectImportMapper.getVersionMapper(), newVersions);
        try {
            newComponents = this.projectImportPersister.createComponents(backupProject, projectImportMapper);
        }
        catch (DataAccessException e) {
            throw new AbortImportException();
        }
        this.populateComponentMapper(projectImportMapper.getComponentMapper(), newComponents);
        if (projectImportOptions.overwriteProjectDetails()) {
            this.importProjectRoleMembers(project, projectImportMapper, projectImportResults, taskProgressInterval);
        }
    }

    private ExternalProject transformProject(ExternalProject externalProject, ProjectImportMapper projectImportMapper) {
        ExternalProject transformedProject = new ExternalProject();
        transformedProject.setId(externalProject.getId());
        transformedProject.setKey(externalProject.getKey());
        transformedProject.setName(externalProject.getName());
        transformedProject.setAssigneeType(externalProject.getAssigneeType());
        transformedProject.setCounter(externalProject.getCounter());
        transformedProject.setDescription(externalProject.getDescription());
        transformedProject.setEmailSender(externalProject.getEmailSender());
        transformedProject.setLead(projectImportMapper.getUserMapper().getMappedUserKey(externalProject.getLead()));
        transformedProject.setProjectCategoryName(externalProject.getProjectCategoryName());
        transformedProject.setProjectGV(externalProject.getProjectGV());
        transformedProject.setUrl(externalProject.getUrl());
        return transformedProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doImport(ProjectImportOptions projectImportOptions, ProjectImportData projectImportData, BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportResults projectImportResults, TaskProgressInterval taskProgressInterval, I18nHelper i18n, User importAuthor) throws IOException, SAXException, IndexException {
        ProjectImportMapper projectImportMapper = projectImportData.getProjectImportMapper();
        try {
            this.subvertSecurityIndexingNotifications();
            TaskProgressInterval issuesSubInterval = this.getSubInterval(taskProgressInterval, 0, 20);
            long largestIssueKeyNumber = this.importIssues(projectImportData, projectImportResults, i18n, importAuthor, projectImportMapper, issuesSubInterval);
            TaskProgressInterval issuesRelatedSubInterval = this.getSubInterval(taskProgressInterval, 20, 35);
            this.importIssueRelatedData(projectImportData, backupSystemInformation, projectImportResults, i18n, importAuthor, projectImportMapper, issuesRelatedSubInterval);
            TaskProgressInterval changeItemInterval = this.getSubInterval(taskProgressInterval, 35, 40);
            this.importChangeItemData(projectImportData, projectImportResults, i18n, projectImportMapper, changeItemInterval);
            TaskProgressInterval attachmentSubInterval = this.getSubInterval(taskProgressInterval, 40, 60);
            this.importAttachments(projectImportOptions, projectImportData, backupProject, backupSystemInformation, projectImportResults, i18n, attachmentSubInterval);
            TaskProgressInterval custFieldValueSubInterval = this.getSubInterval(taskProgressInterval, 60, 80);
            this.importCustomFieldValues(projectImportData, backupProject, backupSystemInformation, projectImportResults, i18n, projectImportMapper, custFieldValueSubInterval);
            this.projectImportPersister.updateProjectIssueCounter(backupProject, largestIssueKeyNumber);
        }
        finally {
            this.restoreSecurityIndexingNotifications();
            this.issueLinkManager.clearCache();
            log.info((Object)"Re-indexing the Project.");
            TaskProgressInterval reIndexSubInterval = this.getSubInterval(taskProgressInterval, 80, 100);
            this.projectImportPersister.reIndexProject(projectImportMapper, reIndexSubInterval, i18n);
            log.info((Object)"Finished re-indexing the Project.");
        }
    }

    @Override
    public void validateCustomFieldValues(ProjectImportData projectImportData, MappingResult mappingResult, BackupProject backupProject, TaskProgressProcessor taskProgressProcessor, I18nHelper i18n) throws IOException, SAXException {
        Null.not("backupProject", backupProject);
        Null.not("mappingResult", mappingResult);
        Null.not("projectImportData", projectImportData);
        Null.not("projectImportMapper", projectImportData.getProjectImportMapper());
        Null.not("pathToCustomFieldValuesXml", projectImportData.getPathToCustomFieldValuesXml());
        ChainedSaxHandler handler = this.getChainedHandler(taskProgressProcessor);
        CustomFieldValueValidatorHandler valueValidatorHandler = this.getCustomFieldValueValidatorHandler(backupProject, projectImportData.getProjectImportMapper());
        handler.registerHandler(valueValidatorHandler);
        this.backupXmlParser.parseBackupXml(projectImportData.getPathToCustomFieldValuesXml(), handler);
        Map customFieldValueMessageSets = valueValidatorHandler.getValidationResults();
        this.projectImportValidators.getCustomFieldOptionMapperValidator().validateMappings(i18n, backupProject, projectImportData.getProjectImportMapper().getCustomFieldOptionMapper(), projectImportData.getProjectImportMapper().getCustomFieldMapper(), customFieldValueMessageSets);
        mappingResult.setCustomFieldValueMessageSets(customFieldValueMessageSets);
    }

    @Override
    public void validateFileAttachments(ProjectImportOptions projectImportOptions, ProjectImportData projectImportData, MappingResult mappingResult, BackupProject backupProject, BackupSystemInformation backupSystemInformation, TaskProgressProcessor taskProgressProcessor, I18nHelper i18n) throws IOException, SAXException {
        Null.not("projectImportOptions", projectImportOptions);
        if (StringUtils.isNotEmpty((String)projectImportOptions.getAttachmentPath())) {
            Null.not("backupProject", backupProject);
            Null.not("backupSystemInformation", backupSystemInformation);
            Null.not("mappingResult", mappingResult);
            Null.not("projectImportData", projectImportData);
            Null.not("pathToFileAttachmentXml", projectImportData.getPathToFileAttachmentXml());
            ChainedSaxHandler handler = this.getChainedHandler(taskProgressProcessor);
            AttachmentFileValidatorHandler attachmentFileValidatorHandler = this.getAttachmentFileValidatorHandler(backupProject, projectImportOptions, backupSystemInformation, i18n);
            handler.registerHandler(attachmentFileValidatorHandler);
            this.backupXmlParser.parseBackupXml(projectImportData.getPathToFileAttachmentXml(), handler);
            projectImportData.setValidAttachmentsCount(attachmentFileValidatorHandler.getValidAttachmentCount());
            MessageSet fileAttachmentsMessageSet = attachmentFileValidatorHandler.getValidationResults();
            mappingResult.setFileAttachmentMessageSet(fileAttachmentsMessageSet);
        } else {
            mappingResult.setFileAttachmentMessageSet((MessageSet)new MessageSetImpl());
        }
    }

    @Override
    public void autoMapAndValidateIssueTypes(ProjectImportData projectImportData, MappingResult mappingResult, BackupProject backupProject, I18nHelper i18nBean) {
        IssueTypeMapper issueTypeMapper = projectImportData.getProjectImportMapper().getIssueTypeMapper();
        this.automaticDataMapper.mapIssueTypes(backupProject, issueTypeMapper);
        MessageSet messageSet = this.projectImportValidators.getIssueTypeMapperValidator().validateMappings(i18nBean, backupProject, issueTypeMapper);
        mappingResult.setIssueTypeMessageSet(messageSet);
    }

    @Override
    public void autoMapAndValidateCustomFields(ProjectImportData projectImportData, MappingResult mappingResult, BackupProject backupProject, I18nHelper i18nBean) {
        CustomFieldMapper customFieldMapper = projectImportData.getProjectImportMapper().getCustomFieldMapper();
        IssueTypeMapper issueTypeMapper = projectImportData.getProjectImportMapper().getIssueTypeMapper();
        this.automaticDataMapper.mapCustomFields(backupProject, customFieldMapper, issueTypeMapper);
        MessageSet messageSet = this.projectImportValidators.getCustomFieldMapperValidator().validateMappings(i18nBean, backupProject, issueTypeMapper, customFieldMapper);
        mappingResult.setCustomFieldMessageSet(messageSet);
    }

    @Override
    public void autoMapCustomFieldOptions(ProjectImportData projectImportData, BackupProject backupProject) {
        ProjectImportMapper projectImportMapper = projectImportData.getProjectImportMapper();
        this.automaticDataMapper.mapCustomFieldOptions(backupProject, projectImportMapper.getCustomFieldOptionMapper(), projectImportMapper.getCustomFieldMapper(), projectImportMapper.getIssueTypeMapper());
    }

    @Override
    public void autoMapProjectRoles(ProjectImportData projectImportData) {
        ProjectImportMapper projectImportMapper = projectImportData.getProjectImportMapper();
        this.automaticDataMapper.mapProjectRoles(projectImportMapper.getProjectRoleMapper());
    }

    @Override
    public void autoMapSystemFields(ProjectImportData projectImportData, BackupProject backupProject) {
        ProjectImportMapper projectImportMapper = projectImportData.getProjectImportMapper();
        this.automaticDataMapper.mapPriorities(projectImportMapper.getPriorityMapper());
        this.automaticDataMapper.mapProjects(projectImportMapper.getProjectMapper());
        this.automaticDataMapper.mapResolutions(projectImportMapper.getResolutionMapper());
        this.automaticDataMapper.mapStatuses(backupProject, projectImportMapper.getStatusMapper(), projectImportMapper.getIssueTypeMapper());
        this.automaticDataMapper.mapIssueLinkTypes(projectImportMapper.getIssueLinkTypeMapper());
        this.automaticDataMapper.mapIssueSecurityLevels(backupProject.getProject().getKey(), projectImportMapper.getIssueSecurityLevelMapper());
    }

    @Override
    public void validateSystemFields(ProjectImportData projectImportData, MappingResult mappingResult, ProjectImportOptions projectImportOptions, BackupProject backupProject, TaskProgressInterval taskProgressInterval, I18nHelper i18nBean) {
        EntityCountTaskProgressProcessor taskProgressProcessor = new EntityCountTaskProgressProcessor(taskProgressInterval, i18nBean.getText("admin.message.project.import.manager.do.mapping.validate.system.fields"), 9, i18nBean);
        ProjectImportMapper projectImportMapper = projectImportData.getProjectImportMapper();
        this.updateTaskProgress(taskProgressProcessor, i18nBean.getText("issue.field.priority"), 1);
        log.debug((Object)"Validating priorities.");
        MessageSet messageSet = this.projectImportValidators.getPriorityMapperValidator().validateMappings(i18nBean, projectImportMapper.getPriorityMapper());
        mappingResult.setPriorityMessageSet(messageSet);
        this.updateTaskProgress(taskProgressProcessor, i18nBean.getText("issue.field.resolution"), 2);
        log.debug((Object)"Validating resolutions.");
        messageSet = this.projectImportValidators.getResolutionMapperValidator().validateMappings(i18nBean, projectImportMapper.getResolutionMapper());
        mappingResult.setResolutionMessageSet(messageSet);
        this.updateTaskProgress(taskProgressProcessor, i18nBean.getText("issue.field.status"), 3);
        log.debug((Object)"Validating statuses.");
        messageSet = this.projectImportValidators.getStatusMapperValidator().validateMappings(i18nBean, backupProject, projectImportMapper.getIssueTypeMapper(), projectImportMapper.getStatusMapper());
        mappingResult.setStatusMessageSet(messageSet);
        this.updateTaskProgress(taskProgressProcessor, i18nBean.getText("admin.common.words.projectrole"), 4);
        log.debug((Object)"Validating project roles.");
        messageSet = this.projectImportValidators.getProjectRoleMapperValidator().validateMappings(i18nBean, projectImportMapper.getProjectRoleMapper());
        mappingResult.setProjectRoleMessageSet(messageSet);
        this.updateTaskProgress(taskProgressProcessor, i18nBean.getText("admin.common.words.projectrole.membership"), 5);
        log.debug((Object)"Validating project role actors.");
        messageSet = this.projectImportValidators.getProjectRoleActorMapperValidator().validateProjectRoleActors(i18nBean, projectImportMapper, projectImportOptions);
        mappingResult.setProjectRoleActorMessageSet(messageSet);
        this.updateTaskProgress(taskProgressProcessor, i18nBean.getText("admin.common.words.users"), 6);
        log.debug((Object)"Validating users.");
        messageSet = this.projectImportValidators.getUserMapperValidator().validateMappings(i18nBean, projectImportMapper.getUserMapper());
        mappingResult.setUserMessageSet(messageSet);
        this.updateTaskProgress(taskProgressProcessor, i18nBean.getText("admin.common.words.group"), 7);
        log.debug((Object)"Validating groups.");
        messageSet = this.projectImportValidators.getGroupMapperValidator().validateMappings(i18nBean, (SimpleProjectImportIdMapper)projectImportMapper.getGroupMapper());
        mappingResult.setGroupMessageSet(messageSet);
        this.updateTaskProgress(taskProgressProcessor, i18nBean.getText("common.concepts.issuelinktype"), 8);
        log.debug((Object)"Validating issue link types.");
        messageSet = this.projectImportValidators.getIssueLinkTypeMapperValidator().validateMappings(i18nBean, backupProject, projectImportMapper.getIssueLinkTypeMapper());
        mappingResult.setIssueLinkTypeMessageSet(messageSet);
        this.updateTaskProgress(taskProgressProcessor, i18nBean.getText("admin.common.words.issue.security.level"), 9);
        log.debug((Object)"Validating issue security levels.");
        messageSet = this.projectImportValidators.getIssueSecurityLevelValidator().validateMappings(projectImportMapper.getIssueSecurityLevelMapper(), backupProject, i18nBean);
        mappingResult.setIssueSecurityLevelMessageSet(messageSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importCustomFieldValues(ProjectImportData projectImportData, BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportResults projectImportResults, I18nHelper i18n, ProjectImportMapper projectImportMapper, TaskProgressInterval custFieldValueSubInterval) throws IOException, SAXException {
        BoundedExecutor customFieldValuesExecutor = this.createExecutor("ProjectImport: CreateCustomFieldValues");
        log.info((Object)"Creating custom field values.");
        ChainedSaxHandler customFieldValuesHandler = this.getChainedHandler(new EntityCountTaskProgressProcessor(custFieldValueSubInterval, i18n.getText("admin.message.project.import.manager.do.import.importing.custom.field.values"), projectImportData.getCustomFieldValuesEntityCount(), i18n));
        String mappedProjectId = projectImportMapper.getProjectMapper().getMappedId(backupProject.getProject().getId());
        customFieldValuesHandler.registerHandler(this.getCustomFieldValuePersisterHandler(projectImportMapper, mappedProjectId, projectImportResults, backupSystemInformation, customFieldValuesExecutor));
        try {
            this.backupXmlParser.parseBackupXml(projectImportData.getPathToCustomFieldValuesXml(), customFieldValuesHandler);
            log.info((Object)"Finished creating custom field values.");
        }
        finally {
            if (projectImportResults.abortImport()) {
                customFieldValuesExecutor.shutdownAndIgnoreQueue();
            } else {
                customFieldValuesExecutor.shutdownAndWait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importAttachments(ProjectImportOptions projectImportOptions, ProjectImportData projectImportData, BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportResults projectImportResults, I18nHelper i18n, TaskProgressInterval attachmentSubInterval) throws IOException, SAXException {
        boolean isImportingAttachments;
        boolean bl = isImportingAttachments = StringUtils.isNotEmpty((String)projectImportOptions.getAttachmentPath()) && projectImportData.getPathToFileAttachmentXml() != null;
        if (isImportingAttachments) {
            BoundedExecutor attachmentExecutor = this.createExecutor("ProjectImport: CreateAttachments");
            log.info((Object)"Creating the attachments.");
            ChainedSaxHandler attachmentPersistenceHandler = this.getChainedHandler(new EntityCountTaskProgressProcessor(attachmentSubInterval, i18n.getText("admin.message.project.import.manager.do.import.importing.attachments"), projectImportData.getFileAttachmentEntityCount(), i18n));
            AttachmentPersisterHandler attachmentPersisterHandler = new AttachmentPersisterHandler(this.projectImportPersister, projectImportOptions, projectImportData.getProjectImportMapper(), backupProject, backupSystemInformation, projectImportResults, attachmentExecutor);
            attachmentPersistenceHandler.registerHandler(attachmentPersisterHandler);
            try {
                this.backupXmlParser.parseBackupXml(projectImportData.getPathToFileAttachmentXml(), attachmentPersistenceHandler);
                log.info((Object)"Finished creating the attachments.");
            }
            finally {
                if (projectImportResults.abortImport()) {
                    attachmentExecutor.shutdownAndIgnoreQueue();
                } else {
                    attachmentExecutor.shutdownAndWait();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importIssueRelatedData(ProjectImportData projectImportData, BackupSystemInformation backupSystemInformation, ProjectImportResults projectImportResults, I18nHelper i18n, User importAuthor, ProjectImportMapper projectImportMapper, TaskProgressInterval issuesRelatedSubInterval) throws IOException, SAXException {
        BoundedExecutor issueRelatedExecutor = this.createExecutor("ProjectImport: CreateIssueRelatedData");
        log.info((Object)"Creating the issue-related data.");
        ChainedSaxHandler issueRelatedEntitiesHandler = this.getChainedHandler(new EntityCountTaskProgressProcessor(issuesRelatedSubInterval, i18n.getText("admin.message.project.import.manager.do.import.importing.issue.related"), projectImportData.getIssueRelatedEntityCount(), i18n));
        issueRelatedEntitiesHandler.registerHandler(this.getCommentPersisterHandler(projectImportMapper, projectImportResults, backupSystemInformation, issueRelatedExecutor));
        issueRelatedEntitiesHandler.registerHandler(this.getWorklogPersisterHandler(projectImportMapper, projectImportResults, backupSystemInformation, issueRelatedExecutor));
        issueRelatedEntitiesHandler.registerHandler(this.getVersionPersisterHandler(projectImportMapper, projectImportResults, backupSystemInformation, issueRelatedExecutor));
        issueRelatedEntitiesHandler.registerHandler(this.getComponentPersisterHandler(projectImportMapper, projectImportResults, backupSystemInformation, issueRelatedExecutor));
        issueRelatedEntitiesHandler.registerHandler(this.getIssueLinkPersisterHandler(projectImportMapper, projectImportResults, backupSystemInformation, issueRelatedExecutor, importAuthor));
        issueRelatedEntitiesHandler.registerHandler(this.getUserAssociationPersisterHandler(projectImportMapper, projectImportResults, backupSystemInformation, issueRelatedExecutor));
        issueRelatedEntitiesHandler.registerHandler(this.getChangeGroupPersisterHandler(projectImportMapper, projectImportResults, backupSystemInformation, issueRelatedExecutor));
        issueRelatedEntitiesHandler.registerHandler(this.getChangeItemPersisterHandler(projectImportMapper, projectImportResults, issueRelatedExecutor));
        issueRelatedEntitiesHandler.registerHandler(this.getLabelPersisterHandler(projectImportMapper, projectImportResults, backupSystemInformation, issueRelatedExecutor));
        try {
            this.backupXmlParser.parseBackupXml(projectImportData.getPathToIssueRelatedEntitiesXml(), issueRelatedEntitiesHandler);
            log.info((Object)"Finished creating the issue-related data.");
        }
        finally {
            if (projectImportResults.abortImport()) {
                issueRelatedExecutor.shutdownAndIgnoreQueue();
            } else {
                issueRelatedExecutor.shutdownAndWait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void importChangeItemData(ProjectImportData projectImportData, ProjectImportResults projectImportResults, I18nHelper i18n, ProjectImportMapper projectImportMapper, TaskProgressInterval changeItemSubInterval) throws IOException, SAXException {
        BoundedExecutor changeItemExecutor = this.createExecutor("ProjectImport: CreateChangeItems");
        log.info((Object)"Creating the change item data.");
        ChainedSaxHandler changeItemEntityHandler = this.getChainedHandler(new EntityCountTaskProgressProcessor(changeItemSubInterval, i18n.getText("admin.message.project.import.manager.do.import.importing.change.items"), projectImportData.getChangeItemEntityCount(), i18n));
        changeItemEntityHandler.registerHandler(this.getChangeItemPersisterHandler(projectImportMapper, projectImportResults, changeItemExecutor));
        try {
            this.backupXmlParser.parseBackupXml(projectImportData.getPathToChangeItemXml(), changeItemEntityHandler);
            log.info((Object)"Finished creating the change item data.");
        }
        finally {
            if (projectImportResults.abortImport()) {
                changeItemExecutor.shutdownAndIgnoreQueue();
            } else {
                changeItemExecutor.shutdownAndWait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long importIssues(ProjectImportData projectImportData, ProjectImportResults projectImportResults, I18nHelper i18n, User importAuthor, ProjectImportMapper projectImportMapper, TaskProgressInterval issuesSubInterval) throws IOException, SAXException {
        BoundedExecutor issueExecutor = this.createExecutor("ProjectImport: CreateIssues");
        log.info((Object)"Creating the issues.");
        EntityCountTaskProgressProcessor issuesTaskProgressProcessor = new EntityCountTaskProgressProcessor(issuesSubInterval, i18n.getText("admin.message.project.import.manager.do.import.importing.issues"), projectImportData.getIssueEntityCount(), i18n);
        ChainedSaxHandler issuePersistenceHandler = this.getChainedHandler(issuesTaskProgressProcessor);
        IssuePersisterHandler issuePersisterHandler = this.getIssuePersisterHandler(importAuthor, projectImportMapper, projectImportResults, issueExecutor);
        issuePersistenceHandler.registerHandler(issuePersisterHandler);
        try {
            this.backupXmlParser.parseBackupXml(projectImportData.getPathToIssuesXml(), issuePersistenceHandler);
            log.info((Object)"Finished creating the issues.");
        }
        finally {
            if (projectImportResults.abortImport()) {
                issueExecutor.shutdownAndIgnoreQueue();
            } else {
                issueExecutor.shutdownAndWait();
            }
        }
        return issuePersisterHandler.getLargestIssueKeyNumber();
    }

    void createGroupRoleActor(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, ProjectRoleActorParser projectRoleActorParser, ExternalProjectRoleActor projectRoleActor) {
        String newProjectId = projectImportMapper.getProjectMapper().getMappedId(projectRoleActor.getProjectId());
        String newProjectRoleId = projectImportMapper.getProjectRoleMapper().getMappedId(projectRoleActor.getRoleId());
        String groupName = projectRoleActor.getRoleActor();
        String projectRoleName = projectImportMapper.getProjectRoleMapper().getDisplayName(projectRoleActor.getRoleId());
        if (this.groupManager.groupExists(groupName)) {
            ExternalProjectRoleActor newProjectRoleActor = new ExternalProjectRoleActor(null, newProjectId, newProjectRoleId, projectRoleActor.getRoleType(), groupName);
            Long entityId = this.projectImportPersister.createEntity(projectRoleActorParser.getEntityRepresentation(newProjectRoleActor));
            if (entityId == null) {
                projectImportResults.addError("There was an error adding group '" + groupName + "' to the Project Role '" + projectRoleName + "'.");
            } else {
                projectImportResults.incrementRoleGroupCreatedCount(projectRoleName);
            }
        } else {
            log.warn((Object)("Group '" + groupName + "' does not exist, so we are not adding them to the Project Role '" + projectRoleName + "' in the Project Import."));
        }
    }

    void createUserRoleActor(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, ProjectRoleActorParser projectRoleActorParser, ExternalProjectRoleActor projectRoleActor) {
        String newProjectId = projectImportMapper.getProjectMapper().getMappedId(projectRoleActor.getProjectId());
        String newProjectRoleId = projectImportMapper.getProjectRoleMapper().getMappedId(projectRoleActor.getRoleId());
        String userKey = projectRoleActor.getRoleActor();
        String projectRoleName = projectImportMapper.getProjectRoleMapper().getDisplayName(projectRoleActor.getRoleId());
        if (projectImportMapper.getUserMapper().userExists(userKey)) {
            String mappedUserKey = projectImportMapper.getUserMapper().getMappedUserKey(userKey);
            ExternalProjectRoleActor newProjectRoleActor = new ExternalProjectRoleActor(null, newProjectId, newProjectRoleId, projectRoleActor.getRoleType(), mappedUserKey);
            Long entityId = this.projectImportPersister.createEntity(projectRoleActorParser.getEntityRepresentation(newProjectRoleActor));
            if (entityId == null) {
                projectImportResults.addError("There was an error adding user '" + projectImportMapper.getUserMapper().getDisplayName(userKey) + "' to the Project Role '" + projectRoleName + "'.");
            } else {
                projectImportResults.incrementRoleUserCreatedCount(projectRoleName);
            }
        } else {
            log.warn((Object)("User '" + projectImportMapper.getUserMapper().getDisplayName(userKey) + "' does not exist, so we are not adding them to the Project Role '" + projectRoleName + "' in the Project Import."));
        }
    }

    void updateTaskProgress(EntityCountTaskProgressProcessor taskProgressProcessor, String message, int currentCount) {
        if (taskProgressProcessor != null) {
            taskProgressProcessor.processTaskProgress(message, currentCount);
        }
    }

    void populateVersionMapper(SimpleProjectImportIdMapper versionMapper, Map<String, Version> newVersions) {
        for (Map.Entry<String, Version> entry : newVersions.entrySet()) {
            String oldId = entry.getKey();
            Version version = entry.getValue();
            versionMapper.mapValue(oldId, version.getId().toString());
        }
    }

    void populateComponentMapper(SimpleProjectImportIdMapper componentMapper, Map<String, ProjectComponent> newComponents) {
        for (Map.Entry<String, ProjectComponent> entry : newComponents.entrySet()) {
            String oldId = entry.getKey();
            ProjectComponent component = entry.getValue();
            componentMapper.mapValue(oldId, component.getId().toString());
        }
    }

    ImportEntityHandler getCustomFieldValuePersisterHandler(ProjectImportMapper projectImportMapper, String newProjectId, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        Map<String, CustomFieldValueParser> parsers = this.getCustomFieldParsers();
        return new CustomFieldValuePersisterHandler(this.projectImportPersister, projectImportMapper, this.customFieldManager, new Long(newProjectId), projectImportResults, backupSystemInformation, executor, parsers);
    }

    ImportEntityHandler getCommentPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        return new CommentPersisterHandler(this.projectImportPersister, projectImportMapper, projectImportResults, backupSystemInformation, executor);
    }

    ImportEntityHandler getWorklogPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        return new WorklogPersisterHandler(this.projectImportPersister, projectImportMapper, projectImportResults, backupSystemInformation, executor);
    }

    ImportEntityHandler getLabelPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        return new LabelsPersisterHandler(this.projectImportPersister, projectImportMapper, projectImportResults, backupSystemInformation, executor);
    }

    ImportEntityHandler getVersionPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        return new VersionPersisterHandler(this.projectImportPersister, projectImportMapper, projectImportResults, backupSystemInformation, executor);
    }

    ImportEntityHandler getComponentPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        return new ComponentPersisterHandler(this.projectImportPersister, projectImportMapper, projectImportResults, backupSystemInformation, executor);
    }

    ImportEntityHandler getUserAssociationPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        return new UserAssociationPersisterHandler(this.projectImportPersister, projectImportMapper, projectImportResults, backupSystemInformation, executor);
    }

    ImportEntityHandler getChangeGroupPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        return new ChangeGroupPersisterHandler(this.projectImportPersister, projectImportMapper, projectImportResults, backupSystemInformation, executor);
    }

    ImportEntityHandler getChangeItemPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, Executor executor) {
        return new ChangeItemPersisterHandler(this.projectImportPersister, projectImportMapper, projectImportResults, executor);
    }

    IssuePersisterHandler getIssuePersisterHandler(User importAuthor, ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, Executor executor) {
        return new IssuePersisterHandler(this.projectImportPersister, projectImportMapper, importAuthor, projectImportResults, executor);
    }

    ImportEntityHandler getIssueLinkPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor, User importAuthor) {
        return new IssueLinkPersisterHandler(this.projectImportPersister, projectImportMapper, this.issueManager, projectImportResults, backupSystemInformation, executor, importAuthor);
    }

    void populateCustomFieldMapperOldValues(BackupProject backupProject, CustomFieldMapper customFieldMapper) {
        for (ExternalCustomFieldConfiguration customFieldConfiguration : backupProject.getCustomFields()) {
            ExternalCustomField externalCustomField = customFieldConfiguration.getCustomField();
            customFieldMapper.registerOldValue(externalCustomField.getId(), externalCustomField.getName());
        }
    }

    void populateVersionMapperOldValues(BackupProject backupProject, SimpleProjectImportIdMapper versionMapper) {
        for (ExternalVersion externalVersion : backupProject.getProjectVersions()) {
            versionMapper.registerOldValue(externalVersion.getId(), externalVersion.getName());
        }
    }

    void populateComponentMapperOldValues(BackupProject backupProject, SimpleProjectImportIdMapper componentMapper) {
        for (ExternalComponent externalComponent : backupProject.getProjectComponents()) {
            componentMapper.registerOldValue(externalComponent.getId(), externalComponent.getName());
        }
    }

    CustomFieldValueValidatorHandler getCustomFieldValueValidatorHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        Map<String, CustomFieldValueParser> parsers = this.getCustomFieldParsers();
        return new CustomFieldValueValidatorHandler(backupProject, projectImportMapper, this.customFieldManager, parsers);
    }

    CustomFieldMapperHandler getCustomFieldMapperHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        Map<String, CustomFieldValueParser> parsers = this.getCustomFieldParsers();
        return new CustomFieldMapperHandler(backupProject, projectImportMapper.getCustomFieldMapper(), parsers);
    }

    SimpleEntityMapperHandler getStatusMapperHandler(ProjectImportMapper projectImportMapper) {
        return new SimpleEntityMapperHandler("Status", (MapperEntityRegister)projectImportMapper.getStatusMapper());
    }

    SimpleEntityMapperHandler getResolutionMapperHandler(ProjectImportMapper projectImportMapper) {
        return new SimpleEntityMapperHandler("Resolution", (MapperEntityRegister)projectImportMapper.getResolutionMapper());
    }

    SimpleEntityMapperHandler getPriorityMapperHandler(ProjectImportMapper projectImportMapper) {
        return new SimpleEntityMapperHandler("Priority", (MapperEntityRegister)projectImportMapper.getPriorityMapper());
    }

    ProjectMapperHandler getProjectMapperHandler(ProjectImportMapper projectImportMapper) {
        return new ProjectMapperHandler(projectImportMapper.getProjectMapper());
    }

    IssueTypeMapperHandler getIssueTypeMapperHandler(ProjectImportMapper projectImportMapper) {
        return new IssueTypeMapperHandler(projectImportMapper.getIssueTypeMapper());
    }

    ProjectIssueSecurityLevelMapperHandler getProjectIssueSecurityLevelMapperHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        return new ProjectIssueSecurityLevelMapperHandler(backupProject, projectImportMapper.getIssueSecurityLevelMapper());
    }

    IssueMapperHandler getIssueMapperHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        return new IssueMapperHandler(backupProject, projectImportMapper);
    }

    UserMapperHandler getUserMapperHandler(ProjectImportOptions projectImportOptions, BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        return new UserMapperHandler(projectImportOptions, backupProject, projectImportMapper.getUserMapper());
    }

    GroupMapperHandler getGroupMapperHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        return new GroupMapperHandler(backupProject, (SimpleProjectImportIdMapper)projectImportMapper.getGroupMapper());
    }

    ChainedSaxHandler getChainedHandler(TaskProgressProcessor taskProgressProcessor) {
        return new ChainedSaxHandler(taskProgressProcessor);
    }

    CustomFieldOptionsMapperHandler getCustomFieldOptionMapperHandler(ProjectImportMapper projectImportMapper) {
        return new CustomFieldOptionsMapperHandler(projectImportMapper.getCustomFieldOptionMapper());
    }

    SimpleEntityMapperHandler getProjectRoleRegistrationHandler(ProjectImportMapper projectImportMapper) {
        return new SimpleEntityMapperHandler("ProjectRole", (MapperEntityRegister)projectImportMapper.getProjectRoleMapper());
    }

    RequiredProjectRolesMapperHandler getRequiredProjectRolesMapperHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        return new RequiredProjectRolesMapperHandler(backupProject, projectImportMapper.getProjectRoleMapper());
    }

    RegisterUserMapperHandler getRegisterUserMapperHandler(ProjectImportMapper projectImportMapper) {
        return new RegisterUserMapperHandler(projectImportMapper.getUserMapper());
    }

    ProjectRoleActorMapperHandler getProjectRoleActorMapperHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        return new ProjectRoleActorMapperHandler(backupProject, projectImportMapper.getProjectRoleActorMapper());
    }

    IssueRelatedEntitiesPartionHandler getIssueRelatedEntitesHandler(PrintWriter issueRelatedEntitiesWriter, PrintWriter changeItemEntitiesWriter, BackupProject backupProject, String encoding) {
        ArrayList<ModelEntity> relatedModelEntities = new ArrayList<ModelEntity>();
        relatedModelEntities.add(this.getModelEntity("Worklog"));
        relatedModelEntities.add(this.getModelEntity("Label"));
        relatedModelEntities.add(this.getModelEntity("NodeAssociation"));
        relatedModelEntities.add(this.getModelEntity("IssueLink"));
        relatedModelEntities.add(this.getModelEntity("Action"));
        relatedModelEntities.add(this.getModelEntity("ChangeGroup"));
        relatedModelEntities.add(this.getModelEntity("ChangeItem"));
        relatedModelEntities.add(this.getModelEntity("UserAssociation"));
        return new IssueRelatedEntitiesPartionHandler(backupProject, issueRelatedEntitiesWriter, changeItemEntitiesWriter, relatedModelEntities, encoding);
    }

    IssueRelatedEntitiesPartionHandler getFileAttachmentHandler(PrintWriter attachmentValuesWriter, BackupProject backupProject, String encoding) {
        ModelEntity attachmentModelEntity = this.getModelEntity("FileAttachment");
        return new IssueRelatedEntitiesPartionHandler(backupProject, attachmentValuesWriter, null, EasyList.build((Object)attachmentModelEntity), encoding);
    }

    IssueRelatedEntitiesPartionHandler getCustomFieldValuesHandler(PrintWriter customFieldValuesWriter, BackupProject backupProject, String encoding) {
        Set<String> entities = this.getCustomFieldParsers().keySet();
        ArrayList<ModelEntity> model = new ArrayList<ModelEntity>();
        for (String entity : entities) {
            model.add(this.getModelEntity(entity));
        }
        return new IssueRelatedEntitiesPartionHandler(backupProject, customFieldValuesWriter, null, model, encoding);
    }

    private Map<String, CustomFieldValueParser> getCustomFieldParsers() {
        MapBuilder entities = MapBuilder.newBuilder();
        entities.add((Object)"CustomFieldValue", (Object)new CustomFieldValueParserImpl());
        List customFieldTypes = this.customFieldManager.getCustomFieldTypes();
        for (Object customFieldType : customFieldTypes) {
            if (!(customFieldType instanceof ProjectImportableCustomFieldParser)) continue;
            String entity = ((ProjectImportableCustomFieldParser)customFieldType).getEntityName();
            entities.add((Object)entity, (Object)((ProjectImportableCustomFieldParser)customFieldType));
        }
        return entities.toMap();
    }

    IssuePartitonHandler getIssuePartitioner(PrintWriter issueFileWriter, BackupProject backupProject, String encoding) {
        ModelEntity issueModelEntity = this.getModelEntity("Issue");
        return new IssuePartitonHandler(backupProject, issueFileWriter, issueModelEntity, encoding);
    }

    IssueVersionMapperHandler getIssueVersionMapperHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        return new IssueVersionMapperHandler(backupProject, projectImportMapper.getVersionMapper());
    }

    IssueComponentMapperHandler getIssueComponentMapperHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        return new IssueComponentMapperHandler(backupProject, projectImportMapper.getComponentMapper());
    }

    AttachmentFileValidatorHandler getAttachmentFileValidatorHandler(BackupProject backupProject, ProjectImportOptions projectImportOptions, BackupSystemInformation backupSystemInformation, I18nHelper i18nHelper) {
        return new AttachmentFileValidatorHandler(backupProject, projectImportOptions, backupSystemInformation, i18nHelper);
    }

    IssueLinkMapperHandler getIssueLinkMapperHandler(BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportMapper projectImportMapper) {
        return new IssueLinkMapperHandler(backupProject, backupSystemInformation, this.issueManager, projectImportMapper.getIssueLinkTypeMapper());
    }

    PrintWriter getWriter(File file, String encoding) throws UnsupportedEncodingException, FileNotFoundException {
        FileOutputStream fos = new FileOutputStream(file);
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, encoding);
        BufferedWriter bufferedWriter = new BufferedWriter(out, 32768);
        return new PrintWriter(bufferedWriter);
    }

    void subvertSecurityIndexingNotifications() {
        ImportUtils.setSubvertSecurityScheme((boolean)true);
        ImportUtils.setIndexIssues((boolean)false);
        ImportUtils.setEnableNotifications((boolean)false);
    }

    void restoreSecurityIndexingNotifications() {
        ImportUtils.setSubvertSecurityScheme((boolean)false);
        ImportUtils.setIndexIssues((boolean)true);
        ImportUtils.setEnableNotifications((boolean)true);
    }

    TaskProgressInterval getSubInterval(TaskProgressInterval taskProgressInterval, int subIntervalStart, int subIntervalEnd) {
        if (taskProgressInterval == null) {
            return null;
        }
        return taskProgressInterval.getSubInterval(subIntervalStart, subIntervalEnd);
    }

    int getTotalEntitiesCount() {
        int count = 0;
        try {
            ModelReader reader = this.genericDelegator.getModelReader();
            Iterator iterator = reader.getEntityNamesIterator();
            while (iterator.hasNext()) {
                String entityName = (String)iterator.next();
                ModelEntity modelEntity = this.genericDelegator.getModelReader().getModelEntity(entityName);
                if (modelEntity instanceof ModelViewEntity) continue;
                ++count;
            }
            return count;
        }
        catch (GenericEntityException e) {
            return 100;
        }
    }

    ModelEntity getModelEntity(String entityName) {
        try {
            return this.genericDelegator.getModelReader().getModelEntity(entityName);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    String getApplicationEncoding() {
        return this.applicationProperties.getEncoding();
    }

    ProjectRoleActorParser getProjectRoleActorParser() {
        return new ProjectRoleActorParserImpl();
    }

    BoundedExecutor createExecutor(String threadName) {
        return new BoundedExecutor(Executors.newFixedThreadPool(10, new ProjectImportThreadFactory(threadName)), 20);
    }

    private static class ProjectImportThreadFactory
    implements ThreadFactory {
        private final AtomicLong threadId = new AtomicLong(0L);
        private final String threadName;

        private ProjectImportThreadFactory(String threadName) {
            this.threadName = threadName;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            return new Thread(runnable, this.threadName + "-" + this.threadId.incrementAndGet());
        }
    }
}

