/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.EntityFactory;
import com.atlassian.jira.exception.DataAccessException;
import com.google.common.annotations.VisibleForTesting;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityFindOptions;
import org.ofbiz.core.entity.EntityListIterator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericHelper;
import org.ofbiz.core.entity.model.ModelEntity;

public class PagedList<E> {
    private final String entityName;
    private final EntityFactory<E> entityFactory;
    private final EntityCondition entityCondition;
    private final List<String> orderBy;
    private final int pageSize;
    private volatile int count = -1;
    private final DelegatorInterface genericDelegator;
    private final Logger log = Logger.getLogger(this.getClass());

    public PagedList(int pageSize, EntityFactory<E> entityFactory, EntityCondition entityCondition, List<String> orderBy) {
        this.pageSize = pageSize;
        this.entityFactory = entityFactory;
        this.entityCondition = entityCondition;
        this.orderBy = orderBy;
        this.entityName = entityFactory.getEntityName();
        this.genericDelegator = (DelegatorInterface)ComponentAccessor.getComponent(DelegatorInterface.class);
    }

    @VisibleForTesting
    PagedList(int pageSize, EntityFactory<E> entityFactory, EntityCondition entityCondition, List<String> orderBy, DelegatorInterface genericDelegator) {
        this.pageSize = pageSize;
        this.entityFactory = entityFactory;
        this.entityCondition = entityCondition;
        this.orderBy = orderBy;
        this.entityName = entityFactory.getEntityName();
        this.genericDelegator = genericDelegator;
    }

    public List<E> getPage(int pageNumber) {
        EntityListIterator entityListIterator = null;
        if (this.pageNumberValid(pageNumber)) {
            throw new IllegalArgumentException("pageNumber should be between 0 and " + (this.count / this.pageSize - 1));
        }
        try {
            entityListIterator = this.getListIterator(pageNumber);
            List<E> list = this.entityFactory.buildList(entityListIterator.getCompleteList());
            return list;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Problem retrieving page.", (Throwable)e);
        }
        finally {
            if (entityListIterator != null) {
                try {
                    entityListIterator.close();
                }
                catch (GenericEntityException ignore) {}
            }
        }
    }

    public Iterator<List<E>> iterator() {
        return new PageIterator();
    }

    private boolean pageNumberValid(int pageNumber) {
        return pageNumber < 0 || pageNumber * this.pageSize >= this.getSize();
    }

    private EntityListIterator getListIterator(int pageNumber) throws GenericEntityException {
        GenericHelper helper = this.genericDelegator.getEntityHelper(this.entityName);
        ModelEntity modelEntity = this.genericDelegator.getModelEntity(this.entityName);
        EntityFindOptions entityFindOptions = new EntityFindOptions();
        entityFindOptions.setOffset(pageNumber * this.pageSize);
        entityFindOptions.setMaxResults(this.pageSize);
        return helper.findListIteratorByCondition(modelEntity, this.entityCondition, null, null, this.orderBy, entityFindOptions);
    }

    public int getSize() {
        if (this.count < 0) {
            try {
                this.count = this.genericDelegator.countByCondition(this.entityName, null, this.entityCondition, null);
            }
            catch (GenericEntityException e) {
                this.log.error((Object)"Exception thrown trying to count rows", (Throwable)e);
            }
        }
        return this.count;
    }

    class PageIterator
    implements Iterator<List<E>> {
        int currentPage = 0;

        PageIterator() {
        }

        @Override
        public boolean hasNext() {
            return PagedList.this.pageNumberValid(this.currentPage + 1);
        }

        @Override
        public List<E> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("There are no more pages to iterate over");
            }
            List itemsInPage = PagedList.this.getPage(this.currentPage + 1);
            ++this.currentPage;
            return itemsInPage;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported");
        }
    }
}

