/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.entity;

import com.atlassian.core.util.DateUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.EntityFactory;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class EntityUtils {
    public static GenericValue createValue(String entityName, Map<String, Object> fields) {
        return ComponentAccessor.getOfBizDelegator().createValue(entityName, fields);
    }

    public static boolean identical(GenericValue v1, GenericValue v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        if (!v1.getEntityName().equals(v2.getEntityName())) {
            return false;
        }
        for (String key : v1.getAllKeys()) {
            Timestamp t2;
            Timestamp t1;
            if (v1.get(key) == null && v2.get(key) == null) continue;
            if (v1.get(key) == null && v2.get(key) != null) {
                return false;
            }
            if (!(v1.get(key) instanceof Timestamp && v2.get(key) instanceof Timestamp ? !DateUtils.equalTimestamps((Timestamp)(t1 = (Timestamp)v1.get(key)), (Timestamp)(t2 = (Timestamp)v2.get(key))) : !v1.get(key).equals(v2.get(key)))) continue;
            return false;
        }
        ArrayList uncheckedKeys = new ArrayList(v2.getAllKeys());
        uncheckedKeys.removeAll(v1.getAllKeys());
        if (uncheckedKeys.size() > 0) {
            for (String key : uncheckedKeys) {
                if (v2.get(key) == null) continue;
                return false;
            }
        }
        return true;
    }

    public static synchronized String getNextStringId(String entityName) {
        long maxID = 1L;
        for (GenericValue entity : ComponentAccessor.getOfBizDelegator().findAll(entityName)) {
            try {
                long entityId = Long.parseLong(entity.getString("id"));
                if (entityId < maxID) continue;
                maxID = entityId + 1L;
            }
            catch (NumberFormatException nfe) {}
        }
        return Long.toString(maxID);
    }

    public static void internStringFieldValue(GenericValue value, String fieldName) {
        String fieldValue;
        if (value != null && (fieldValue = value.getString(fieldName)) != null) {
            value.dangerousSetNoCheckButFast(value.getModelEntity().getField(fieldName), (Object)fieldValue.intern());
        }
    }

    public static <E> List<GenericValue> convertToGenericValues(EntityFactory<E> entityFactory, List<E> entityList) {
        OfBizDelegator ofBizDelegator = ComponentAccessor.getOfBizDelegator();
        ArrayList<GenericValue> gvList = new ArrayList<GenericValue>(entityList.size());
        for (E e : entityList) {
            gvList.add(ofBizDelegator.makeValue(entityFactory.getEntityName(), entityFactory.fieldMapFrom(e)));
        }
        return gvList;
    }
}

