/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.UserDao;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.membership.MembershipType;
import com.atlassian.crowd.model.user.DelegatingUserWithAttributes;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.jira.crowd.embedded.ofbiz.DirectoryEntityKey;
import com.atlassian.jira.crowd.embedded.ofbiz.InternalMembershipDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizAttributesBuilder;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizUser;
import com.atlassian.jira.crowd.embedded.ofbiz.PrimitiveMap;
import com.atlassian.jira.crowd.embedded.ofbiz.SimpleIdName;
import com.atlassian.jira.crowd.embedded.ofbiz.UserAttributeEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.UserEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.UserEntityConditionFactory;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.UserDeleteVeto;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.base.Function;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericValue;

public class OfBizUserDao
implements UserDao {
    private final OfBizDelegator ofBizDelegator;
    private final DirectoryDao directoryDao;
    private final InternalMembershipDao membershipDao;
    private final UserKeyStore userKeyStore;
    private final ConcurrentMap<DirectoryEntityKey, OfBizUser> userCache = new ConcurrentHashMap<DirectoryEntityKey, OfBizUser>();
    private final ConcurrentMap<DirectoryEntityKey, Attributes> userAttributesCache = new ConcurrentHashMap<DirectoryEntityKey, Attributes>();
    private final UserDeleteVeto userDeleteVeto;
    private static final String DELETED_EXTERNALLY_SUFFIX = " [X]";
    private static final Function<GenericValue, String> TO_USERNAME_FUNCTION = new Function<GenericValue, String>(){

        public String apply(GenericValue gvUser) {
            return gvUser.getString("userName");
        }
    };
    private static final Function<GenericValue, OfBizUser> TO_USER_FUNCTION = new Function<GenericValue, OfBizUser>(){

        public OfBizUser apply(GenericValue gvUser) {
            return OfBizUser.from(gvUser);
        }
    };

    public OfBizUserDao(OfBizDelegator ofBizDelegator, DirectoryDao directoryDao, InternalMembershipDao membershipDao, UserKeyStore userKeyStore, UserDeleteVeto userDeleteVeto) {
        this.userDeleteVeto = userDeleteVeto;
        this.ofBizDelegator = ofBizDelegator;
        this.directoryDao = directoryDao;
        this.membershipDao = membershipDao;
        this.userKeyStore = userKeyStore;
        this.buildCache();
    }

    public OfBizUser findByName(long directoryId, String userName) throws UserNotFoundException {
        OfBizUser user = (OfBizUser)this.userCache.get(DirectoryEntityKey.getKeyPreserveCase(directoryId, userName));
        if (user != null) {
            return user;
        }
        user = (OfBizUser)this.userCache.get(DirectoryEntityKey.getKey(directoryId, userName));
        if (user == null) {
            throw new UserNotFoundException(userName);
        }
        return user;
    }

    public UserWithAttributes findByNameWithAttributes(long directoryId, String userName) throws UserNotFoundException {
        OfBizUser user = this.findByName(directoryId, userName);
        Attributes attributes = (Attributes)this.userAttributesCache.get(DirectoryEntityKey.getKeyPreserveCase(directoryId, userName));
        if (attributes == null) {
            attributes = (Attributes)this.userAttributesCache.get(DirectoryEntityKey.getKey(directoryId, userName));
        }
        if (attributes == null) {
            List<GenericValue> attributesGenericValue = this.findAttributesGenericValues(directoryId, user.getId());
            attributes = OfBizAttributesBuilder.toAttributes(attributesGenericValue);
            this.userAttributesCache.put(DirectoryEntityKey.getKey(directoryId, userName), attributes);
        }
        return new DelegatingUserWithAttributes((com.atlassian.crowd.model.user.User)user, attributes);
    }

    public PasswordCredential getCredential(long directoryId, String userName) throws UserNotFoundException {
        GenericValue userGenericValue = this.findUserGenericValue(directoryId, userName);
        if (userGenericValue == null) {
            return null;
        }
        String storedCredential = userGenericValue.getString("credential");
        if (storedCredential == null) {
            return null;
        }
        return new PasswordCredential(storedCredential, true);
    }

    public List<PasswordCredential> getCredentialHistory(long directoryId, String userName) throws UserNotFoundException {
        throw new UnsupportedOperationException("JIRA does not store User Credential History");
    }

    private GenericValue findUserGenericValue(long directoryId, String userName) throws UserNotFoundException {
        GenericValue userGenericValue = EntityUtil.getOnly(this.findUsers(PrimitiveMap.of("directoryId", directoryId, "lowerUserName", IdentifierUtils.toLowerCase((String)userName))));
        if (userGenericValue != null) {
            return userGenericValue;
        }
        throw new UserNotFoundException(userName);
    }

    private List<GenericValue> findUsers(Map<String, Object> filter) {
        return this.ofBizDelegator.findByAnd("User", filter);
    }

    public BatchResult<com.atlassian.crowd.model.user.User> addAll(Set<UserTemplateWithCredentialAndAttributes> users) {
        BatchResult results = new BatchResult(users.size());
        for (UserTemplateWithCredentialAndAttributes user : users) {
            try {
                com.atlassian.crowd.model.user.User addedUser = this.add((com.atlassian.crowd.model.user.User)user, user.getCredential());
                results.addSuccess((Object)addedUser);
            }
            catch (UserAlreadyExistsException e) {
                results.addFailure((Object)user);
            }
            catch (IllegalArgumentException e) {
                results.addFailure((Object)user);
            }
            catch (DataAccessException e) {
                results.addFailure((Object)user);
            }
        }
        return results;
    }

    public synchronized com.atlassian.crowd.model.user.User add(com.atlassian.crowd.model.user.User user, PasswordCredential credential) throws UserAlreadyExistsException {
        OfBizUser newUser;
        if (credential != null) {
            Validate.isTrue((boolean)credential.isEncryptedCredential(), (String)"credential must be encrypted");
        }
        String userName = user.getName();
        GenericValue userGenericValue = EntityUtil.getOnly(this.findUsers(PrimitiveMap.of("directoryId", user.getDirectoryId(), "lowerUserName", IdentifierUtils.toLowerCase((String)user.getName()))));
        if (userGenericValue != null) {
            throw new UserAlreadyExistsException(user.getDirectoryId(), userName);
        }
        this.userKeyStore.ensureUniqueKeyForNewUser(user.getName());
        Timestamp currentTimestamp = this.getCurrentTimestamp();
        Map<String, Object> userData = UserEntity.getData(user, credential, currentTimestamp, currentTimestamp);
        this.ofBizDelegator.createValue("User", userData);
        try {
            newUser = this.getUserFromDB(user.getDirectoryId(), userName);
        }
        catch (UserNotFoundException e) {
            throw new OperationFailedException("Created a new user '" + userName + "' - but was unable to retrieve them from the DB.", (Throwable)e);
        }
        this.putUserInCache(newUser);
        return newUser;
    }

    private Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    private OfBizUser getUserFromDB(Long directoryId, String userName) throws UserNotFoundException {
        return OfBizUser.from(this.findUserGenericValue(directoryId, userName));
    }

    public void storeAttributes(com.atlassian.crowd.model.user.User user, Map<String, Set<String>> attributes) throws UserNotFoundException {
        GenericValue userGenericValue = this.findUserGenericValue(user.getDirectoryId(), user.getName());
        Long userId = userGenericValue.getLong("id");
        for (Map.Entry<String, Set<String>> entry : ((Map)Assertions.notNull(attributes)).entrySet()) {
            this.updateAttribute(userId, user, entry);
        }
        this.userAttributesCache.remove(DirectoryEntityKey.getKey(user.getDirectoryId(), user.getName()));
    }

    private void updateAttribute(Long userId, com.atlassian.crowd.model.user.User user, Map.Entry<String, Set<String>> attribute) throws UserNotFoundException {
        GenericValue attributeGv;
        int i;
        List<GenericValue> oldAttributes = this.getAttributeValues(userId, attribute.getKey());
        if (oldAttributes.size() > 1) {
            Collections.sort(oldAttributes, new Comparator<GenericValue>(){

                @Override
                public int compare(GenericValue o1, GenericValue o2) {
                    return o1.getLong("id").compareTo(o2.getLong("id"));
                }
            });
        }
        int oldSize = oldAttributes.size();
        int newSize = attribute.getValue().size();
        int commonSize = Math.min(newSize, oldSize);
        Iterator<String> newValues = attribute.getValue().iterator();
        for (i = 0; i < commonSize; ++i) {
            attributeGv = oldAttributes.get(i);
            String oldValue = attributeGv.getString("value");
            String newValue = newValues.next();
            if (StringUtils.isNotEmpty((String)newValue)) {
                if (newValue.equals(oldValue)) continue;
                attributeGv.set("value", (Object)newValue);
                attributeGv.set("lowerValue", (Object)IdentifierUtils.toLowerCase((String)newValue));
                this.ofBizDelegator.store(attributeGv);
                continue;
            }
            this.ofBizDelegator.removeValue(attributeGv);
        }
        for (i = commonSize; i < newSize; ++i) {
            String newValue = newValues.next();
            if (!StringUtils.isNotEmpty((String)newValue)) continue;
            this.storeAttributeValue(user.getDirectoryId(), userId, attribute.getKey(), newValue);
        }
        for (i = commonSize; i < oldSize; ++i) {
            attributeGv = oldAttributes.get(i);
            this.ofBizDelegator.removeValue(attributeGv);
        }
    }

    public void removeAllUsers(long directoryId, Set<String> userNames) {
        for (String userName : userNames) {
            try {
                this.remove((com.atlassian.crowd.model.user.User)this.findByName(directoryId, userName));
            }
            catch (UserNotFoundException e) {}
        }
    }

    private void storeAttributeValue(Long directoryId, Long userId, String name, String value) throws UserNotFoundException {
        this.ofBizDelegator.createValue("UserAttribute", UserAttributeEntity.getData(directoryId, userId, name, value));
    }

    private List<GenericValue> findAttributesGenericValues(Long directoryId, Long userId) {
        return this.ofBizDelegator.findByAnd("UserAttribute", PrimitiveMap.of("directoryId", (long)directoryId, "userId", userId));
    }

    public synchronized com.atlassian.crowd.model.user.User update(com.atlassian.crowd.model.user.User user) throws UserNotFoundException {
        GenericValue oldUserGenericValue = this.findUserGenericValue(user.getDirectoryId(), user.getName());
        GenericValue newUserGenericValue = UserEntity.setData(user, oldUserGenericValue);
        if (this.userDeletedExternally(oldUserGenericValue)) {
            newUserGenericValue.set("deletedExternally", (Object)0);
            newUserGenericValue.set("active", (Object)1);
        }
        newUserGenericValue.set("updatedDate", (Object)this.getCurrentTimestamp());
        OfBizUser newUser = OfBizUser.from(this.storeUser(newUserGenericValue));
        this.putUserInCache(newUser);
        return newUser;
    }

    public void updateCredential(com.atlassian.crowd.model.user.User user, PasswordCredential credential, int credentialHistory) throws UserNotFoundException {
        Validate.isTrue((boolean)credential.isEncryptedCredential(), (String)"credential must be encrypted");
        GenericValue storeGenericValue = this.findUserGenericValue(user.getDirectoryId(), user.getName());
        storeGenericValue.set("credential", (Object)credential.getCredential());
        this.storeUser(storeGenericValue);
    }

    private GenericValue storeUser(GenericValue userGenericValue) {
        this.ofBizDelegator.store(userGenericValue);
        return userGenericValue;
    }

    public com.atlassian.crowd.model.user.User rename(com.atlassian.crowd.model.user.User oldUser, String newName) throws UserNotFoundException {
        GenericValue userGenericValue = this.findUserGenericValue(oldUser.getDirectoryId(), oldUser.getName());
        userGenericValue.set("userName", (Object)newName);
        userGenericValue.set("lowerUserName", (Object)IdentifierUtils.toLowerCase((String)newName));
        userGenericValue.set("updatedDate", (Object)this.getCurrentTimestamp());
        OfBizUser newUser = OfBizUser.from(this.storeUser(userGenericValue));
        this.userCache.remove(DirectoryEntityKey.getKey((DirectoryEntity)oldUser));
        this.putUserInCache(newUser);
        FieldMap whereClause = FieldMap.build((String)"directoryId", (Object)oldUser.getDirectoryId()).add("lowerChildName", (Object)IdentifierUtils.toLowerCase((String)oldUser.getName())).add("membershipType", (Object)MembershipType.GROUP_USER.name());
        List oldMemberships = this.ofBizDelegator.findByAnd("Membership", (Map)whereClause);
        this.membershipDao.removeAllUserMemberships(oldUser);
        for (GenericValue oldMembership : oldMemberships) {
            SimpleIdName userIdName = new SimpleIdName(oldMembership.getLong("childId"), newUser.getName());
            SimpleIdName groupIdName = new SimpleIdName(oldMembership.getLong("parentId"), oldMembership.getString("parentName"));
            this.membershipDao.addUserToGroup(newUser.getDirectoryId(), userIdName, groupIdName);
        }
        this.userKeyStore.renameUser(oldUser.getName(), newName);
        return newUser;
    }

    public void removeAttribute(com.atlassian.crowd.model.user.User user, String attributeName) throws UserNotFoundException {
        GenericValue userGenericValue = this.findUserGenericValue(user.getDirectoryId(), user.getName());
        this.ofBizDelegator.removeByAnd("UserAttribute", PrimitiveMap.of("userId", (long)userGenericValue.getLong("id"), "name", attributeName));
        this.userAttributesCache.remove(DirectoryEntityKey.getKey(user.getDirectoryId(), user.getName()));
    }

    private List<GenericValue> getAttributeValues(Long userId, String attributeName) throws UserNotFoundException {
        return this.ofBizDelegator.findByAnd("UserAttribute", PrimitiveMap.of("userId", (long)userId, "name", attributeName));
    }

    public synchronized void remove(com.atlassian.crowd.model.user.User user) throws UserNotFoundException {
        if (!this.allowDeleteUser(user)) {
            this.disableUserDeletedExternally(user);
            return;
        }
        GenericValue userGenericValue = this.findUserGenericValue(user.getDirectoryId(), user.getName());
        this.membershipDao.removeAllUserMemberships(user);
        this.ofBizDelegator.removeByAnd("UserAttribute", PrimitiveMap.of("userId", userGenericValue.getLong("id")));
        this.ofBizDelegator.removeValue(userGenericValue);
        this.userCache.remove(DirectoryEntityKey.getKey((DirectoryEntity)user));
        this.userAttributesCache.remove(DirectoryEntityKey.getKey(user.getDirectoryId(), user.getName()));
    }

    private boolean allowDeleteUser(com.atlassian.crowd.model.user.User user) {
        return this.userExistsInAnotherActiveDirectory(user) || this.userDeleteVeto.allowDeleteUser((User)user);
    }

    private boolean userExistsInAnotherActiveDirectory(com.atlassian.crowd.model.user.User user) {
        for (Directory directory : this.directoryDao.findAll()) {
            long directoryId = directory.getId();
            if (!directory.isActive() || directoryId == user.getDirectoryId() || !this.userCache.containsKey(DirectoryEntityKey.getKey(directoryId, user.getName()))) continue;
            return true;
        }
        return false;
    }

    private void disableUserDeletedExternally(com.atlassian.crowd.model.user.User user) {
        GenericValue userGenericValue;
        try {
            userGenericValue = UserEntity.setData(user, this.findUserGenericValue(user.getDirectoryId(), user.getName()));
        }
        catch (UserNotFoundException e) {
            return;
        }
        if (this.userDeletedExternally(userGenericValue)) {
            return;
        }
        userGenericValue.set("updatedDate", (Object)this.getCurrentTimestamp());
        userGenericValue.set("active", (Object)0);
        userGenericValue.set("deletedExternally", (Object)1);
        String displayName = user.getDisplayName();
        if (!displayName.endsWith(DELETED_EXTERNALLY_SUFFIX)) {
            userGenericValue.set("displayName", (Object)(user.getDisplayName() + DELETED_EXTERNALLY_SUFFIX));
        }
        OfBizUser newUser = OfBizUser.from(this.storeUser(userGenericValue));
        this.putUserInCache(newUser);
    }

    private boolean userDeletedExternally(GenericValue userGenericValue) {
        Integer i = userGenericValue.getInteger("deletedExternally");
        return i != null && i != 0;
    }

    public <T> List<T> search(long directoryId, EntityQuery<T> query) {
        UserQuery userQuery = (UserQuery)query;
        EntityCondition baseCondition = new UserEntityConditionFactory(this.ofBizDelegator).getEntityConditionFor(userQuery.getSearchRestriction());
        EntityExpr directoryCondition = new EntityExpr("directoryId", EntityOperator.EQUALS, (Object)directoryId);
        if (baseCondition == null) {
            return this.getAllUsersFromCache(directoryId, query.getReturnType());
        }
        ArrayList<Object> entityConditions = new ArrayList<Object>(2);
        entityConditions.add(baseCondition);
        entityConditions.add(directoryCondition);
        EntityConditionList entityCondition = new EntityConditionList(entityConditions, EntityOperator.AND);
        List results = this.ofBizDelegator.findByCondition("User", (EntityCondition)entityCondition, null, Collections.singletonList("lowerUserName"));
        ArrayList<Object> typedResults = new ArrayList<Object>(results.size());
        Object valueFunction = query.getReturnType().equals(String.class) ? TO_USERNAME_FUNCTION : TO_USER_FUNCTION;
        for (GenericValue result : results) {
            typedResults.add(valueFunction.apply((Object)result));
        }
        return typedResults;
    }

    private <T> List<T> getAllUsersFromCache(long directoryId, Class<T> returnType) {
        ArrayList<OfBizUser> allUsers = new ArrayList<OfBizUser>();
        for (OfBizUser user : this.userCache.values()) {
            if (user.getDirectoryId() != directoryId) continue;
            allUsers.add(user);
        }
        if (returnType.isAssignableFrom(String.class)) {
            Function<OfBizUser, String> valueFunction = new Function<OfBizUser, String>(){

                public String apply(OfBizUser from) {
                    return from.getName();
                }
            };
            ArrayList<Object> typedResults = new ArrayList<Object>(allUsers.size());
            for (OfBizUser user : allUsers) {
                typedResults.add(valueFunction.apply((Object)user));
            }
            return typedResults;
        }
        if (returnType.isAssignableFrom(OfBizUser.class)) {
            return allUsers;
        }
        throw new IllegalArgumentException("Class type for return values ('" + returnType + "') is not 'String' or 'User'");
    }

    public synchronized void flushCache() {
        this.userAttributesCache.clear();
        this.userCache.clear();
        this.buildCache();
    }

    private void buildCache() {
        for (Directory directory : this.directoryDao.findAll()) {
            List<GenericValue> userGenericValues = this.findUsers(PrimitiveMap.of("directoryId", directory.getId()));
            for (GenericValue userGenericValue : userGenericValues) {
                this.putUserInCache((OfBizUser)TO_USER_FUNCTION.apply((Object)userGenericValue));
            }
        }
    }

    private void putUserInCache(OfBizUser user) {
        DirectoryEntityKey key = DirectoryEntityKey.getKey(user.getDirectoryId(), user.getName());
        this.userCache.put(key, user);
    }
}

