/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.membership.MembershipType;
import org.apache.commons.lang.builder.HashCodeBuilder;

final class MembershipKey {
    private long directoryId;
    private String name;
    private MembershipType type;

    private MembershipKey(long directoryId, String name, MembershipType type) {
        this.directoryId = directoryId;
        this.name = name;
        this.type = type;
    }

    public long getDirectoryId() {
        return this.directoryId;
    }

    public String getName() {
        return this.name;
    }

    public MembershipType getType() {
        return this.type;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MembershipKey)) {
            return false;
        }
        MembershipKey other = (MembershipKey)o;
        return this.directoryId == other.directoryId && this.name.equals(other.name) && this.type == other.type;
    }

    public final int hashCode() {
        return new HashCodeBuilder(1, 31).append(this.directoryId).append((Object)this.name).toHashCode();
    }

    public static MembershipKey getKeyPreserveCase(long directoryId, String name, MembershipType type) {
        return new MembershipKey(directoryId, name, type);
    }

    public static MembershipKey getKey(long directoryId, String name, MembershipType type) {
        return new MembershipKey(directoryId, IdentifierUtils.toLowerCase((String)name), type);
    }

    public static MembershipKey getKey(DirectoryEntity entity, MembershipType type) {
        return new MembershipKey(entity.getDirectoryId(), IdentifierUtils.toLowerCase((String)entity.getName()), type);
    }
}

