/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.gui;

import com.atlassian.jira.configurator.gui.LabelledComponent;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class OptionalLabelledComponent
extends LabelledComponent
implements ItemListener {
    private final JComponent component;
    private final String defaultValue;
    private final JCheckBox checkbox;

    public OptionalLabelledComponent(String label, JComponent component, String defaultValue) {
        super(label, component);
        this.component = component;
        this.defaultValue = defaultValue;
        this.checkbox = new JCheckBox();
        this.checkbox.addItemListener(this);
        this.add((Component)this.checkbox, "West");
        this.onDisabled();
    }

    private void onEnabled() {
        this.component.setEnabled(true);
        this.checkbox.setToolTipText("Uncheck to use the default setting of " + this.defaultValue);
    }

    private void onDisabled() {
        this.component.setEnabled(false);
        this.checkbox.setToolTipText("Check to override the default setting of " + this.defaultValue);
    }

    @Override
    public boolean isUsingDefault() {
        return !this.component.isEnabled();
    }

    @Override
    public void setValue(Object newValue) {
        super.setValue(newValue);
        if (newValue != null) {
            this.checkbox.setSelected(true);
            this.onEnabled();
        } else {
            this.checkbox.setSelected(false);
            this.onDisabled();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getItemSelectable() != this.checkbox) {
            return;
        }
        switch (e.getStateChange()) {
            case 1: {
                this.onEnabled();
                break;
            }
            case 2: {
                this.onDisabled();
            }
        }
    }
}

