/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.config;

import com.atlassian.jira.configurator.config.ValidationException;
import com.google.common.base.Strings;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Validator<T> {
    public static final Validator<Integer> INTEGER = new Validator<Integer>(){

        @Override
        public Integer apply(String label, String input) throws ValidationException {
            return 1.parseInteger(label, input);
        }
    };
    public static final Validator<Integer> INTEGER_POSITIVE = new Validator<Integer>(){

        @Override
        public Integer apply(String label, String input) throws ValidationException {
            Integer value = 2.parseInteger(label, input);
            if (value != null && value <= 0) {
                throw new ValidationException(label, "Only positive values are allowed");
            }
            return value;
        }
    };
    public static final Validator<Integer> INTEGER_POSITIVE_OR_ZERO = new Validator<Integer>(){

        @Override
        public Integer apply(String label, String input) throws ValidationException {
            Integer value = 3.parseInteger(label, input);
            if (value != null && value < 0) {
                throw new ValidationException(label, "Negative values are not allowed");
            }
            return value;
        }
    };
    public static final Validator<Integer> INTEGER_ALLOW_MINUS_1 = new Validator<Integer>(){

        @Override
        public Integer apply(String label, String input) throws ValidationException {
            Integer value = 4.parseInteger(label, input);
            if (value != null && value < -1) {
                throw new ValidationException(label, "Negative one (-1) is the only negative value that is allowed");
            }
            return value;
        }
    };
    public static final Validator<Long> LONG = new Validator<Long>(){

        @Override
        public Long apply(String label, String input) throws ValidationException {
            return 5.parseLong(label, input);
        }
    };
    public static final Validator<Long> LONG_POSITIVE = new Validator<Long>(){

        @Override
        public Long apply(String label, String input) throws ValidationException {
            Long value = 6.parseLong(label, input);
            if (value != null && value <= 0L) {
                throw new ValidationException(label, "Only positive values are allowed");
            }
            return value;
        }
    };
    public static final Validator<Long> LONG_POSITIVE_OR_ZERO = new Validator<Long>(){

        @Override
        public Long apply(String label, String input) throws ValidationException {
            Long value = 7.parseLong(label, input);
            if (value != null && value < 0L) {
                throw new ValidationException(label, "Negative values are not allowed");
            }
            return value;
        }
    };
    public static final Validator<Long> LONG_ALLOW_MINUS_1 = new Validator<Long>(){

        @Override
        public Long apply(String label, String input) throws ValidationException {
            Long value = 8.parseLong(label, input);
            if (value != null && value < -1L) {
                throw new ValidationException(label, "Negative one (-1) is the only negative value that is allowed");
            }
            return value;
        }
    };
    public static final Validator<Boolean> BOOLEAN = new Validator<Boolean>(){

        @Override
        public Boolean apply(String label, String input) throws ValidationException {
            return 9.parseBoolean(label, input);
        }
    };
    public static final Validator<String> TRIMMED_STRING = new Validator<String>(){

        @Override
        public String apply(String label, String input) {
            return 10.trim(input);
        }
    };
    public static final Validator<Integer> PORT = new Validator<Integer>(){
        private final int MIN_PORT = 0;
        private final int MAX_PORT = 65535;
        private final String ERROR_MESSAGE = "The port must be a number between " + Integer.toString(0) + " and " + Integer.toString(65535) + ".";

        @Override
        public Integer apply(@Nullable String label, @Nullable String input) throws ValidationException {
            String nonNullInput = NON_EMTPY_STRING.apply(label, input);
            try {
                int httpsPort = Integer.parseInt(nonNullInput);
                if (0 >= httpsPort || httpsPort >= 65535) {
                    throw new ValidationException(label, this.ERROR_MESSAGE);
                }
                return httpsPort;
            }
            catch (NumberFormatException e) {
                throw new ValidationException(label, this.ERROR_MESSAGE);
            }
        }
    };
    public static final Validator<String> NON_EMTPY_STRING = new Validator<String>(){

        @Override
        public String apply(@Nullable String label, @Nullable String input) throws ValidationException {
            String nonNullInput = Strings.nullToEmpty((String)input).trim();
            if (nonNullInput.isEmpty()) {
                throw new ValidationException(label, label + " is a mandatory field.");
            }
            return nonNullInput;
        }
    };
    public static final Validator<String> EXISTING_FILE = new Validator<String>(){

        @Override
        public String apply(@Nullable String label, @Nonnull String input) throws ValidationException {
            String nonNullInput = (String)NON_EMTPY_STRING.apply(label, input);
            File file = new File(nonNullInput).getAbsoluteFile();
            if (!file.exists()) {
                throw new ValidationException(label, "The specified path doesn't exist.");
            }
            if (!file.isFile()) {
                throw new ValidationException(label, "The specified path doesn't denote a file.");
            }
            return file.getPath();
        }
    };

    public abstract T apply(String var1, String var2) throws ValidationException;

    static Boolean parseBoolean(String label, String input) throws ValidationException {
        if ((input = Validator.trim(input)) == null) {
            return null;
        }
        input = input.toLowerCase();
        switch (input.charAt(0)) {
            case '1': 
            case 't': 
            case 'y': {
                return Boolean.TRUE;
            }
            case '0': 
            case 'f': 
            case 'n': {
                return Boolean.FALSE;
            }
        }
        throw new ValidationException(label, "Please use a boolean value like 'true' or 'false'");
    }

    static Integer parseInteger(String label, String input) throws ValidationException {
        return Validator.parseInteger(label, input, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    static Integer parseInteger(String label, String input, int minValue, int maxValue) throws ValidationException {
        Long value = Validator.parseLong(label, input);
        if (value == null) {
            return null;
        }
        if (value < (long)minValue || value > (long)maxValue) {
            throw new ValidationException(label, "The value " + value + " is outside of the accepted range [" + minValue + ',' + maxValue + ']');
        }
        return value.intValue();
    }

    static Long parseLong(String label, String input) throws ValidationException {
        if ((input = Validator.trim(input)) == null) {
            return null;
        }
        try {
            return Long.valueOf(input);
        }
        catch (NumberFormatException nfe) {
            throw new ValidationException(label, "An integer value is required");
        }
    }

    static String trim(String input) {
        if (input != null && (input = input.trim()).length() == 0) {
            return null;
        }
        return input;
    }
}

