/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.config;

import com.atlassian.jira.configurator.config.FileSystem;
import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.config.Validator;
import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FileExistanceWithCancelOptionValidator
extends Validator<String> {
    private final FileSystem fileSystem;

    public FileExistanceWithCancelOptionValidator(@Nonnull FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public String apply(@Nullable String label, @Nonnull String input) throws ValidationException {
        String nonNullInput = Strings.nullToEmpty((String)input).trim();
        if (nonNullInput.isEmpty()) {
            return null;
        }
        if (this.fileSystem.isFileExisting(nonNullInput)) {
            return this.fileSystem.getAbsolutePath(nonNullInput);
        }
        throw new ValidationException(label, "The specified file doesn't exist or is not a file.");
    }
}

