/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.database;

import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigHandler;
import com.atlassian.jira.config.database.DatabaseConfigurationLoader;
import com.atlassian.jira.util.RuntimeIOException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public abstract class AbstractJiraHomeDatabaseConfigurationLoader
implements DatabaseConfigurationLoader {
    public static final String FILENAME_DBCONFIG = "dbconfig.xml";
    private static final String CONFIG_ROOT = "jira-database-config";

    @Override
    public boolean configExists() {
        try {
            return this.getConfigFile(false).exists();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    @Override
    public DatabaseConfig loadDatabaseConfiguration() {
        DatabaseConfigHandler dbConfigHandler = new DatabaseConfigHandler();
        Reader fileReader = null;
        SAXReader xmlReader = new SAXReader();
        try {
            fileReader = this.getReader();
            Document root = xmlReader.read(fileReader);
            DatabaseConfig databaseConfig = dbConfigHandler.parse(root.getRootElement());
            return databaseConfig;
        }
        catch (DocumentException de) {
            throw new RuntimeException("Error parsing database configuration file.", de);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Error reading database configuration file.", ioe);
        }
        finally {
            IOUtils.closeQuietly((Reader)fileReader);
        }
    }

    @Override
    public void saveDatabaseConfiguration(DatabaseConfig config) {
        Document document = DocumentHelper.createDocument();
        Element rootElement = document.addElement(CONFIG_ROOT);
        DatabaseConfigHandler dbConfigHandler = new DatabaseConfigHandler();
        dbConfigHandler.writeTo(rootElement, config);
        Writer writer = null;
        try {
            writer = this.getWriter();
            XMLWriter xmlWriter = new XMLWriter(writer, OutputFormat.createPrettyPrint());
            xmlWriter.write(document);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException("Error writing database configuration file.", ioe);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    Reader getReader() throws IOException {
        File configFile = this.getConfigFile(false);
        this.logInfo("Reading database configuration from " + configFile.getCanonicalPath());
        return new FileReader(configFile);
    }

    Writer getWriter() throws IOException {
        File configFile = this.getConfigFile(true);
        FileWriter writer = new FileWriter(configFile);
        this.logInfo("Storing database configuration in " + configFile.getCanonicalPath());
        return writer;
    }

    private File getConfigFile(boolean createHome) {
        File home = new File(this.getJiraHome());
        if (createHome && !home.exists() && !home.mkdirs()) {
            throw new RuntimeException("Can't create home directory to write database config file.");
        }
        return new File(home, FILENAME_DBCONFIG);
    }

    protected abstract String getJiraHome();

    protected abstract void logInfo(String var1);
}

