/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.util.JiraLocaleUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class DefaultLocaleManager
implements LocaleManager {
    private final JiraLocaleUtils jiraLocaleUtils;
    private final I18nHelper.BeanFactory beanFactory;

    public DefaultLocaleManager(JiraLocaleUtils jiraLocaleUtils, I18nHelper.BeanFactory beanFactory) {
        this.jiraLocaleUtils = jiraLocaleUtils;
        this.beanFactory = beanFactory;
    }

    public Set<Locale> getInstalledLocales() {
        LinkedHashSet<Locale> ret = new LinkedHashSet<Locale>(this.jiraLocaleUtils.getInstalledLocales());
        return Collections.unmodifiableSet(ret);
    }

    public Map<String, String> getInstalledLocalesWithDefault(Locale defaultLocale, I18nHelper i18nHelper) {
        Map<String, String> installedLocalesWithDefault = this.jiraLocaleUtils.getInstalledLocalesWithDefault(defaultLocale, i18nHelper);
        return Collections.unmodifiableMap(installedLocalesWithDefault);
    }

    public Locale getLocale(String locale) {
        return this.jiraLocaleUtils.getLocale(locale);
    }

    public Locale getLocaleFor(ApplicationUser user) {
        return I18nBean.getLocaleFromUser(user);
    }

    public void validateUserLocale(User loggedInUser, final String locale, ErrorCollection errorCollection) {
        if (StringUtils.equals((String)locale, (String)"-1")) {
            return;
        }
        try {
            Iterables.find(this.getInstalledLocales(), (Predicate)new Predicate<Locale>(){

                public boolean apply(@Nullable Locale input) {
                    return input.toString().equals(locale);
                }
            });
        }
        catch (NoSuchElementException nsee) {
            I18nHelper i18n = this.beanFactory.getInstance(loggedInUser);
            errorCollection.addError("userLocale", i18n.getText("preferences.invalid.locale", locale));
        }
    }
}

