/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.AbstractIssueConstantsManager;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueConstantFactory;
import com.atlassian.jira.config.IssueTypeManager;
import com.atlassian.jira.event.config.IssueTypeCreatedEvent;
import com.atlassian.jira.event.config.IssueTypeDeletedEvent;
import com.atlassian.jira.event.config.IssueTypeUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenScheme;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeEntity;
import com.atlassian.jira.issue.fields.screen.issuetype.IssueTypeScreenSchemeManager;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.ObjectUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultIssueTypeManager
extends AbstractIssueConstantsManager<IssueType>
implements IssueTypeManager {
    private final ProjectManager projectManager;
    private final WorkflowManager workflowManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final IssueTypeScreenSchemeManager issueTypeScreenSchemeManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final CustomFieldManager customFieldManager;
    private final EventPublisher eventPublisher;
    private final IssueConstantFactory factory;

    public DefaultIssueTypeManager(ConstantsManager constantsManager, OfBizDelegator ofBizDelegator, IssueIndexManager issueIndexManager, ProjectManager projectManager, WorkflowManager workflowManager, FieldLayoutManager fieldLayoutManager, IssueTypeScreenSchemeManager issueTypeScreenSchemeManager, IssueTypeSchemeManager issueTypeSchemeManager, WorkflowSchemeManager workflowSchemeManager, FieldConfigSchemeManager fieldConfigSchemeManager, CustomFieldManager customFieldManager, EventPublisher eventPublisher, IssueConstantFactory factory) {
        super(constantsManager, ofBizDelegator, issueIndexManager);
        this.projectManager = projectManager;
        this.workflowManager = workflowManager;
        this.fieldLayoutManager = fieldLayoutManager;
        this.issueTypeScreenSchemeManager = issueTypeScreenSchemeManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.customFieldManager = customFieldManager;
        this.eventPublisher = eventPublisher;
        this.factory = factory;
    }

    public synchronized IssueType createIssueType(String name, String description, String iconUrl) {
        return this.createIssueTypeAndAddToDefaultScheme(name, description, iconUrl, null);
    }

    public synchronized IssueType createSubTaskIssueType(String name, String description, String iconUrl) {
        return this.createIssueTypeAndAddToDefaultScheme(name, description, iconUrl, "jira_subtask");
    }

    private IssueType createIssueTypeAndAddToDefaultScheme(String name, String description, String iconUrl, String style) {
        Assertions.notBlank((String)"name", (String)name);
        Assertions.notNull((String)"iconUrl", (Object)iconUrl);
        for (IssueType it : this.getIssueTypes()) {
            if (!name.trim().equalsIgnoreCase(it.getName())) continue;
            throw new IllegalStateException("An issue type with the name '" + name + "' exists already.");
        }
        try {
            String issueStyleType = StringUtils.trimToNull((String)style);
            HashMap<String, Object> fields = new HashMap<String, Object>();
            fields.put("name", name);
            fields.put("description", description);
            fields.put("iconurl", iconUrl);
            fields.put("style", issueStyleType);
            fields.put("id", this.getNextStringId());
            GenericValue issueTypeGV = this.createConstant(fields);
            this.issueTypeSchemeManager.addOptionToDefault(issueTypeGV.getString("id"));
            IssueType issueType = this.factory.createIssueType(issueTypeGV);
            this.eventPublisher.publish((Object)new IssueTypeCreatedEvent(issueType, issueStyleType));
            IssueType issueType2 = issueType;
            return issueType2;
        }
        catch (GenericEntityException ex) {
            throw new DataAccessException("Failed to create issue type with name '" + name + "'", (Throwable)ex);
        }
        finally {
            this.clearCaches();
        }
    }

    @Override
    protected void clearCaches() {
        this.constantsManager.refreshIssueTypes();
    }

    public void editIssueType(IssueType issueType, String name, String description, String iconUrl) {
        Assertions.notNull((String)"issueType", (Object)issueType);
        Assertions.notBlank((String)"name", (String)name);
        Assertions.notBlank((String)"iconUrl", (String)iconUrl);
        for (IssueType it : this.getIssueTypes()) {
            if (!name.equalsIgnoreCase(it.getName()) || issueType.getId().equals(issueType.getId())) continue;
            throw new IllegalStateException("Cannot rename issue type. An issue type with the name '" + name + "' exists already.");
        }
        issueType.setName(name);
        issueType.setDescription(description);
        issueType.setIconUrl(iconUrl);
        try {
            issueType.getGenericValue().store();
            this.eventPublisher.publish((Object)new IssueTypeUpdatedEvent(issueType, null));
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Failed to update issue type '" + name + "'", (Throwable)e);
        }
        finally {
            this.clearCaches();
        }
    }

    public Collection<IssueType> getIssueTypes() {
        return this.constantsManager.getAllIssueTypeObjects();
    }

    public void removeIssueType(String id, String newIssueTypeId) {
        IssueType newIT;
        Assertions.notBlank((String)"id", (String)id);
        IssueType issueType = this.constantsManager.getIssueTypeObject(id);
        if (issueType == null) {
            throw new IllegalArgumentException("An issue type with id '" + id + "' does not exist.");
        }
        if (StringUtils.isNotBlank((String)newIssueTypeId) && (newIT = this.constantsManager.getIssueTypeObject(newIssueTypeId)) == null) {
            throw new IllegalArgumentException("An issue type with id '" + newIssueTypeId + "' does not exist.");
        }
        try {
            boolean issuesWithThisTypeExist;
            boolean bl = issuesWithThisTypeExist = !this.getMatchingIssues(issueType).isEmpty();
            if (issuesWithThisTypeExist && this.getAvailableIssueTypes(issueType).isEmpty()) {
                throw new IllegalStateException("Cannot remove issue type with id '" + id + "', because there is no alternative issue type available.");
            }
            List workflowSchemes = this.workflowSchemeManager.getSchemes();
            for (GenericValue workflowScheme : workflowSchemes) {
                List entities = this.workflowSchemeManager.getEntities(workflowScheme);
                for (GenericValue entity : entities) {
                    if (!issueType.getId().equals(entity.getString("issuetype"))) continue;
                    this.workflowSchemeManager.deleteEntity(entity.getLong("id"));
                }
            }
            for (FieldLayoutScheme fieldLayoutScheme : this.fieldLayoutManager.getFieldLayoutSchemes()) {
                if (!fieldLayoutScheme.containsEntity(issueType.getId())) continue;
                fieldLayoutScheme.removeEntity(issueType.getId());
            }
            for (IssueTypeScreenScheme issueTypeScreenScheme : this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemes()) {
                if (!issueTypeScreenScheme.containsEntity(issueType.getId())) continue;
                issueTypeScreenScheme.removeEntity(issueType.getId());
            }
            this.fieldConfigSchemeManager.removeInvalidFieldConfigSchemesForIssueType(issueType);
            this.customFieldManager.refresh();
            this.issueTypeSchemeManager.removeOptionFromAllSchemes(issueType.getId());
            this.removeConstant("type", issueType, newIssueTypeId);
            this.eventPublisher.publish((Object)new IssueTypeDeletedEvent(issueType, null));
        }
        catch (Exception ex) {
            throw new DataAccessException("Failed to remove issueType with id '" + id + "'", (Throwable)ex);
        }
    }

    public IssueType getIssueType(String id) {
        Assertions.notBlank((String)"id", (String)id);
        return this.constantsManager.getIssueTypeObject(id);
    }

    public Collection<IssueType> getAvailableIssueTypes(IssueType issueType) {
        return Lists.newArrayList((Iterable)Iterables.transform(this.getAvailableIssueTypesGenericValues(issueType), (Function)new Function<GenericValue, IssueType>(){

            public IssueType apply(@Nullable GenericValue from) {
                return DefaultIssueTypeManager.this.factory.createIssueType(from);
            }
        }));
    }

    @Override
    protected String getIssueConstantField() {
        return "IssueType";
    }

    @Override
    protected List<IssueType> getAllValues() {
        return Lists.newArrayList((Iterable)this.constantsManager.getRegularIssueTypeObjects());
    }

    private Collection<GenericValue> getAvailableIssueTypesGenericValues(IssueType issueType) {
        Collection projects = this.projectManager.getProjects();
        try {
            CheckIssueTypeAssociationsResult checkIssueTypeAssociationsResult = this.checkIssueTypeAssociations(issueType, projects);
            if (!checkIssueTypeAssociationsResult.valid) {
                return Collections.emptyList();
            }
            GenericValue issueTypeGV = this.constantsManager.getIssueType(issueType.getId());
            Collection issueTypes = this.constantsManager.getSubTaskIssueTypes().contains(issueTypeGV) ? this.constantsManager.getSubTaskIssueTypes() : this.constantsManager.getIssueTypes();
            Collection<GenericValue> availableIssueTypes = this.getAlternativeTypes(issueType, issueTypes, projects, checkIssueTypeAssociationsResult.workflow, checkIssueTypeAssociationsResult.fieldScreenScheme, checkIssueTypeAssociationsResult.fieldLayoutId);
            return availableIssueTypes;
        }
        catch (GenericEntityException ex) {
            throw new DataAccessException("Failed to read list of available issue types.", (Throwable)ex);
        }
    }

    private CheckIssueTypeAssociationsResult checkIssueTypeAssociations(IssueType issueType, Collection<GenericValue> projects) throws WorkflowException, GenericEntityException {
        JiraWorkflow workflow = null;
        FieldScreenScheme fieldScreenScheme = null;
        Long fieldLayoutId = null;
        for (GenericValue projectGV : projects) {
            if (workflow == null) {
                workflow = this.workflowManager.getWorkflow(projectGV.getLong("id"), issueType.getId());
                continue;
            }
            if (workflow.equals(this.workflowManager.getWorkflow(projectGV.getLong("id"), issueType.getId()))) continue;
            return new CheckIssueTypeAssociationsResult(false, workflow, fieldScreenScheme, fieldLayoutId);
        }
        int i = 0;
        for (FieldLayoutScheme layoutScheme : this.fieldLayoutManager.getFieldLayoutSchemes()) {
            if (layoutScheme.getProjects().isEmpty()) continue;
            if (i == 0) {
                fieldLayoutId = layoutScheme.getFieldLayoutId(issueType.getId());
                ++i;
                continue;
            }
            if (ObjectUtils.equalsNullSafe((Object)fieldLayoutId, (Object)layoutScheme.getFieldLayoutId(issueType.getId()))) continue;
            return new CheckIssueTypeAssociationsResult(false, workflow, fieldScreenScheme, fieldLayoutId);
        }
        i = 0;
        for (IssueTypeScreenScheme issueTypeScreenScheme : this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemes()) {
            if (issueTypeScreenScheme.getProjects().isEmpty()) continue;
            IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(issueType.getId());
            if (issueTypeScreenSchemeEntity == null) {
                issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(null);
            }
            if (i == 0) {
                fieldScreenScheme = issueTypeScreenSchemeEntity.getFieldScreenScheme();
                ++i;
                continue;
            }
            if (ObjectUtils.equalsNullSafe((Object)fieldScreenScheme, (Object)issueTypeScreenSchemeEntity.getFieldScreenScheme())) continue;
            return new CheckIssueTypeAssociationsResult(false, workflow, fieldScreenScheme, fieldLayoutId);
        }
        return new CheckIssueTypeAssociationsResult(true, workflow, fieldScreenScheme, fieldLayoutId);
    }

    private Collection<GenericValue> getAlternativeTypes(IssueType issueType, Collection<GenericValue> issueTypes, Collection<GenericValue> projects, JiraWorkflow jiraWorkflow, FieldScreenScheme fieldScreenScheme, Long fieldLayoutId) throws WorkflowException {
        GenericValue issueTypeGV2;
        HashSet<GenericValue> availableIssueTypes = new HashSet<GenericValue>();
        block0: for (GenericValue issueTypeGV2 : issueTypes) {
            if (issueType.getId().equals(issueTypeGV2.getString("id"))) continue;
            for (GenericValue projectGV : projects) {
                if (jiraWorkflow.equals(this.workflowManager.getWorkflow(projectGV.getLong("id"), issueTypeGV2.getString("id")))) continue;
                continue block0;
            }
            availableIssueTypes.add(issueTypeGV2);
        }
        Iterator iterator = availableIssueTypes.iterator();
        block2: while (iterator.hasNext()) {
            issueTypeGV2 = (GenericValue)iterator.next();
            for (FieldLayoutScheme fieldLayoutScheme : this.fieldLayoutManager.getFieldLayoutSchemes()) {
                Long flid;
                if (fieldLayoutScheme.getProjects().isEmpty() || ObjectUtils.equalsNullSafe((Object)fieldLayoutId, (Object)(flid = fieldLayoutScheme.getFieldLayoutId(issueTypeGV2.getString("id"))))) continue;
                iterator.remove();
                continue block2;
            }
        }
        iterator = availableIssueTypes.iterator();
        block4: while (iterator.hasNext()) {
            issueTypeGV2 = (GenericValue)iterator.next();
            for (IssueTypeScreenScheme issueTypeScreenScheme : this.issueTypeScreenSchemeManager.getIssueTypeScreenSchemes()) {
                if (issueTypeScreenScheme.getProjects().isEmpty()) continue;
                IssueTypeScreenSchemeEntity issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(issueTypeGV2.getString("id"));
                if (issueTypeScreenSchemeEntity == null) {
                    issueTypeScreenSchemeEntity = issueTypeScreenScheme.getEntity(null);
                }
                if (ObjectUtils.equalsNullSafe((Object)fieldScreenScheme, (Object)issueTypeScreenSchemeEntity.getFieldScreenScheme())) continue;
                iterator.remove();
                continue block4;
            }
        }
        return availableIssueTypes;
    }

    private class CheckIssueTypeAssociationsResult {
        public boolean valid = false;
        public JiraWorkflow workflow = null;
        public FieldScreenScheme fieldScreenScheme;
        public Long fieldLayoutId;

        private CheckIssueTypeAssociationsResult(boolean valid, JiraWorkflow workflow, FieldScreenScheme fieldScreenScheme, Long fieldLayoutId) {
            this.valid = valid;
            this.workflow = workflow;
            this.fieldScreenScheme = fieldScreenScheme;
            this.fieldLayoutId = fieldLayoutId;
        }
    }
}

