/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.jira.cluster.ClusterMessage;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.cluster.NodeStateManager;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class OfBizClusterMessageStore {
    private final OfBizDelegator ofBizDelegator;
    private final NodeStateManager nodeStateManager;
    private static final String ENTITY = "ClusterMessage";
    private static final String ID = "id";
    private static final String SOURCE_NODE = "sourceNode";
    private static final String DESTINATION_NODE = "destinationNode";
    private static final String MESSAGE = "message";

    public OfBizClusterMessageStore(OfBizDelegator ofBizDelegator, NodeStateManager nodeStateManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.nodeStateManager = nodeStateManager;
    }

    public GenericValue storeMessage(@Nonnull ClusterMessage message) {
        return this.storeFieldMap(this.getFields(message));
    }

    public ClusterMessage createMessage(@Nonnull String destinationNode, @Nonnull String message) {
        ImmutableMap fields = ImmutableMap.of((Object)SOURCE_NODE, (Object)this.nodeStateManager.getNode().getNodeId(), (Object)DESTINATION_NODE, (Object)destinationNode, (Object)MESSAGE, (Object)message);
        GenericValue gv = this.storeFieldMap((Map<String, Object>)fields);
        return this.fromGv(gv);
    }

    public List<ClusterMessage> getMessages() {
        String destinationNode = this.nodeStateManager.getNode().getNodeId();
        EntityExpr findByNodeid = new EntityExpr(DESTINATION_NODE, EntityOperator.EQUALS, (Object)destinationNode);
        EntityExpr findByAllNodes = new EntityExpr(DESTINATION_NODE, EntityOperator.EQUALS, (Object)"ALL");
        EntityExpr findByAnyNode = new EntityExpr(DESTINATION_NODE, EntityOperator.EQUALS, (Object)"ANY");
        EntityExpr ignoreOwnMessages = new EntityExpr(SOURCE_NODE, EntityOperator.NOT_EQUAL, (Object)this.nodeStateManager.getNode().getNodeId());
        EntityConditionList findByNodes = new EntityConditionList((List)Lists.newArrayList((Object[])new EntityCondition[]{findByNodeid, findByAnyNode, findByAllNodes}), EntityOperator.OR);
        List gvs = this.ofBizDelegator.findByAnd(ENTITY, (List)Lists.newArrayList((Object[])new EntityCondition[]{ignoreOwnMessages, findByNodes}));
        List messages = Lists.transform((List)gvs, (Function)new Function<GenericValue, ClusterMessage>(){

            public ClusterMessage apply(@Nullable GenericValue input) {
                return OfBizClusterMessageStore.this.fromGv(input);
            }
        });
        return messages;
    }

    public int deleteMessage(ClusterMessage clusterMessage) {
        return this.ofBizDelegator.removeById(ENTITY, clusterMessage.getId());
    }

    private ClusterMessage fromGv(@Nonnull GenericValue gv) {
        Message message = Message.fromMessage(gv.getString(MESSAGE));
        return new ClusterMessage(gv.getLong(ID), gv.getString(SOURCE_NODE), gv.getString(DESTINATION_NODE), message);
    }

    private GenericValue storeFieldMap(@Nonnull Map<String, Object> fields) {
        return this.ofBizDelegator.createValue(ENTITY, fields);
    }

    private Map<String, Object> getFields(ClusterMessage message) {
        return new FieldMap(ID, (Object)message.getId()).add(SOURCE_NODE, (Object)message.getSourceNode()).add(DESTINATION_NODE, (Object)message.getDestinationNode()).add(MESSAGE, (Object)message.getMessage());
    }
}

