/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster;

import com.atlassian.jira.cluster.FailoverProperties;
import com.atlassian.jira.cluster.Node;
import com.atlassian.jira.cluster.NodeStateManager;
import com.atlassian.jira.cluster.OfBizClusterNodeStore;
import com.atlassian.util.concurrent.LazyReference;

public class DefaultNodeStateManager
implements NodeStateManager {
    private final OfBizClusterNodeStore ofBizClusterNodeStore;
    private final FailoverProperties failoverProperties;
    private LazyReference<Node> nodeRef = new LazyReference<Node>(){

        protected Node create() throws Exception {
            return DefaultNodeStateManager.this.initialIzeNode();
        }
    };

    public DefaultNodeStateManager(OfBizClusterNodeStore ofBizClusterNodeStore, FailoverProperties failoverProperties) {
        this.ofBizClusterNodeStore = ofBizClusterNodeStore;
        this.failoverProperties = failoverProperties;
    }

    @Override
    public Node getNode() {
        return (Node)this.nodeRef.get();
    }

    private Node initialIzeNode() {
        Node node;
        String nodeId = this.failoverProperties.getNodeId();
        if (nodeId != null) {
            node = this.ofBizClusterNodeStore.getNode(nodeId);
            if (node == null) {
                Node.NodeState state = Node.NodeState.PASSIVE;
                if (this.ofBizClusterNodeStore.getAllNodes().isEmpty()) {
                    state = Node.NodeState.ACTIVE;
                }
                node = this.ofBizClusterNodeStore.createNode(nodeId, state);
            }
        } else {
            node = new Node(null, Node.NodeState.ACTIVE);
        }
        return node;
    }
}

