/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.charts.piechart;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.charts.PieSegment;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestAppender;
import com.atlassian.jira.issue.search.util.RedundantClausesQueryOptimizer;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.query.Query;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;

public class PieChartUrlGeneratorFactory {
    private final SearchService searchService;
    private final VelocityRequestContext velocityRequestContext;
    private final SearchRequestAppender searchRequestAppender;
    private final User remoteUser;
    private final SearchRequest baseSearchRequest;

    public PieChartUrlGeneratorFactory(SearchService searchService, ApplicationProperties applicationProperties, SearchRequestAppender searchRequestAppender, User remoteUser, SearchRequest baseSearchRequest) {
        this.searchService = (SearchService)Assertions.notNull((Object)searchService);
        this.searchRequestAppender = (SearchRequestAppender)Assertions.notNull((Object)searchRequestAppender);
        this.remoteUser = (User)Assertions.notNull((Object)remoteUser);
        this.baseSearchRequest = (SearchRequest)Assertions.notNull((Object)baseSearchRequest);
        this.velocityRequestContext = new DefaultVelocityRequestContextFactory(applicationProperties).getJiraVelocityRequestContext();
    }

    public CategoryURLGenerator getCategoryUrlGenerator() {
        return new CategoryURLGenerator(){

            public String generateURL(CategoryDataset categoryDataset, int row, int col) {
                Comparable key = categoryDataset.getColumnKey(col);
                if (key instanceof PieSegment) {
                    Object statisticKey = ((PieSegment)key).getKey();
                    SearchRequest searchRequest = PieChartUrlGeneratorFactory.this.searchRequestAppender.appendInclusiveSingleValueClause(statisticKey, PieChartUrlGeneratorFactory.this.baseSearchRequest);
                    return PieChartUrlGeneratorFactory.this.createIssueNavigatorUrl(searchRequest, PieChartUrlGeneratorFactory.this.velocityRequestContext, PieChartUrlGeneratorFactory.this.remoteUser);
                }
                return null;
            }
        };
    }

    public PieURLGenerator getPieUrlGenerator(final Comparable otherSegmentKey) {
        return new PieURLGenerator(){

            public String generateURL(PieDataset dataset, Comparable pieSegmentKey, int pieSectionIdx) {
                if (pieSegmentKey instanceof PieSegment && ((PieSegment)pieSegmentKey).isGenerateUrl()) {
                    PieSegment pieSegment = (PieSegment)pieSegmentKey;
                    Object statisticKey = pieSegment.getKey();
                    SearchRequest searchRequestForPieSegment = PieChartUrlGeneratorFactory.this.searchRequestAppender.appendInclusiveSingleValueClause(statisticKey, PieChartUrlGeneratorFactory.this.baseSearchRequest);
                    return PieChartUrlGeneratorFactory.this.createIssueNavigatorUrl(searchRequestForPieSegment, PieChartUrlGeneratorFactory.this.velocityRequestContext, PieChartUrlGeneratorFactory.this.remoteUser);
                }
                if (pieSegmentKey == otherSegmentKey) {
                    Collection allStatisticKeys = PieChartUrlGeneratorFactory.getAllStatisticKeys(dataset);
                    SearchRequest searchRequestForPieSegment = PieChartUrlGeneratorFactory.this.searchRequestAppender.appendExclusiveMultiValueClause((Iterable)allStatisticKeys, PieChartUrlGeneratorFactory.this.baseSearchRequest);
                    return PieChartUrlGeneratorFactory.this.createIssueNavigatorUrl(searchRequestForPieSegment, PieChartUrlGeneratorFactory.this.velocityRequestContext, PieChartUrlGeneratorFactory.this.remoteUser);
                }
                return null;
            }
        };
    }

    private static Collection getAllStatisticKeys(PieDataset pieDataset) {
        ArrayList statisticKeys = Lists.newArrayList();
        List segmentKeys = pieDataset.getKeys();
        for (Object segmentKey : segmentKeys) {
            if (!(segmentKey instanceof PieSegment)) continue;
            statisticKeys.add(((PieSegment)segmentKey).getKey());
        }
        return statisticKeys;
    }

    private String createIssueNavigatorUrl(SearchRequest searchRequest, VelocityRequestContext velocityRequestContext, User remoteUser) {
        if (searchRequest == null) {
            return null;
        }
        Query optimizedQuery = new RedundantClausesQueryOptimizer().optimizeQuery(searchRequest.getQuery());
        return velocityRequestContext.getCanonicalBaseUrl() + "/secure/IssueNavigator.jspa?reset=true" + this.searchService.getQueryString(remoteUser, optimizedQuery);
    }
}

