/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bulkedit.operation;

import com.atlassian.jira.bulkedit.operation.BulkEditAction;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.bean.BulkEditBean;
import org.apache.log4j.Logger;

public class BulkEditActionImpl
implements BulkEditAction {
    private static final Logger log = Logger.getLogger(BulkEditActionImpl.class);
    private String orderableFieldId;
    private final FieldManager fieldManager;
    private final JiraAuthenticationContext authenticationContext;
    private boolean initialised;
    private String unavailableMessage;

    public BulkEditActionImpl(String orderableFieldId, FieldManager fieldManager, JiraAuthenticationContext authenticationContext) {
        this.orderableFieldId = orderableFieldId;
        this.fieldManager = fieldManager;
        this.authenticationContext = authenticationContext;
        this.initialised = false;
    }

    public boolean isAvailable(BulkEditBean bulkEditBean) {
        if (!this.initialised) {
            this.setUnavailableMessage(this.getField().availableForBulkEdit(bulkEditBean));
            this.initialised = true;
        }
        return this.getUnavailableMessage() == null;
    }

    public OrderableField getField() {
        return this.fieldManager.getOrderableField(this.orderableFieldId);
    }

    public String getFieldName() {
        if (this.fieldManager.isCustomField((Field)this.getField())) {
            return this.fieldManager.getCustomField(this.orderableFieldId).getFieldName();
        }
        return this.authenticationContext.getI18nHelper().getText(this.getField().getNameKey());
    }

    public String getUnavailableMessage() {
        return this.unavailableMessage;
    }

    protected void setUnavailableMessage(String unavailableMessage) {
        this.unavailableMessage = unavailableMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BulkEditAction)) {
            return false;
        }
        BulkEditAction bulkEditAction = (BulkEditAction)o;
        if (this.getField() != null ? !this.getField().equals(bulkEditAction.getField()) : bulkEditAction.getField() != null) {
            return false;
        }
        return !(this.unavailableMessage != null ? !this.unavailableMessage.equals(bulkEditAction.getUnavailableMessage()) : bulkEditAction.getUnavailableMessage() != null);
    }

    public int hashCode() {
        int result = this.orderableFieldId != null ? this.orderableFieldId.hashCode() : 0;
        result = 29 * result + (this.unavailableMessage != null ? this.unavailableMessage.hashCode() : 0);
        return result;
    }
}

