/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.project.index;

import com.atlassian.jira.bc.project.index.ProjectIndexTaskContext;
import com.atlassian.jira.config.ReindexMessage;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.IssueBatcherFactory;
import com.atlassian.jira.issue.index.IssueIndexer;
import com.atlassian.jira.issue.index.IssuesBatcher;
import com.atlassian.jira.issue.util.IssuesIterable;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.EnclosedIterable;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.index.Contexts;
import com.atlassian.jira.web.action.admin.index.IndexCommandResult;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;

class ReIndexProjectIndexerCommand
implements Callable<IndexCommandResult>,
ProvidesTaskProgress {
    private final Project project;
    private final OfBizDelegator delegator;
    private final IssueIndexer issueIndexer;
    private final ReindexMessageManager reindexMessageManager;
    private final TaskManager taskManager;
    private final IssueBatcherFactory issueBatcherFactory;
    private final Logger log;
    private final I18nHelper i18nHelper;
    private volatile TaskProgressSink taskProgressSink;

    public ReIndexProjectIndexerCommand(Project project, OfBizDelegator delegator, IssueIndexer issueIndexer, ReindexMessageManager reindexMessageManager, TaskManager taskManager, IssueBatcherFactory issueBatcherFactory, Logger log, I18nHelper i18nHelper) {
        this.issueIndexer = issueIndexer;
        this.reindexMessageManager = reindexMessageManager;
        this.taskManager = taskManager;
        this.delegator = delegator;
        this.project = project;
        this.issueBatcherFactory = issueBatcherFactory;
        this.log = log;
        this.i18nHelper = i18nHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexCommandResult call() {
        Event appEvent = new Event(EventType.get((String)"reindex"), "JIRA is currently being reindexed. Depending on how large the database is, this may take a few minutes. JIRA will automatically become available as soon as this task is complete.", EventLevel.get((String)"warning"));
        try {
            Context context = Contexts.percentageReporter((Sized)new Sized(){

                public int size() {
                    return (int)ReIndexProjectIndexerCommand.this.delegator.getCountByAnd("Issue", (Map)ImmutableMap.of((Object)"project", (Object)ReIndexProjectIndexerCommand.this.project.getId()));
                }

                public boolean isEmpty() {
                    return this.size() == 0;
                }
            }, (TaskProgressSink)this.taskProgressSink, (I18nHelper)this.i18nHelper, (Logger)this.log, (Event)appEvent);
            this.log.info((Object)"Re-indexing started");
            Assertions.notNull((String)"context", (Object)context);
            context.setName("Issue");
            this.log.info((Object)String.format("Reindexing issues in project %s", this.project.getName()));
            long startTime = System.currentTimeMillis();
            ReindexMessage message = this.reindexMessageManager.getMessageObject();
            try {
                EntityExpr where = new EntityExpr("project", EntityOperator.EQUALS, (Object)this.project.getId());
                IssuesBatcher batcher = this.issueBatcherFactory.getBatcher((EntityCondition)where);
                for (IssuesIterable batchOfIssues : batcher) {
                    TaskDescriptor currentTaskDescriptor = this.taskManager.getLiveTask(new ProjectIndexTaskContext(this.project));
                    if (currentTaskDescriptor.isCancelled()) {
                        throw new InterruptedException();
                    }
                    this.issueIndexer.reindexIssues((EnclosedIterable<Issue>)batchOfIssues, context, false, false, true).await();
                }
            }
            catch (InterruptedException e) {
                IndexCommandResult indexCommandResult = new IndexCommandResult(-1L);
                this.log.info((Object)"Re-indexing finished");
                return indexCommandResult;
            }
            if (message != null) {
                this.reindexMessageManager.clearMessageForTimestamp(message.getTime());
            }
            long totalTime = System.currentTimeMillis() - startTime;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Reindex took : " + totalTime + "ms"));
            }
            IndexCommandResult indexCommandResult = new IndexCommandResult(totalTime);
            return indexCommandResult;
        }
        finally {
            this.log.info((Object)"Re-indexing finished");
        }
    }

    public I18nHelper getI18nHelper() {
        return this.i18nHelper;
    }

    @Override
    public void setTaskProgressSink(TaskProgressSink taskProgressSink) {
        this.taskProgressSink = taskProgressSink;
    }
}

