/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.appconsistency.integrity.check;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.appconsistency.integrity.check.CheckAmendment;
import com.atlassian.jira.appconsistency.integrity.check.CheckImpl;
import com.atlassian.jira.appconsistency.integrity.exception.IntegrityException;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.util.profiling.UtilTimerStack;
import com.opensymphony.workflow.StoreException;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.spi.WorkflowStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class WorkflowCurrentStepCheck
extends CheckImpl {
    private final ConstantsManager constantsManager;
    private final WorkflowManager workflowManager;

    public WorkflowCurrentStepCheck(OfBizDelegator ofBizDelegator, int id) {
        this(ofBizDelegator, id, ComponentAccessor.getConstantsManager(), ComponentAccessor.getWorkflowManager());
    }

    public WorkflowCurrentStepCheck(OfBizDelegator ofBizDelegator, int id, ConstantsManager constantsManager, WorkflowManager workflowManager) {
        super(ofBizDelegator, id);
        this.workflowManager = workflowManager;
        this.constantsManager = constantsManager;
    }

    @Override
    public String getDescription() {
        return this.getI18NBean().getText("admin.integrity.check.workflow.current.step.desc");
    }

    @Override
    public List preview() throws IntegrityException {
        return this.doCheck(false);
    }

    @Override
    public List correct() throws IntegrityException {
        return this.doCheck(true);
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public String getUnavailableMessage() {
        return "";
    }

    private List doCheck(boolean correct) throws IntegrityException {
        ArrayList<CheckAmendment> results = new ArrayList<CheckAmendment>();
        String name = "WorkFlowCurrentStepCheck.doCheck";
        UtilTimerStack.push((String)"WorkFlowCurrentStepCheck.doCheck");
        try {
            Collection issueIds = this.getIssueIds();
            block9: for (Object issueId1 : issueIds) {
                Long issueId = (Long)issueId1;
                GenericValue issue = this.ofBizDelegator.findById("Issue", issueId);
                if (issue == null) continue;
                Long workflowEntryId = issue.getLong("workflowId");
                String issueKey = issue.getString("key");
                List currentSteps = this.ofBizDelegator.findByAnd("OSCurrentStep", EasyMap.build((Object)"entryId", (Object)workflowEntryId));
                GenericValue status = this.getStatus(issue.getString("status"));
                if (status == null) continue;
                JiraWorkflow workflow = this.workflowManager.getWorkflow(issue);
                StepDescriptor stepInWorkflow = workflow.getLinkedStep(status);
                if (stepInWorkflow != null) {
                    int stepInWorkflowId = stepInWorkflow.getId();
                    switch (currentSteps.size()) {
                        case 0: {
                            if (stepInWorkflow.getActions().isEmpty()) continue block9;
                            this.createStep(correct, workflowEntryId, stepInWorkflowId, issue, results);
                            break;
                        }
                        case 1: {
                            this.validateStep(correct, currentSteps, stepInWorkflowId, issueKey, workflowEntryId, results);
                            break;
                        }
                        default: {
                            this.deleteSteps(correct, currentSteps, stepInWorkflowId, issueKey, workflowEntryId, results);
                            break;
                        }
                    }
                    continue;
                }
                results.add(new CheckAmendment(1, this.getI18NBean().getText("admin.integrity.check.workflow.current.step.unfixable", issueKey, status.getString("name")), "JRA-8326"));
            }
        }
        catch (Exception e) {
            throw new IntegrityException("Error occurred while performing check.", e);
        }
        finally {
            UtilTimerStack.pop((String)"WorkFlowCurrentStepCheck.doCheck");
        }
        return results;
    }

    private void deleteSteps(boolean correct, List currentSteps, int stepInWorkflowId, String issueKey, Long workflowEntryId, List results) throws GenericEntityException {
        if (correct) {
            String message;
            GenericValue step = (GenericValue)currentSteps.get(0);
            if (step.getInteger("stepId") != stepInWorkflowId) {
                step.set("stepId", (Object)new Integer(stepInWorkflowId));
                step.store();
                message = this.getI18NBean().getText("admin.integrity.check.workflow.current.step.delete.message1", issueKey, workflowEntryId.toString());
                results.add(new CheckAmendment(2, message, "JRA-4539"));
            }
            for (int j = 1; j < currentSteps.size(); ++j) {
                step = (GenericValue)currentSteps.get(j);
                step.remove();
            }
            message = this.getI18NBean().getText("admin.integrity.check.workflow.current.step.delete.message2", issueKey, workflowEntryId.toString());
            results.add(new CheckAmendment(2, message, "JRA-4539"));
        } else {
            String message = this.getI18NBean().getText("admin.integrity.check.workflow.current.step.delete.preview", issueKey, workflowEntryId.toString());
            results.add(new CheckAmendment(2, message, "JRA-4539"));
        }
    }

    private void validateStep(boolean correct, List currentSteps, int stepInWorkflowId, String issueKey, Long workflowEntryId, List results) throws GenericEntityException {
        GenericValue step = (GenericValue)currentSteps.get(0);
        if (correct) {
            if (step.getInteger("stepId") == null || step.getInteger("stepId") != stepInWorkflowId) {
                step.set("stepId", (Object)new Integer(stepInWorkflowId));
                step.store();
                String message = this.getI18NBean().getText("admin.integrity.check.workflow.current.step.validate.message", issueKey, workflowEntryId.toString());
                results.add(new CheckAmendment(2, message, "JRA-4539"));
            }
        } else if (step.getInteger("stepId") == null || step.getInteger("stepId") != stepInWorkflowId) {
            String message = this.getI18NBean().getText("admin.integrity.check.workflow.current.step.validate.preview", issueKey, workflowEntryId.toString());
            results.add(new CheckAmendment(2, message, "JRA-4539"));
        }
    }

    private void createStep(boolean correct, Long workflowEntryId, int stepInWorkflowId, GenericValue issue, List results) throws StoreException {
        if (correct) {
            WorkflowStore store = this.workflowManager.getStore();
            store.createCurrentStep(workflowEntryId.longValue(), stepInWorkflowId, null, (Date)issue.getTimestamp("created"), null, issue.getString("status"), null);
            String message = this.getI18NBean().getText("admin.integrity.check.workflow.current.step.correct.message", issue.getString("key"), workflowEntryId.toString());
            results.add(new CheckAmendment(2, message, "JRA-4539"));
        } else {
            String message = this.getI18NBean().getText("admin.integrity.check.workflow.current.step.correct.preview", issue.getString("key"), workflowEntryId.toString());
            results.add(new CheckAmendment(2, message, "JRA-4539"));
        }
    }

    private GenericValue getStatus(String status) {
        return this.constantsManager.getStatus(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getIssueIds() {
        ArrayList<Long> issueIds = new ArrayList<Long>();
        OfBizListIterator listIterator = null;
        try {
            listIterator = this.ofBizDelegator.findListIteratorByCondition("Issue", null, null, (Collection)EasyList.build((Object)"id"), null, null);
            GenericValue issueIdGV = listIterator.next();
            while (issueIdGV != null) {
                issueIds.add(issueIdGV.getLong("id"));
                issueIdGV = listIterator.next();
            }
        }
        finally {
            if (listIterator != null) {
                listIterator.close();
            }
        }
        return issueIds;
    }
}

