/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.core.ofbiz.util;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.util.DateUtils;
import com.atlassian.core.util.ObjectUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class EntityUtils {
    private static final EntityOperator[] entityOperators = new EntityOperator[]{EntityOperator.EQUALS, EntityOperator.NOT_EQUAL, EntityOperator.LESS_THAN, EntityOperator.GREATER_THAN, EntityOperator.LESS_THAN_EQUAL_TO, EntityOperator.GREATER_THAN_EQUAL_TO, EntityOperator.IN, EntityOperator.BETWEEN, EntityOperator.NOT, EntityOperator.AND, EntityOperator.OR};

    public static EntityOperator getOperator(String code) {
        for (EntityOperator operator : entityOperators) {
            if (!operator.toString().trim().equals(code.trim())) continue;
            return operator;
        }
        return null;
    }

    public static GenericValue createValue(String entity, Map<String, ?> paramMap) throws GenericEntityException {
        HashMap<String, Long> params;
        HashMap<String, Long> hashMap = params = paramMap == null ? new HashMap<String, Long>() : new HashMap(paramMap);
        if (params.get("id") == null) {
            Long id = CoreFactory.getGenericDelegator().getNextSeqId(entity);
            params.put("id", id);
        }
        GenericValue v = CoreFactory.getGenericDelegator().makeValue(entity, params);
        v.create();
        return v;
    }

    public static boolean identical(GenericValue v1, GenericValue v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        if (!v1.getEntityName().equals(v2.getEntityName())) {
            return false;
        }
        for (String key : v1.getAllKeys()) {
            Timestamp t2;
            Timestamp t1;
            if (v1.get(key) == null && v2.get(key) == null) continue;
            if (v1.get(key) == null && v2.get(key) != null) {
                return false;
            }
            if (!(v1.get(key) instanceof Timestamp && v2.get(key) instanceof Timestamp ? !DateUtils.equalTimestamps((Timestamp)(t1 = (Timestamp)v1.get(key)), (Timestamp)(t2 = (Timestamp)v2.get(key))) : !v1.get(key).equals(v2.get(key)))) continue;
            return false;
        }
        ArrayList uncheckedKeys = new ArrayList(v2.getAllKeys());
        uncheckedKeys.removeAll(v1.getAllKeys());
        if (uncheckedKeys.size() > 0) {
            for (String key : uncheckedKeys) {
                if (v2.get(key) == null) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean contains(Collection<GenericValue> entities, GenericValue entity) {
        for (GenericValue gv : entities) {
            if (!EntityUtils.identical(gv, entity)) continue;
            return true;
        }
        return false;
    }

    public static List<GenericValue> filterByAnd(List<GenericValue> values, List<? extends EntityExpr> exprs) {
        if (values == null) {
            return null;
        }
        if (exprs == null || exprs.size() == 0) {
            return values;
        }
        ArrayList<GenericValue> result = new ArrayList<GenericValue>();
        for (GenericValue value : values) {
            boolean include = true;
            for (EntityExpr entityExpr : exprs) {
                Object lhs = value.get((String)entityExpr.getLhs());
                Object rhs = entityExpr.getRhs();
                if (EntityOperator.EQUALS.equals((Object)entityExpr.getOperator())) {
                    include = ObjectUtils.isIdentical((Object)lhs, (Object)rhs);
                    if (include) continue;
                    break;
                }
                if (EntityOperator.NOT_EQUAL.equals((Object)entityExpr.getOperator())) {
                    include = ObjectUtils.isDifferent((Object)lhs, (Object)rhs);
                    if (include) continue;
                    break;
                }
                if (EntityOperator.GREATER_THAN.equals((Object)entityExpr.getOperator()) || EntityOperator.GREATER_THAN_EQUAL_TO.equals((Object)entityExpr.getOperator()) || EntityOperator.LESS_THAN.equals((Object)entityExpr.getOperator()) || EntityOperator.LESS_THAN_EQUAL_TO.equals((Object)entityExpr.getOperator())) {
                    if (rhs != null && lhs != null && rhs instanceof Comparable) {
                        Comparable lhsComp = (Comparable)lhs;
                        Comparable rhsComp = (Comparable)rhs;
                        int comparison = lhsComp.compareTo(rhsComp);
                        if (comparison <= 0 && EntityOperator.LESS_THAN_EQUAL_TO.equals((Object)entityExpr.getOperator())) {
                            include = true;
                            continue;
                        }
                        if (comparison < 0 && EntityOperator.LESS_THAN.equals((Object)entityExpr.getOperator())) {
                            include = true;
                            continue;
                        }
                        if (comparison >= 0 && EntityOperator.GREATER_THAN_EQUAL_TO.equals((Object)entityExpr.getOperator())) {
                            include = true;
                            continue;
                        }
                        if (comparison > 0 && EntityOperator.GREATER_THAN.equals((Object)entityExpr.getOperator())) {
                            include = true;
                            continue;
                        }
                        include = false;
                        break;
                    }
                    throw new IllegalArgumentException("Operation " + entityExpr.getOperator().getCode() + " is not yet supported by filterByAnd with objects that do not implement Comparable");
                }
                throw new IllegalArgumentException("Operation " + entityExpr.getOperator().getCode() + " is not yet supported by filterByAnd");
            }
            if (!include) continue;
            result.add(value);
        }
        return result;
    }

    public static synchronized String getNextStringId(String entityName) throws GenericEntityException {
        long maxID = 1L;
        for (GenericValue entity : CoreFactory.getGenericDelegator().findAll(entityName)) {
            try {
                long entityId = Long.parseLong(entity.getString("id"));
                if (entityId < maxID) continue;
                maxID = entityId + 1L;
            }
            catch (NumberFormatException nfe) {}
        }
        return Long.toString(maxID);
    }
}

