/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow.function.event;

import com.atlassian.jira.event.issue.IssueEventDispatcher;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.FunctionProvider;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class FireIssueEventFunction
implements FunctionProvider {
    private static final Logger log = Logger.getLogger(FireIssueEventFunction.class);

    public void execute(Map transientVars, Map args, PropertySet ps) {
        Long eventTypeId = null;
        Object object = args.get("eventTypeId");
        if (object instanceof Long) {
            eventTypeId = (Long)args.get("eventTypeId");
        } else if (object instanceof String) {
            eventTypeId = new Long((String)object);
        }
        if (eventTypeId != null) {
            Issue updatedIssue = (Issue)transientVars.get("issue");
            Comment comment = (Comment)transientVars.get("commentValue");
            GenericValue changeGroup = (GenericValue)transientVars.get("changeGroup");
            HashMap<String, String> params = new HashMap<String, String>(4);
            params.put("eventsource", "workflow");
            boolean sendMail = true;
            if (transientVars.get("sendBulkNotification") != null) {
                sendMail = (Boolean)transientVars.get("sendBulkNotification");
            }
            ApplicationUser caller = WorkflowUtil.getCallerUser((Map)transientVars);
            IssueEventDispatcher.dispatchEvent(eventTypeId, updatedIssue, ApplicationUsers.toDirectoryUser((ApplicationUser)caller), comment, null, changeGroup, params, sendMail);
        }
    }

    public static FunctionDescriptor makeDescriptor(Long eventTypeId) {
        FunctionDescriptor descriptor = DescriptorFactory.getFactory().createFunctionDescriptor();
        descriptor.setType("class");
        descriptor.getArgs().put("class.name", FireIssueEventFunction.class.getName());
        descriptor.getArgs().put("eventTypeId", eventTypeId);
        return descriptor;
    }
}

