/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import java.io.UnsupportedEncodingException;

public class Ie6MimeSniffer {
    private final int maximumBytesToCheck;
    public static final int MAX_BYTES_TO_SNIFF = 256;
    private static final String IE_ENCODING = "UTF-8";
    static final byte[][] SMELLY_BYTES = Ie6MimeSniffer.encodeBytes(new String[]{"<html", "<head", "<body", "<script", "<table", "<img", "<plaintext", "<pre", "<title"}, "UTF-8");
    private static final byte ASCII_UPPERCASE_Z = 90;
    private static final byte ASCII_UPPERCASE_A = 65;
    private static final byte ASCII_LOWERCASE_A = 97;
    private static final int CASE_GROUP_OFFSET = 32;

    public Ie6MimeSniffer() {
        this(256);
    }

    public Ie6MimeSniffer(int maximumBytesToCheck) {
        if (maximumBytesToCheck < -1) {
            throw new IllegalArgumentException("looking for -1 or above for max bytes to check.");
        }
        this.maximumBytesToCheck = maximumBytesToCheck;
    }

    public boolean smellsLikeHtml(byte[] fileContents) {
        int length = fileContents.length;
        if (fileContents.length > this.maximumBytesToCheck && this.maximumBytesToCheck != -1) {
            length = this.maximumBytesToCheck;
        }
        byte[] copy = new byte[length];
        System.arraycopy(fileContents, 0, copy, 0, length);
        Ie6MimeSniffer.toLowerCaseAscii(copy);
        for (byte[] SMELLY_BYTE : SMELLY_BYTES) {
            if (!Ie6MimeSniffer.containsSubarray(copy, SMELLY_BYTE)) continue;
            return true;
        }
        return false;
    }

    static void toLowerCaseAscii(byte[] lowerCaseMe) {
        for (int i = 0; i < lowerCaseMe.length; ++i) {
            if (lowerCaseMe[i] > 90 || lowerCaseMe[i] < 65) continue;
            lowerCaseMe[i] = (byte)(lowerCaseMe[i] + 32);
        }
    }

    static boolean containsSubarray(byte[] superArray, byte[] subArray) {
        if (superArray.length < subArray.length) {
            return false;
        }
        int lastMatchableSuperIndex = superArray.length - subArray.length;
        for (int i = 0; i <= lastMatchableSuperIndex; ++i) {
            for (int j = 0; j < subArray.length && superArray[i + j] == subArray[j]; ++j) {
                if (j != subArray.length - 1) continue;
                return true;
            }
        }
        return false;
    }

    private static byte[][] encodeBytes(String[] smellyTags, String encoding) {
        try {
            byte[][] smellys = new byte[smellyTags.length][];
            for (int i = 0; i < smellyTags.length; ++i) {
                smellys[i] = smellyTags[i].getBytes(encoding);
            }
            return smellys;
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("UTF-8 is required", e);
        }
    }
}

