/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.sitemesh;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.plugin.profile.DarkFeatures;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.soy.SoyTemplateRendererProvider;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.ui.header.CurrentHeader;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminDecoratorHelper {
    public static final String SYSTEM_ADMIN_TOP_NAVIGATION_BAR = "system.admin.top.navigation.bar";
    public static final String SYSTEM_ADMIN_TOP = "system.admin.top";
    public static final String ACTIVE_SECTION_KEY = "admin.active.section";
    public static final String ACTIVE_TAB_LINK_KEY = "admin.active.tab";
    private static final Logger log = LoggerFactory.getLogger(AdminDecoratorHelper.class);
    private final WebInterfaceManager webInterfaceManager;
    private final ProjectService service;
    private final JiraAuthenticationContext authCtx;
    private final DarkFeatures darkFeatures;
    private final SimpleLinkManager linkManager;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final CurrentHeader currentHeader;
    private String projectKey;
    private String currentTab;
    private String currentSection;
    private String selectedMenuSection;
    private ProjectService.GetProjectResult result;
    private List<Header> headers;
    private String headerHtml;
    private Map<String, Object> sideMenuSoyRenderData;
    private LinkedList<PathSegment> pathToLink;

    public AdminDecoratorHelper(WebInterfaceManager webInterfaceManager, ProjectService projectService, JiraAuthenticationContext authenticationContext, FeatureManager featureManager, SimpleLinkManager linkManager, SoyTemplateRendererProvider soyTemplateRendererProvider, CurrentHeader currentHeader) {
        this.webInterfaceManager = webInterfaceManager;
        this.service = projectService;
        this.authCtx = authenticationContext;
        this.linkManager = linkManager;
        this.currentHeader = currentHeader;
        this.darkFeatures = featureManager.getDarkFeatures();
        this.soyTemplateRenderer = soyTemplateRendererProvider.getRenderer();
        this.sideMenuSoyRenderData = this.makeSideMenuSoyRenderData(null, null, SYSTEM_ADMIN_TOP, SYSTEM_ADMIN_TOP_NAVIGATION_BAR, null);
    }

    public boolean isNewHeader() {
        return true;
    }

    public boolean isAdminMenusAllHidden() {
        return this.getSelectedMenuSection() == null || this.getSelectedMenuSection().equals(SYSTEM_ADMIN_TOP_NAVIGATION_BAR);
    }

    public AdminDecoratorHelper setProject(String projectKey) {
        this.clearCache();
        this.projectKey = StringUtils.stripToNull((String)projectKey);
        return this;
    }

    public AdminDecoratorHelper setCurrentTab(String currentTab) {
        this.clearCache();
        this.currentTab = StringUtils.stripToNull((String)currentTab);
        this.sideMenuSoyRenderData = this.makeSideMenuSoyRenderData(null, null, SYSTEM_ADMIN_TOP, SYSTEM_ADMIN_TOP_NAVIGATION_BAR, null);
        return this;
    }

    public AdminDecoratorHelper setCurrentSection(String currentSection) {
        this.clearCache();
        this.currentSection = StringUtils.stripToNull((String)currentSection);
        this.selectedMenuSection = StringUtils.contains((String)currentSection, (String)"/") ? currentSection.substring(0, currentSection.indexOf("/")) : currentSection;
        if (StringUtils.equals((String)"atl.jira.proj.config", (String)this.selectedMenuSection)) {
            this.selectedMenuSection = this.currentHeader.get().equals((Object)CurrentHeader.Header.CLASSIC) ? "admin_project_menu" : "admin_project_current";
        }
        return this;
    }

    public String getSelectedMenuSection() {
        if (this.selectedMenuSection == null && this.pathToLink != null) {
            for (PathSegment pathSegment : this.pathToLink) {
                if (!SYSTEM_ADMIN_TOP_NAVIGATION_BAR.equals(pathSegment.getParentSectionId())) continue;
                this.selectedMenuSection = pathSegment.getSectionId();
            }
        }
        return this.selectedMenuSection;
    }

    public boolean hasKey() {
        return this.projectKey != null;
    }

    public List<Header> getHeaders() {
        String headerPanelSection;
        HashMap<String, Object> context;
        if (this.headers != null) {
            return this.headers;
        }
        Project project = this.getProject();
        if (project == null) {
            List<Map<String, Object>> adminNavigationSections = this.getSoyReadyAdminNavigationSections(SYSTEM_ADMIN_TOP_NAVIGATION_BAR);
            context = MapBuilder.build((Object)ACTIVE_SECTION_KEY, (Object)this.currentSection, (Object)ACTIVE_TAB_LINK_KEY, (Object)this.currentTab, (Object)"adminNavigationPrimary", adminNavigationSections);
            headerPanelSection = "system.admin.decorator.header";
        } else {
            List<Map<String, Object>> adminNavigationLinksPrimary = this.getSoyReadyNavigationLinksForSection("atj.jira.proj.nav.switcher", "project-navswitcher");
            List<Map<String, Object>> adminNavigationLinksSecondary = this.getSoyReadyNavigationLinksForSection("atj.jira.proj.nav.switcher", "project-navswitcher-secondary");
            context = new HashMap<String, Object>();
            context.put("project", project);
            context.put(ACTIVE_SECTION_KEY, this.currentSection);
            context.put(ACTIVE_TAB_LINK_KEY, this.currentTab);
            context.put("adminNavigationPrimary", adminNavigationLinksPrimary);
            context.put("adminNavigationSecondary", adminNavigationLinksSecondary);
            headerPanelSection = "atl.jira.proj.config.header";
        }
        List panels = this.webInterfaceManager.getDisplayableWebPanels(headerPanelSection, Collections.emptyMap());
        ArrayList<Header> headers = new ArrayList<Header>(panels.size());
        for (WebPanel panel : panels) {
            headers.add(new Header(panel, context));
        }
        this.headers = headers;
        return this.headers;
    }

    private List<Map<String, Object>> getSoyReadyNavigationLinksForSection(String parentSection, String section) {
        List<SimpleLink> projectAdminLinks = this.getLinksForSection(parentSection, section);
        ArrayList<Map<String, Object>> soyedMainLinkSections = new ArrayList<Map<String, Object>>();
        if (projectAdminLinks == null) {
            return soyedMainLinkSections;
        }
        for (SimpleLink currentLink : projectAdminLinks) {
            HashMap<String, Object> soyedSection = new HashMap<String, Object>();
            String id = currentLink.getId();
            soyedSection.put("id", id);
            soyedSection.put("link", currentLink.getUrl());
            soyedSection.put("label", currentLink.getLabel());
            soyedSection.put("isSelected", id.equalsIgnoreCase("project-admin-link"));
            if (StringUtils.isNotEmpty((String)currentLink.getStyleClass())) {
                soyedSection.put("styleClass", currentLink.getStyleClass());
            }
            soyedMainLinkSections.add(soyedSection);
        }
        return soyedMainLinkSections;
    }

    private List<Map<String, Object>> getSoyReadyAdminNavigationSections(String locationOfSections) {
        List<SimpleLinkSection> mainAdminSections = this.getChildSectionsForSection(locationOfSections);
        ArrayList<Map<String, Object>> soyedMainLinkSections = new ArrayList<Map<String, Object>>();
        if (mainAdminSections == null) {
            return soyedMainLinkSections;
        }
        for (SimpleLinkSection currentSection : mainAdminSections) {
            HashMap<String, Object> soyedSection = new HashMap<String, Object>();
            soyedSection.put("link", this.findFirstLinkForSection(currentSection, this.authCtx.getLoggedInUser(), this.getJiraHelper()).getUrl());
            soyedSection.put("label", currentSection.getLabel());
            soyedSection.put("isSelected", currentSection.getId().equalsIgnoreCase(this.getSelectedMenuSection()));
            soyedMainLinkSections.add(soyedSection);
        }
        return soyedMainLinkSections;
    }

    @Nullable
    private SimpleLink findFirstLinkForSection(@Nonnull SimpleLinkSection adminHeaderSection, @Nullable User user, @Nonnull JiraHelper helper) {
        List nonEmptySubSections = this.linkManager.getNotEmptySectionsForLocation(adminHeaderSection.getId(), user, helper);
        for (SimpleLinkSection subSection : nonEmptySubSections) {
            if ("atl.jira.proj.config".equals(subSection.getId())) continue;
            String subSectionKey = adminHeaderSection.getId() + "/" + subSection.getId();
            List links = this.linkManager.getLinksForSection(subSectionKey, user, helper);
            if (!links.isEmpty()) {
                return (SimpleLink)links.get(0);
            }
            SimpleLink firstLinkOfSubSection = this.findFirstLinkForSection(subSection, user, helper);
            if (firstLinkOfSubSection == null) continue;
            return firstLinkOfSubSection;
        }
        return null;
    }

    public String getHeaderHtml() {
        if (this.headerHtml != null) {
            return this.headerHtml;
        }
        StringBuilder builder = new StringBuilder();
        for (Header header : this.getHeaders()) {
            builder.append(header.getHtml());
        }
        this.headerHtml = StringUtils.trimToEmpty((String)builder.toString());
        return this.headerHtml;
    }

    public boolean isHasHeader() {
        return StringUtils.isNotEmpty((String)this.getHeaderHtml());
    }

    public String getPageBreadcrumbsHtml() {
        if (StringUtils.equals((String)"admin_project_current", (String)this.currentSection) || StringUtils.equals((String)"admin_summary", (String)this.currentTab)) {
            return null;
        }
        HashMap breadcrumbs = new HashMap();
        ArrayList breadcrumbLevels = new ArrayList();
        for (PathSegment pathSegment : this.pathToLink) {
            if (pathSegment.getName() == null) continue;
            HashMap<String, String> currentSegment = new HashMap<String, String>();
            currentSegment.put("name", pathSegment.getName());
            currentSegment.put("link", pathSegment.getLink());
            breadcrumbLevels.add(currentSegment);
        }
        breadcrumbs.put("breadcrumblevels", breadcrumbLevels);
        try {
            return this.soyTemplateRenderer.render("com.atlassian.jira.jira-header-plugin:admin-breadcrumbs", "JIRA.Templates.Menu.admin.breadcrumbs.breadcrumbtrail", breadcrumbs);
        }
        catch (SoyException e) {
            log.warn("Could not render soy template for breadcrumbs");
            log.debug("Exception: ", (Throwable)e);
            return null;
        }
    }

    public String getSideMenuHtml(String sectionId) {
        List<SimpleLinkSection> sections = this.getChildSectionsForSection(SYSTEM_ADMIN_TOP_NAVIGATION_BAR);
        SimpleLinkSection section = null;
        for (SimpleLinkSection simpleLinkSection : sections) {
            if (!simpleLinkSection.getId().equals(sectionId)) continue;
            section = simpleLinkSection;
            break;
        }
        if (section == null) {
            return null;
        }
        String menuLabel = null;
        Map currentSectionMenuData = null;
        if (!StringUtils.equals((String)"admin_project_current", (String)sectionId)) {
            String string = menuLabel = section.getTitle() != null ? section.getTitle() : section.getLabel();
            if (this.sideMenuSoyRenderData != null) {
                for (Map sectionMenuData : (List)this.sideMenuSoyRenderData.get("sections")) {
                    if (!sectionMenuData.get("sectionId").equals(sectionId)) continue;
                    currentSectionMenuData = sectionMenuData;
                    currentSectionMenuData.put("menuLabel", menuLabel);
                    currentSectionMenuData.remove("label");
                    break;
                }
            }
        } else {
            currentSectionMenuData = this.makeSideMenuSoyRenderData(null, null, SYSTEM_ADMIN_TOP_NAVIGATION_BAR, sectionId, null);
        }
        if (currentSectionMenuData == null) {
            return null;
        }
        try {
            return this.soyTemplateRenderer.render("com.atlassian.jira.jira-header-plugin:admin-side-nav-menu", "JIRA.Templates.Menu.admin.side.navigation.menusection", currentSectionMenuData);
        }
        catch (SoyException e) {
            log.warn("Could not render soy template for side admin menu");
            log.debug("Exception: ", (Throwable)e);
            return null;
        }
    }

    private Map<String, Object> makeSideMenuSoyRenderData(String title, String label, String parentSectionId, String sectionId, String sectionLabel) {
        if (!this.getSectionContainsAtleastOneLink(parentSectionId, sectionId)) {
            return null;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("title", title);
        data.put("label", label);
        data.put("menuLabel", sectionLabel);
        data.put("parentSectionId", parentSectionId);
        data.put("sectionId", sectionId);
        data.put("links", this.makeLinksForSection(parentSectionId, sectionId));
        data.put("sections", this.makeChildSectionsForSection(sectionId));
        data.put("selectedMenu", this.getSelectedMenuSection());
        return data;
    }

    private List<Map<String, Object>> makeChildSectionsForSection(String sectionId) {
        ArrayList<Map<String, Object>> sections = new ArrayList<Map<String, Object>>();
        for (SimpleLinkSection linkSection : this.getChildSectionsForSection(sectionId)) {
            Map<String, Object> section = this.makeSideMenuSoyRenderData(linkSection.getTitle(), linkSection.getLabel(), sectionId, linkSection.getId(), null);
            sections.add(section);
        }
        return sections;
    }

    private List<Map<String, Object>> makeLinksForSection(String parentSectionId, String sectionId) {
        ArrayList<Map<String, Object>> links = new ArrayList<Map<String, Object>>();
        for (SimpleLink simpleLink : this.getLinksForSection(parentSectionId, sectionId)) {
            HashMap<String, Object> link = new HashMap<String, Object>();
            link.put("url", simpleLink.getUrl());
            link.put("id", simpleLink.getId());
            link.put("label", simpleLink.getLabel());
            link.put("accessKey", simpleLink.getAccessKey());
            link.put("selected", this.isSelectedLink(simpleLink));
            links.add(link);
        }
        return links;
    }

    private boolean isSelectedLink(SimpleLink simpleLink) {
        boolean selected;
        boolean bl = selected = simpleLink.getId() != null && simpleLink.getId().equalsIgnoreCase(this.currentTab);
        if (!selected && StringUtils.isBlank((String)this.currentTab) && this.getHttpRequest().getRequestURI().endsWith(JiraUrl.extractActionFromURL((String)simpleLink.getUrl()))) {
            selected = true;
        }
        if (selected) {
            this.selectedMenuSection = this.findMenuSection(simpleLink);
            if (!StringUtils.isBlank((String)this.currentTab) && !this.getHttpRequest().getRequestURI().endsWith(JiraUrl.extractActionFromURL((String)simpleLink.getUrl()))) {
                PathSegment pathSegment = this.pathToLink.getLast();
                this.pathToLink.add(new PathSegment(pathSegment.getSectionId(), this.currentTab, simpleLink.getLabel(), simpleLink.getUrl(), true));
            }
        }
        return selected;
    }

    private String findMenuSection(SimpleLink simpleLink) {
        LinkedList<PathSegment> pathToLink = this.getPathToLink(simpleLink);
        for (PathSegment pathSegment : pathToLink) {
            if (!SYSTEM_ADMIN_TOP_NAVIGATION_BAR.equals(pathSegment.getParentSectionId())) continue;
            return pathSegment.getSectionId();
        }
        return null;
    }

    private Project getProject() {
        ProjectService.GetProjectResult projectResult = this.getProjectResult();
        if (projectResult != null && projectResult.isValid()) {
            return projectResult.getProject();
        }
        return null;
    }

    private ProjectService.GetProjectResult getProjectResult() {
        if (this.result == null && this.hasKey()) {
            this.result = this.service.getProjectByKeyForAction(this.authCtx.getLoggedInUser(), this.projectKey, ProjectAction.EDIT_PROJECT_CONFIG);
        }
        return this.result;
    }

    private void clearCache() {
        this.result = null;
        this.headers = null;
        this.headerHtml = null;
    }

    public HttpServletRequest getHttpRequest() {
        return ExecutingHttpRequest.get();
    }

    protected String encode(String string) {
        return JiraUrlCodec.encode((String)string, (boolean)true);
    }

    private JiraHelper getJiraHelper() {
        MapBuilder context = MapBuilder.newBuilder();
        context.add((Object)"project", (Object)this.getProject());
        if (this.getProject() != null) {
            context.add((Object)"projectKeyEncoded", (Object)this.encode(this.getProject().getKey()));
        }
        return new JiraHelper(this.getHttpRequest(), this.getProject(), context.toMap());
    }

    public List<SimpleLinkSection> getMainAdminSections() {
        return this.getChildSectionsForSection(SYSTEM_ADMIN_TOP_NAVIGATION_BAR);
    }

    public List<SimpleLinkSection> getChildSectionsForSection(String location) {
        return this.linkManager.getSectionsForLocation(location, this.authCtx.getLoggedInUser(), this.getJiraHelper());
    }

    public List<SimpleLink> getLinksForSection(String parentSection, String section) {
        if (parentSection.equals("atl.jira.proj.config") && this.getProject() == null) {
            return new ArrayList<SimpleLink>();
        }
        MapBuilder context = MapBuilder.newBuilder();
        context.add((Object)"project", (Object)this.getProject());
        if (this.getProject() != null) {
            context.add((Object)"projectKeyEncoded", (Object)this.encode(this.getProject().getKey()));
        }
        String sectionId = parentSection + "/" + section;
        return this.linkManager.getLinksForSection(sectionId, this.authCtx.getLoggedInUser(), this.getJiraHelper());
    }

    public boolean getSectionContainsAtleastOneLink(String parentSection, String section) {
        LinkedList<Pair> parentAndSectionList = new LinkedList<Pair>();
        parentAndSectionList.add(Pair.nicePairOf((Object)parentSection, (Object)section));
        while (!parentAndSectionList.isEmpty()) {
            List<SimpleLink> links;
            Pair currentPair = (Pair)parentAndSectionList.pop();
            List<SimpleLinkSection> sectionList = this.getChildSectionsForSection((String)currentPair.second());
            if (sectionList != null) {
                for (SimpleLinkSection aSectionList : sectionList) {
                    parentAndSectionList.addLast(Pair.of((Object)currentPair.second(), (Object)aSectionList.getId()));
                }
            }
            if ((links = this.getLinksForSection((String)currentPair.first(), (String)currentPair.second())) == null || links.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public LinkedList<PathSegment> getPathToLink(SimpleLink simpleLink) {
        if (this.pathToLink != null) {
            return this.pathToLink;
        }
        this.pathToLink = this.generatePathToLink(SYSTEM_ADMIN_TOP, simpleLink);
        return this.pathToLink;
    }

    private LinkedList<PathSegment> generatePathToLink(String section, SimpleLink simpleLink) {
        LinkedList potentiallPathsList = new LinkedList();
        LinkedList<PathSegment> sectionsList = new LinkedList<PathSegment>();
        sectionsList.add(new PathSegment(null, section, null, null, false));
        potentiallPathsList.add(sectionsList);
        while (!potentiallPathsList.isEmpty()) {
            LinkedList currentList = (LinkedList)potentiallPathsList.pop();
            PathSegment currentPathSegment = (PathSegment)currentList.getLast();
            for (SimpleLinkSection simpleLinkSection : this.getChildSectionsForSection(currentPathSegment.getSectionId())) {
                boolean found = false;
                LinkedList<PathSegment> currentPathSegmentList = new LinkedList<PathSegment>();
                currentPathSegmentList.addAll(currentList);
                SimpleLinkSection currentLinkSection = simpleLinkSection;
                String name = currentLinkSection.getTitle() != null ? currentLinkSection.getTitle() : currentLinkSection.getLabel();
                List<SimpleLink> linksForSection = this.getLinksForSection(currentPathSegment.getSectionId(), currentLinkSection.getId());
                String linkForSection = null;
                if (linksForSection != null && !linksForSection.isEmpty() && linksForSection.contains(simpleLink)) {
                    found = true;
                }
                currentPathSegmentList.addLast(new PathSegment(currentPathSegment.getSectionId(), currentLinkSection.getId(), name, linkForSection, linkForSection != null));
                if (found) {
                    return currentPathSegmentList;
                }
                potentiallPathsList.addLast(currentPathSegmentList);
            }
        }
        return null;
    }

    private class PathSegment {
        private final String parentSectionId;
        private final String sectionId;
        private final String name;
        private final String link;
        private final boolean hasLink;

        public PathSegment(String parentSectionId, String sectionId, String name, String link, boolean hasLink) {
            this.parentSectionId = parentSectionId;
            this.sectionId = sectionId;
            this.name = name;
            this.link = link;
            this.hasLink = hasLink;
        }

        public String getParentSectionId() {
            return this.parentSectionId;
        }

        public String getSectionId() {
            return this.sectionId;
        }

        public String getName() {
            return this.name;
        }

        public String getLink() {
            return this.link;
        }

        public boolean isHasLink() {
            return this.hasLink;
        }
    }

    public static class Header {
        private final Map<String, Object> contextMap;
        private final WebPanel panel;

        private Header(WebPanel panel, Map<String, Object> contextMap) {
            this.contextMap = contextMap;
            this.panel = panel;
        }

        public String getHtml() {
            return this.panel.getHtml(this.contextMap);
        }
    }
}

