/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet.rpc;

import com.atlassian.instrumentation.operations.OpTimer;
import com.atlassian.jira.action.ActionContextKit;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.instrumentation.Instrumentation;
import com.atlassian.jira.instrumentation.InstrumentationName;
import com.atlassian.jira.web.servlet.rpc.AxisServletProvider;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletResponse;

public class LazyAxisDecoratorServlet
extends HttpServlet {
    private ServletConfig config;

    public void init(ServletConfig config) {
        this.config = config;
        this.getAxisProvider().init(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        ApplicationProperties applicationProperties = this.getApplicationProperties();
        if (applicationProperties.getOption("jira.option.rpc.allow")) {
            if (applicationProperties.getString("jira.setup") != null) {
                OpTimer timer = Instrumentation.pullTimer(InstrumentationName.SOAP_REQUESTS);
                try {
                    ActionContextKit.resetContext();
                    this.getAxisProvider().init(this.config);
                    this.getAxisProvider().getAxisServlet().service(servletRequest, servletResponse);
                }
                finally {
                    ActionContextKit.resetContext();
                    timer.end();
                }
            } else {
                httpServletResponse.sendError(503, "JIRA has not been setup. Remote API is not available.");
            }
        } else {
            httpServletResponse.sendError(503, "Remote API not activated for this JIRA installation.");
        }
    }

    protected AxisServletProvider getAxisProvider() {
        return (AxisServletProvider)ComponentAccessor.getComponent(AxisServletProvider.class);
    }

    private ApplicationProperties getApplicationProperties() {
        return (ApplicationProperties)ComponentAccessor.getComponent(ApplicationProperties.class);
    }
}

