/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.component.jql;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.JiraDataType;
import com.atlassian.jira.issue.comparator.LocaleSensitiveStringComparator;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.NavigableField;
import com.atlassian.jira.issue.search.ClauseNames;
import com.atlassian.jira.issue.search.managers.SearchHandlerManager;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.jql.ClauseInformation;
import com.atlassian.jira.jql.NoOpClauseHandler;
import com.atlassian.jira.jql.ValueGeneratingClauseHandler;
import com.atlassian.jira.jql.operand.FunctionOperandHandler;
import com.atlassian.jira.jql.operand.registry.JqlFunctionHandlerRegistry;
import com.atlassian.jira.jql.util.JqlCustomFieldId;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operator.Operator;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class DefaultAutoCompleteJsonGenerator
implements AutoCompleteJsonGenerator {
    private final SearchHandlerManager searchHandlerManager;
    private final JqlStringSupport jqlStringSupport;
    private final FieldManager fieldManager;
    private final JqlFunctionHandlerRegistry jqlFunctionHandlerRegistry;

    public DefaultAutoCompleteJsonGenerator(SearchHandlerManager searchHandlerManager, JqlStringSupport jqlStringSupport, FieldManager fieldManager, JqlFunctionHandlerRegistry jqlFunctionHandlerRegistry) {
        this.searchHandlerManager = searchHandlerManager;
        this.jqlStringSupport = jqlStringSupport;
        this.fieldManager = fieldManager;
        this.jqlFunctionHandlerRegistry = jqlFunctionHandlerRegistry;
    }

    public String getVisibleFieldNamesJson(User user, Locale locale) throws JSONException {
        TreeMap<String, ClauseNameValue> visibleNames = new TreeMap<String, ClauseNameValue>(String.CASE_INSENSITIVE_ORDER);
        HashMap<String, HashSet<ClauseNameValue>> customFieldNameToClauseNames = new HashMap<String, HashSet<ClauseNameValue>>();
        Collection handlers = this.searchHandlerManager.getVisibleClauseHandlers(user);
        for (ClauseHandler clauseHandler : handlers) {
            boolean isSearchable;
            ClauseInformation information = clauseHandler.getInformation();
            ClauseNames visibleClauseName = information.getJqlClauseNames();
            String fieldId = information.getFieldId();
            Set supportedOperators = information.getSupportedOperators();
            JiraDataType supportedType = information.getDataType();
            Field field = this.fieldManager.getField(fieldId);
            boolean isAutoCompleteable = clauseHandler instanceof ValueGeneratingClauseHandler;
            boolean isOrderByable = field instanceof NavigableField;
            boolean bl = isSearchable = !(clauseHandler instanceof NoOpClauseHandler);
            if (this.isCustomFieldClauseNames(visibleClauseName) && field != null) {
                String name = field instanceof CustomField ? ((CustomField)field).getUntranslatedName() : field.getName();
                HashSet<ClauseNameValue> namesList = (HashSet<ClauseNameValue>)customFieldNameToClauseNames.get(name);
                if (namesList == null) {
                    namesList = new HashSet<ClauseNameValue>();
                    customFieldNameToClauseNames.put(name, namesList);
                }
                namesList.add(new ClauseNameValue(visibleClauseName.getPrimaryName(), isAutoCompleteable, isOrderByable, isSearchable, visibleClauseName.getJqlFieldNames().size() == 1, supportedOperators, supportedType));
                for (String s : visibleClauseName.getJqlFieldNames()) {
                    if (JqlCustomFieldId.isJqlCustomFieldId((String)s) || s.equalsIgnoreCase(name)) continue;
                    HashSet<ClauseNameValue> clauseNamesList = (HashSet<ClauseNameValue>)customFieldNameToClauseNames.get(name);
                    if (clauseNamesList == null) {
                        clauseNamesList = new HashSet<ClauseNameValue>();
                        customFieldNameToClauseNames.put(s, clauseNamesList);
                    }
                    clauseNamesList.add(new ClauseNameValue(visibleClauseName.getPrimaryName(), isAutoCompleteable, isOrderByable, isSearchable, visibleClauseName.getJqlFieldNames().size() == 1, supportedOperators, supportedType));
                }
                continue;
            }
            for (String clauseName : visibleClauseName.getJqlFieldNames()) {
                visibleNames.put(clauseName, new ClauseNameValue(clauseName, isAutoCompleteable, isOrderByable, isSearchable, false, supportedOperators, supportedType));
            }
        }
        for (Map.Entry entry : customFieldNameToClauseNames.entrySet()) {
            String customFieldName = (String)entry.getKey();
            Set clauseNameValues = (Set)entry.getValue();
            if (clauseNameValues.size() == 1) {
                ClauseNameValue cfClauseValue = (ClauseNameValue)clauseNameValues.iterator().next();
                String displayName = customFieldName + " - " + cfClauseValue.getClauseNameValue();
                if (!visibleNames.containsKey(customFieldName) && !cfClauseValue.isMustUseNameValue()) {
                    visibleNames.put(displayName, new ClauseNameValue(customFieldName, cfClauseValue.getClauseNameValue(), cfClauseValue.isAutoCompleteable(), cfClauseValue.isOrderByable(), cfClauseValue.isSearchable(), cfClauseValue.isMustUseNameValue(), cfClauseValue.getSupportedOperators(), cfClauseValue.getSupportedType()));
                    continue;
                }
                visibleNames.put(displayName, cfClauseValue);
                continue;
            }
            for (ClauseNameValue cfClauseValue : clauseNameValues) {
                String displayName = customFieldName + " - " + cfClauseValue.getClauseNameValue();
                visibleNames.put(displayName, cfClauseValue);
            }
        }
        ArrayList visibleNamesList = new ArrayList(visibleNames.keySet());
        Collections.sort(visibleNamesList, new LocaleSensitiveStringComparator(locale));
        JSONArray jSONArray = new JSONArray();
        for (String fieldName : visibleNamesList) {
            JSONObject jsonObj = new JSONObject();
            ClauseNameValue clauseNameValue = (ClauseNameValue)visibleNames.get(fieldName);
            jsonObj.put("value", (Object)this.jqlStringSupport.encodeFieldName(clauseNameValue.getClauseNameValue()));
            jsonObj.put("displayName", (Object)this.htmlEncode(fieldName));
            if (clauseNameValue.isAutoCompleteable()) {
                jsonObj.put("auto", (Object)"true");
            }
            if (clauseNameValue.isOrderByable()) {
                jsonObj.put("orderable", (Object)"true");
            }
            if (clauseNameValue.isSearchable()) {
                jsonObj.put("searchable", (Object)"true");
            }
            if (clauseNameValue.getCustomFieldIdClauseName() != null) {
                jsonObj.put("cfid", (Object)clauseNameValue.getCustomFieldIdClauseName());
            }
            JSONArray supOpers = new JSONArray();
            for (Operator operator : clauseNameValue.getSupportedOperators()) {
                supOpers.put((Object)operator.getDisplayString());
            }
            jsonObj.put("operators", (Object)supOpers);
            JSONArray supportedTypes = new JSONArray();
            for (String typeString : clauseNameValue.getSupportedType().asStrings()) {
                supportedTypes.put((Object)typeString);
            }
            jsonObj.put("types", (Object)supportedTypes);
            jSONArray.put((Object)jsonObj);
        }
        return jSONArray.toString();
    }

    public String getVisibleFunctionNamesJson(User user, Locale locale) throws JSONException {
        List<String> functionNames = this.jqlFunctionHandlerRegistry.getAllFunctionNames();
        Collections.sort(functionNames, new LocaleSensitiveStringComparator(locale));
        JSONArray results = new JSONArray();
        for (String functionName : functionNames) {
            if ("currentUser".equals(functionName) && user == null) continue;
            FunctionOperandHandler functionHandler = this.jqlFunctionHandlerRegistry.getOperandHandler(new FunctionOperand(functionName));
            JSONObject jsonObj = new JSONObject();
            int minArguments = functionHandler.getJqlFunction().getMinimumNumberOfExpectedArguments();
            StringBuilder argPart = new StringBuilder("(");
            for (int i = 0; i < minArguments; ++i) {
                if (i != 0) {
                    argPart.append(", ");
                }
                argPart.append("\"\"");
            }
            argPart.append(")");
            jsonObj.put("value", (Object)(this.jqlStringSupport.encodeFunctionName(functionName) + argPart.toString()));
            jsonObj.put("displayName", (Object)(this.htmlEncode(functionName) + argPart.toString()));
            if (functionHandler.isList()) {
                jsonObj.put("isList", (Object)"true");
            }
            JSONArray functionTypes = new JSONArray();
            for (String typeString : functionHandler.getJqlFunction().getDataType().asStrings()) {
                functionTypes.put((Object)typeString);
            }
            jsonObj.put("types", (Object)functionTypes);
            results.put((Object)jsonObj);
        }
        return results.toString();
    }

    public String getJqlReservedWordsJson() throws JSONException {
        Set reservedWords = this.jqlStringSupport.getJqlReservedWords();
        JSONArray results = new JSONArray();
        for (String reservedWord : reservedWords) {
            results.put((Object)reservedWord);
        }
        return results.toString();
    }

    String htmlEncode(String string) {
        return TextUtils.htmlEncode((String)string);
    }

    private boolean isCustomFieldClauseNames(ClauseNames clauseNames) {
        for (String clauseName : clauseNames.getJqlFieldNames()) {
            if (!JqlCustomFieldId.isJqlCustomFieldId((String)clauseName)) continue;
            return true;
        }
        return false;
    }

    private static class ClauseNameValue {
        private final String clauseNameValue;
        private final String customFieldIdClauseName;
        private final boolean autoCompleteable;
        private final boolean orderByable;
        private final boolean searchable;
        private final boolean mustUseNameValue;
        private final Set<Operator> supportedOperators;
        private final JiraDataType supportedType;

        private ClauseNameValue(String clauseNameValue, boolean isAutoCompleteable, boolean isOrderByable, boolean isSearchable, boolean mustUseNameValue, Set<Operator> supportedOperators, JiraDataType supportedType) {
            this.clauseNameValue = clauseNameValue;
            this.autoCompleteable = isAutoCompleteable;
            this.orderByable = isOrderByable;
            this.searchable = isSearchable;
            this.mustUseNameValue = mustUseNameValue;
            this.supportedOperators = supportedOperators;
            this.supportedType = supportedType;
            this.customFieldIdClauseName = null;
        }

        private ClauseNameValue(String clauseNameValue, String customFieldIdClauseName, boolean isAutoCompleteable, boolean isOrderByable, boolean isSearchable, boolean mustUseNameValue, Set<Operator> supportedOperators, JiraDataType supportedType) {
            this.clauseNameValue = clauseNameValue;
            this.customFieldIdClauseName = customFieldIdClauseName;
            this.autoCompleteable = isAutoCompleteable;
            this.orderByable = isOrderByable;
            this.searchable = isSearchable;
            this.mustUseNameValue = mustUseNameValue;
            this.supportedOperators = supportedOperators;
            this.supportedType = supportedType;
        }

        public String getClauseNameValue() {
            return this.clauseNameValue;
        }

        public String getCustomFieldIdClauseName() {
            return this.customFieldIdClauseName;
        }

        public boolean isAutoCompleteable() {
            return this.autoCompleteable;
        }

        public boolean isOrderByable() {
            return this.orderByable;
        }

        public boolean isMustUseNameValue() {
            return this.mustUseNameValue;
        }

        public boolean isSearchable() {
            return this.searchable;
        }

        public Set<Operator> getSupportedOperators() {
            return this.supportedOperators;
        }

        public JiraDataType getSupportedType() {
            return this.supportedType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClauseNameValue that = (ClauseNameValue)o;
            if (this.autoCompleteable != that.autoCompleteable) {
                return false;
            }
            if (this.mustUseNameValue != that.mustUseNameValue) {
                return false;
            }
            if (this.orderByable != that.orderByable) {
                return false;
            }
            if (this.searchable != that.searchable) {
                return false;
            }
            if (this.clauseNameValue != null ? !this.clauseNameValue.equals(that.clauseNameValue) : that.clauseNameValue != null) {
                return false;
            }
            if (this.customFieldIdClauseName != null ? !this.customFieldIdClauseName.equals(that.customFieldIdClauseName) : that.customFieldIdClauseName != null) {
                return false;
            }
            if (this.supportedOperators != null ? !((Object)this.supportedOperators).equals(that.supportedOperators) : that.supportedOperators != null) {
                return false;
            }
            return !(this.supportedType != null ? !this.supportedType.equals(that.supportedType) : that.supportedType != null);
        }

        public int hashCode() {
            int result = this.clauseNameValue != null ? this.clauseNameValue.hashCode() : 0;
            result = 31 * result + (this.customFieldIdClauseName != null ? this.customFieldIdClauseName.hashCode() : 0);
            result = 31 * result + (this.autoCompleteable ? 1 : 0);
            result = 31 * result + (this.orderByable ? 1 : 0);
            result = 31 * result + (this.searchable ? 1 : 0);
            result = 31 * result + (this.mustUseNameValue ? 1 : 0);
            result = 31 * result + (this.supportedOperators != null ? ((Object)this.supportedOperators).hashCode() : 0);
            result = 31 * result + (this.supportedType != null ? this.supportedType.hashCode() : 0);
            return result;
        }
    }
}

