/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.bean;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;

public class PermissionCheckBean {
    private JiraAuthenticationContext authenticationContext;
    private PermissionManager permissionManager;

    public PermissionCheckBean(JiraAuthenticationContext authContext, PermissionManager permissionManager) {
        if (authContext == null) {
            throw new IllegalArgumentException("JiraAuthenticationContext must not be null");
        }
        if (permissionManager == null) {
            throw new IllegalArgumentException("PermissionManager must not be null");
        }
        this.authenticationContext = authContext;
        this.permissionManager = permissionManager;
    }

    public PermissionCheckBean() {
        this(ComponentAccessor.getJiraAuthenticationContext(), ComponentAccessor.getPermissionManager());
    }

    public boolean isIssueVisible(Issue issue) {
        if (issue == null) {
            throw new IllegalArgumentException("The issue must not be null!");
        }
        return this.permissionManager.hasPermission(10, issue, this.authenticationContext.getLoggedInUser());
    }

    public boolean isAdmin() {
        return this.permissionManager.hasPermission(0, this.authenticationContext.getLoggedInUser());
    }
}

