/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.user;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.plugin.user.WebErrorMessage;
import com.atlassian.jira.servlet.JiraCaptchaService;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.octo.captcha.service.CaptchaServiceException;
import java.util.List;
import javax.servlet.http.HttpSession;
import webwork.action.ActionContext;

public class Signup
extends JiraWebActionSupport {
    private String fullname;
    private String username;
    private String email;
    private String password;
    private String confirm;
    private String captcha;
    private final ApplicationProperties applicationProperties;
    private final UserService userService;
    private final UserUtil userUtil;
    private final ExternalLinkUtil externalLinkUtil;
    private final JiraCaptchaService jiraCaptchaService;
    private UserService.CreateUserValidationResult result;
    private List<WebErrorMessage> passwordErrors;

    public Signup(ApplicationProperties applicationProperties, UserService userService, UserUtil userUtil, JiraCaptchaService jiraCaptchaService, ExternalLinkUtil externalLinkUtil) {
        this.applicationProperties = applicationProperties;
        this.userService = userService;
        this.userUtil = userUtil;
        this.jiraCaptchaService = jiraCaptchaService;
        this.externalLinkUtil = externalLinkUtil;
    }

    public String doDefault() throws Exception {
        if (!JiraUtils.isPublicMode()) {
            return "modebreach";
        }
        if (this.getLoggedInUser() != null) {
            return "alreadyloggedin";
        }
        if (!this.userUtil.canActivateNumberOfUsers(1)) {
            return "limitexceeded";
        }
        return super.doDefault();
    }

    protected void doValidation() {
        if (!JiraUtils.isPublicMode()) {
            return;
        }
        if (this.getLoggedInUser() != null) {
            return;
        }
        if (!this.userUtil.canActivateNumberOfUsers(1)) {
            return;
        }
        this.validateCaptcha();
        this.result = this.userService.validateCreateUserForSignup(this.getLoggedInUser(), this.getUsername(), this.getPassword(), this.getConfirm(), this.getEmail(), this.getFullname());
        if (!this.result.isValid()) {
            this.addErrorCollection(this.result.getErrorCollection());
        }
        this.passwordErrors = this.result.getPasswordErrors();
    }

    protected String doExecute() throws Exception {
        if (!JiraUtils.isPublicMode()) {
            return "modebreach";
        }
        if (this.getLoggedInUser() != null) {
            return "alreadyloggedin";
        }
        if (!this.userUtil.canActivateNumberOfUsers(1)) {
            return "limitexceeded";
        }
        try {
            User user = this.userService.createUserFromSignup(this.result);
            if (user == null) {
                this.addErrorMessage(this.getText("signup.error.duplicateuser"));
            }
        }
        catch (CreateException e) {
            this.log.error((Object)"Error creating user from public sign up", (Throwable)e);
            return "systemerror";
        }
        return this.getResult();
    }

    public ExternalLinkUtil getExternalLinkUtils() {
        return this.externalLinkUtil;
    }

    private void validateCaptcha() {
        if (!this.applicationProperties.getOption("jira.option.captcha.on.signup")) {
            return;
        }
        HttpSession session = ActionContext.getRequest().getSession(false);
        if (session == null) {
            this.addErrorMessage(this.getText("session.timeout.message.title"));
            return;
        }
        String captchaId = session.getId();
        Boolean isResponseCorrect = null;
        try {
            isResponseCorrect = this.jiraCaptchaService.getImageCaptchaService().validateResponseForID(captchaId, (Object)this.captcha);
        }
        catch (CaptchaServiceException e) {
            this.addErrorMessage(this.getText("session.timeout.message.title"));
        }
        if (isResponseCorrect != null && !isResponseCorrect.booleanValue()) {
            this.addError("captcha", this.getText("signup.error.captcha.incorrect"));
        }
    }

    public String getFullname() {
        return this.fullname;
    }

    public void setFullname(String fullname) {
        this.fullname = fullname;
    }

    public String getUsername() {
        if (this.username != null) {
            return this.username.trim();
        }
        return null;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public List<WebErrorMessage> getPasswordErrors() {
        return this.passwordErrors;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getConfirm() {
        return this.confirm;
    }

    public void setConfirm(String confirm) {
        this.confirm = confirm;
    }

    public void setCaptcha(String captcha) {
        this.captcha = captcha;
    }
}

