/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.setup;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.web.action.setup.IndexLanguageToLocaleMapper;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class IndexLanguageToLocaleMapperImpl
implements IndexLanguageToLocaleMapper {
    private static final Logger log = Logger.getLogger(IndexLanguageToLocaleMapperImpl.class);
    private final Properties mappings = new Properties();

    public IndexLanguageToLocaleMapperImpl() {
        try {
            this.mappings.load(ClassLoaderUtils.getResourceAsStream((String)"index-language-map.properties", IndexLanguageToLocaleMapperImpl.class));
        }
        catch (IOException e) {
            log.warn((Object)"Unable to load the index-language-map.properties file");
        }
    }

    @Override
    public String getLanguageForLocale(String locale) {
        if (locale != null && this.mappings.containsKey(locale)) {
            return this.mappings.getProperty(locale);
        }
        return "english-moderate-stemming";
    }
}

