/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.project;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentService;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.project.ViewProject;
import com.opensymphony.util.TextUtils;

public class AddComponent
extends ViewProject {
    String name;
    private String componentLead;
    private String description;
    private final ProjectComponentService projectComponentService;
    private static final String SECURITY_BREACH = "securitybreach";

    public AddComponent(ProjectComponentService projectComponentService) {
        this.projectComponentService = projectComponentService;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String doDefault() throws Exception {
        if (this.hasProjectAdminPermission() || this.hasAdminPermission()) {
            return "input";
        }
        return SECURITY_BREACH;
    }

    @Override
    protected void doValidation() {
        try {
            this.getProject();
            if (this.project == null) {
                this.addErrorMessage(this.getText("admin.errors.project.no.project.with.id"));
            }
        }
        catch (Exception e) {
            this.addErrorMessage(this.getText("admin.errors.project.no.project.with.id"));
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        Long projectId = this.getProject().getLong("id");
        ProjectComponent projectComponent = this.projectComponentService.create(this.getLoggedInUser(), (ErrorCollection)this, this.getName(), this.getDescription(), this.getComponentLeadUserKey(), projectId);
        if (this.hasAnyErrors()) {
            if (this.getErrorMessages() != null && !this.getErrorMessages().isEmpty() && this.getErrorMessages().contains("admin.projects.component.usernopermission")) {
                return SECURITY_BREACH;
            }
            return "error";
        }
        return this.getRedirect("/plugins/servlet/project-config/" + this.getProjectObject().getKey() + "/summary");
    }

    private String getComponentLeadUserKey() {
        ApplicationUser leadUserObj = this.getLeadUserObj();
        if (leadUserObj == null) {
            return null;
        }
        return leadUserObj.getKey();
    }

    private ApplicationUser getLeadUserObj() {
        return this.getUserManager().getUserByName(this.getComponentLead());
    }

    public String getComponentLead() {
        return this.componentLead;
    }

    public void setComponentLead(String componentLead) {
        this.componentLead = TextUtils.stringSet((String)componentLead) ? componentLead : null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = TextUtils.stringSet((String)description) ? description : null;
    }
}

