/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.jira.bc.issue.vote.VoteService;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.exception.IssuePermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.issue.AbstractIssueSelectAction;

public class VoteOrWatchIssue
extends AbstractIssueSelectAction {
    private final VoteService voteService;
    private final WatcherManager watcherManager;
    private String watch;
    private String vote;

    public VoteOrWatchIssue(VoteService voteService, WatcherManager watcherManager) {
        this.voteService = voteService;
        this.watcherManager = watcherManager;
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        try {
            if (this.getLoggedInUser() == null) {
                return "permissionviolation";
            }
            if ("vote".equalsIgnoreCase(this.vote)) {
                VoteService.VoteValidationResult validationResult = this.voteService.validateAddVote(this.getLoggedInUser(), this.getLoggedInUser(), (Issue)this.getIssueObject());
                if (validationResult.isValid()) {
                    this.voteService.addVote(this.getLoggedInUser(), validationResult);
                } else {
                    this.addErrorCollection(validationResult.getErrorCollection());
                }
            } else if ("unvote".equalsIgnoreCase(this.vote)) {
                VoteService.VoteValidationResult validationResult = this.voteService.validateRemoveVote(this.getLoggedInUser(), this.getLoggedInUser(), (Issue)this.getIssueObject());
                if (validationResult.isValid()) {
                    this.voteService.removeVote(this.getLoggedInUser(), validationResult);
                } else {
                    this.addErrorCollection(validationResult.getErrorCollection());
                }
            }
            if ("watch".equalsIgnoreCase(this.watch)) {
                this.watcherManager.startWatching(this.getLoggedInUser(), this.getIssue());
            } else if ("unwatch".equalsIgnoreCase(this.watch)) {
                this.watcherManager.stopWatching(this.getLoggedInUser(), this.getIssue());
            }
            return this.returnComplete("/browse/" + this.getIssueObject().getKey());
        }
        catch (IssueNotFoundException ex) {
            this.addErrorMessage(this.getText("admin.errors.issues.issue.does.not.exist"));
            return "issuenotfound";
        }
        catch (IssuePermissionException ex) {
            this.addErrorMessage(this.getText("admin.errors.issues.no.browse.permission"));
            return "permissionviolation";
        }
    }

    public String getVote() {
        return this.vote;
    }

    public String getWatch() {
        return this.watch;
    }

    public void setVote(String vote) {
        this.vote = vote;
    }

    public void setWatch(String watch) {
        this.watch = watch;
    }
}

