/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.issue;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.exception.IssueNotFoundException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.web.action.issue.UpdateFieldsHelperBean;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class UpdateFieldsHelperBeanImpl
implements UpdateFieldsHelperBean {
    private static final Logger log = Logger.getLogger(UpdateFieldsHelperBeanImpl.class);
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;
    private FieldScreenRendererFactory fieldScreenRendererFactory;

    public UpdateFieldsHelperBeanImpl(PermissionManager permissionManager, JiraAuthenticationContext authenticationContext, FieldScreenRendererFactory fieldScreenRendererFactory) {
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
    }

    public boolean isEditable(Issue issue) {
        if (issue == null) {
            throw new IssueNotFoundException("Issue unexpectedly null");
        }
        boolean hasPermission = this.permissionManager.hasPermission(12, issue, this.authenticationContext.getLoggedInUser());
        if (hasPermission) {
            return issue.isEditable();
        }
        return false;
    }

    @Override
    public List getFieldsForEdit(User user, Issue issueObject) {
        ArrayList<OrderableField> fields = new ArrayList<OrderableField>();
        FieldScreenRenderer fieldScreenRenderer = this.getFieldScreenRenderer(user, issueObject);
        for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderer.getFieldScreenRenderTabs()) {
            for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItems()) {
                if (!fieldScreenRenderLayoutItem.isShow(issueObject)) continue;
                fields.add(fieldScreenRenderLayoutItem.getOrderableField());
            }
        }
        return fields;
    }

    @Override
    public boolean isFieldValidForEdit(User user, String fieldId, Issue issueObject) {
        if (fieldId != null) {
            FieldScreenRenderer fieldScreenRenderer = this.getFieldScreenRenderer(user, issueObject);
            for (FieldScreenRenderTab fieldScreenRenderTab : fieldScreenRenderer.getFieldScreenRenderTabs()) {
                for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItems()) {
                    if (!fieldScreenRenderLayoutItem.isShow(issueObject) || !fieldId.equals(fieldScreenRenderLayoutItem.getOrderableField().getId())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private FieldScreenRenderer getFieldScreenRenderer(User user, Issue issueObject) {
        return this.fieldScreenRendererFactory.getFieldScreenRenderer(user, issueObject, (IssueOperation)IssueOperations.EDIT_ISSUE_OPERATION, false);
    }
}

