/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.browser;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanel;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webresource.SuperBatchFilteringWriter;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.project.browse.BrowseProjectContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.json.JSONEscaper;
import com.atlassian.jira.web.action.AbstractPluggableTabPanelAction;
import com.atlassian.jira.web.action.util.PopularIssueTypesUtil;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import webwork.action.ServletActionContext;

public class BrowseProject
extends AbstractPluggableTabPanelAction<ProjectTabPanelModuleDescriptor> {
    private final WebResourceManager webResourceManager;
    private final PopularIssueTypesUtil popularIssueTypesUtil;
    private final UserProjectHistoryManager projectHistoryManager;
    private final SimpleLinkManager simpleLinkManager;
    private boolean contentOnly = false;
    private boolean asJson = false;
    private Long projectId;
    private boolean noTitle = false;
    private static final String NO_TITLE = "noTitle";
    private PopularIssueTypesUtil.PopularIssueTypesHolder issueTypesHolder;
    private boolean stateUpdateOnly = false;
    private static final String STATEUPDATE = "stateupdate";
    private static final String CONTENTONLY = "contentonly";
    private static final String JSON_CONTENT = "json";

    public BrowseProject(ProjectManager projectManager, PermissionManager permissionManager, PluginAccessor pluginAccessor, WebResourceManager webResourceManager, PopularIssueTypesUtil popularIssueTypesUtil, UserProjectHistoryManager projectHistoryManager, SimpleLinkManager simpleLinkManager) {
        super(pluginAccessor);
        super.setPersistenceKey("jira.browse.projects.current.tab");
        this.webResourceManager = webResourceManager;
        this.popularIssueTypesUtil = popularIssueTypesUtil;
        this.projectHistoryManager = projectHistoryManager;
        this.simpleLinkManager = simpleLinkManager;
    }

    public Long getId() {
        return this.projectId;
    }

    public void setId(Long id) {
        this.projectId = id;
        this.setSelectedProjectId(id);
    }

    public void setStateUpdateOnly(boolean stateUpdateOnly) {
        this.stateUpdateOnly = stateUpdateOnly;
    }

    public boolean isStateUpdateOnly() {
        return this.stateUpdateOnly;
    }

    public Project getProject() {
        return this.projectHistoryManager.getCurrentProject(10, this.getLoggedInUser());
    }

    public boolean isHasProjectAdminPermission() {
        return this.getPermissionManager().hasPermission(23, this.getProject(), this.getLoggedInApplicationUser());
    }

    public String doExecute() throws Exception {
        this.parseAcceptsHeader();
        try {
            Collection projects;
            Project newProject;
            Project project = this.getProject();
            if (this.projectId != null && (newProject = this.projectManager.getProjectObj(this.projectId)) != null && !newProject.equals(project)) {
                this.log.info((Object)"Specified project id to browse, but it is diff to current project.  Most prob a permission violation (or it doesn't exist)");
                return "permissionviolation";
            }
            if (project == null && (projects = this.getBrowsableProjects()).size() == 1) {
                Project onlyProject = (Project)projects.iterator().next();
                this.setSelectedProject(onlyProject);
            }
            if (this.getProject() == null) {
                return this.getRedirect("/secure/BrowseProjects.jspa");
            }
            if (!this.contentOnly) {
                this.webResourceManager.requireResource("jira.webresources:ajaxhistory");
                this.webResourceManager.requireResource("jira.webresources:browseproject");
            }
            if (this.stateUpdateOnly) {
                return STATEUPDATE;
            }
            if (this.contentOnly) {
                return this.asJson ? JSON_CONTENT : CONTENTONLY;
            }
        }
        catch (IllegalStateException e) {
            this.log.info((Object)"Permissions Exception whilst browsing project", (Throwable)e);
            return "permissionviolation";
        }
        return "success";
    }

    private void parseAcceptsHeader() {
        String accepts = StringUtils.defaultString((String)this.request.getHeader("Accept")).toLowerCase();
        if (accepts.contains("application/json")) {
            this.asJson = true;
        }
    }

    public boolean hasCreateIssuePermissionForProject() {
        return this.getPermissionManager().hasPermission(11, this.getProject(), this.getLoggedInApplicationUser());
    }

    public List<ProjectTabPanelModuleDescriptor> getProjectTabPanels() {
        return this.getTabPanels();
    }

    public String getTabHtmlForJSON() throws IOException {
        String tabPanelHTML = this.getTabHtml();
        return JSONEscaper.escape((String)tabPanelHTML);
    }

    public String getTabHtml() throws IOException {
        ProjectTabPanelModuleDescriptor tabPanelDescriptor = (ProjectTabPanelModuleDescriptor)this.getSelectedTabPanel();
        if (tabPanelDescriptor == null) {
            this.log.warn((Object)("Unknown tab panel '" + this.getSelectedTab() + "' has been specified."));
            return "";
        }
        ProjectTabPanel panel = (ProjectTabPanel)tabPanelDescriptor.getModule();
        if (panel.showPanel(this.getBrowseContext())) {
            boolean descriptorNoTitle;
            String tabHtml = panel.getHtml(this.getBrowseContext());
            StringBuilder strBuilder = new StringBuilder();
            if (this.isContentOnly()) {
                SuperBatchFilteringWriter writer = new SuperBatchFilteringWriter();
                this.webResourceManager.includeResources((Writer)writer, UrlMode.AUTO);
                strBuilder.append(writer.toString());
            }
            boolean bl = descriptorNoTitle = tabPanelDescriptor.getParams().containsKey(NO_TITLE) && "true".equalsIgnoreCase((String)tabPanelDescriptor.getParams().get(NO_TITLE));
            if (!this.isNoTitle() && !descriptorNoTitle) {
                strBuilder.append(this.getPageHeaderHtml());
            }
            strBuilder.append(tabHtml);
            return strBuilder.toString();
        }
        this.log.warn((Object)"Tab panel should be hidden.");
        return "";
    }

    @HtmlSafe
    public String getTabLabel() {
        ProjectTabPanelModuleDescriptor tabPanel = (ProjectTabPanelModuleDescriptor)this.getSelectedTabPanel();
        if (tabPanel == null) {
            this.log.warn((Object)"Either unknown tab specified or no tab specfied and no tabs in system");
            return "";
        }
        return tabPanel.getLabel();
    }

    public void setContentOnly(boolean contentOnly) {
        this.contentOnly = contentOnly;
    }

    public boolean isContentOnly() {
        return this.contentOnly;
    }

    public boolean isNoTitle() {
        return this.noTitle;
    }

    public void setNoTitle(boolean noTitle) {
        this.noTitle = noTitle;
    }

    private PopularIssueTypesUtil.PopularIssueTypesHolder getIssueTypesHolder() {
        if (this.issueTypesHolder == null) {
            this.issueTypesHolder = this.popularIssueTypesUtil.getPopularAndOtherIssueTypesForProject(this.getProject(), this.getLoggedInUser());
        }
        return this.issueTypesHolder;
    }

    public Collection<IssueType> getPopularIssueTypes() {
        return this.getIssueTypesHolder().getPopularIssueTypes();
    }

    public Collection<IssueType> getOtherIssueTypes() {
        return this.getIssueTypesHolder().getOtherIssueTypes();
    }

    @Override
    protected List<ProjectTabPanelModuleDescriptor> getTabPanelModuleDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(ProjectTabPanelModuleDescriptor.class);
    }

    @Override
    protected boolean isTabPanelHidden(ProjectTabPanelModuleDescriptor descriptor) throws PermissionException {
        return !((ProjectTabPanel)descriptor.getModule()).showPanel(this.getBrowseContext());
    }

    private BrowseContext getBrowseContext() {
        return new BrowseProjectContext(this.getLoggedInUser(), this.getProject());
    }

    public Collection<SimpleLink> getOperationLinks() {
        return this.simpleLinkManager.getLinksForSection("system.browse.project.operations", this.getLoggedInUser(), this.getJiraHelper());
    }

    private JiraHelper getJiraHelper() {
        HashMap<String, String> params = new HashMap<String, String>();
        Project project = this.getSelectedProjectObject();
        String projectKey = project == null ? "" : project.getKey();
        params.put("projectKey", projectKey);
        params.put("projectKeyEncoded", JiraUrlCodec.encode((String)projectKey, (boolean)true));
        return new JiraHelper(ServletActionContext.getRequest(), project, params);
    }

    public boolean isLeadExists() {
        return UserUtils.userExists((String)this.getProject().getLeadUserName());
    }

    protected FeatureManager getFeatureManager() {
        return (FeatureManager)ComponentAccessor.getComponentOfType(FeatureManager.class);
    }

    protected SoyTemplateRenderer getSoyRenderer() {
        return (SoyTemplateRenderer)ComponentAccessor.getOSGiComponentInstanceOfType(SoyTemplateRenderer.class);
    }

    public List<Map<String, Object>> getAdminNavLinks() {
        return this.getSoyListOfLinksForSection("atj.jira.proj.nav.switcher/project-navswitcher");
    }

    public List<Map<String, Object>> getAdminNavLinksSecondary() {
        return this.getSoyListOfLinksForSection("atj.jira.proj.nav.switcher/project-navswitcher-secondary");
    }

    private List<Map<String, Object>> getSoyListOfLinksForSection(String sectionPath) {
        List projectAdminLinks = this.simpleLinkManager.getLinksForSection(sectionPath, this.getLoggedInUser(), this.getJiraHelper());
        ArrayList<Map<String, Object>> soyedMainLinkSections = new ArrayList<Map<String, Object>>();
        for (SimpleLink currentLink : projectAdminLinks) {
            HashMap<String, Object> soyedSection = new HashMap<String, Object>();
            String id = currentLink.getId();
            soyedSection.put("id", id);
            soyedSection.put("link", currentLink.getUrl());
            soyedSection.put("label", currentLink.getLabel());
            soyedSection.put("isSelected", id.equalsIgnoreCase("browse_project"));
            if (StringUtils.isNotEmpty((String)currentLink.getStyleClass())) {
                soyedSection.put("styleClass", currentLink.getStyleClass());
            }
            soyedMainLinkSections.add(soyedSection);
        }
        return soyedMainLinkSections;
    }

    protected String getPageHeaderHtml() {
        String headerHtml;
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("mainContent", "<h2>" + this.getTabLabel() + "</h2>");
        try {
            headerHtml = this.getSoyRenderer().render("jira.webresources:soy-templates", "JIRA.Templates.Headers.pageHeader", data);
        }
        catch (SoyException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Failed to render page header template", (Throwable)e);
            }
            headerHtml = String.valueOf(data.get("mainContent"));
        }
        return headerHtml;
    }
}

