/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.DelegatingApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.web.action.user.GenericEditProfile;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class EditUser
extends GenericEditProfile {
    private final UserService userService;
    private final UserManager userManager;
    private final FeatureManager featureManager;
    private UserService.UpdateUserValidationResult updateUserValidationResult;
    private String editName;
    private ApplicationUser oldUser;
    private UserManager.UserState userState;
    private Collection<Project> projects;
    private Collection<ProjectComponent> components;

    public EditUser(UserService userService, UserManager userManager, UserPropertyManager userPropertyManager, FeatureManager featureManager) {
        super(userPropertyManager);
        this.userService = userService;
        this.featureManager = featureManager;
        this.userManager = userManager;
    }

    @Override
    public void doValidation() {
        super.doValidation();
        ApplicationUser newUser = this.buildNewUser();
        this.updateUserValidationResult = this.userService.validateUpdateUser(newUser);
        this.addErrorCollection(this.updateUserValidationResult.getErrorCollection());
    }

    public boolean showProjectsUserLeadsError() {
        return !this.isActive() && !this.getProjectsUserLeads().isEmpty();
    }

    public String projectsUserLeadsErrorMessage() {
        String projectList = this.getDisplayableProjectList(this.getProjectsUserLeads(), "/roles");
        return this.getText("admin.errors.users.cannot.deactivate.due.to.project.lead", projectList);
    }

    private Collection<Project> getProjectsUserLeads() {
        if (this.projects == null) {
            this.projects = ComponentAccessor.getProjectManager().getProjectsLeadBy(this.getEditedUser());
        }
        return this.projects;
    }

    private Collection<ProjectComponent> getComponentsUserLeads() {
        if (this.components == null) {
            this.components = ComponentAccessor.getProjectComponentManager().findComponentsByLead(this.getEditName());
        }
        return this.components;
    }

    public boolean showComponentsUserLeadsError() {
        return !this.isActive() && !this.getComponentsUserLeads().isEmpty();
    }

    public String componentsUserLeadsErrorMessage() {
        String projectList = this.getDisplayableProjectList(this.getProjectsFor(this.getComponentsUserLeads()), "/components");
        return this.getText("admin.errors.users.cannot.deactivate.due.to.component.lead", projectList);
    }

    private ApplicationUser buildNewUser() {
        ImmutableUser.Builder builder = ImmutableUser.newUser((User)this.getEditedUser().getDirectoryUser());
        if (this.showRenameUser()) {
            builder.name(this.getUsername());
        }
        builder.displayName(this.getFullName());
        builder.emailAddress(StringUtils.trim((String)this.getEmail()));
        if (this.showActiveCheckbox()) {
            builder.active(this.isActive());
        }
        return new DelegatingApplicationUser(this.getEditedUser().getKey(), builder.toUser());
    }

    private Collection<Project> getProjectsFor(Collection<ProjectComponent> components) {
        ProjectManager projectManager = ComponentAccessor.getProjectManager();
        HashSet<Project> projects = new HashSet<Project>(components.size());
        for (ProjectComponent component : components) {
            projects.add(projectManager.getProjectObj(component.getProjectId()));
        }
        return projects;
    }

    private String getDisplayableProjectList(Collection<Project> projects, String projectConfigSection) {
        int count = 0;
        StringBuilder sb = new StringBuilder();
        for (Project project : projects) {
            if (count >= 5) {
                sb.append(", ...");
                break;
            }
            if (count > 0) {
                sb.append(", ");
            }
            sb.append("<a href=\"");
            sb.append(this.insertContextPath("/plugins/servlet/project-config/"));
            sb.append(project.getKey());
            sb.append(projectConfigSection);
            sb.append("\">");
            sb.append(project.getKey());
            sb.append("</a>");
            ++count;
        }
        return sb.toString();
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.userService.updateUser(this.updateUserValidationResult);
        String result = this.getResult();
        if ("success".equals(result)) {
            String returnUrl = this.getReturnUrl() == null ? "ViewUser.jspa?name=" + URLEncoder.encode(this.updateUserValidationResult.getApplicationUser().getUsername(), "UTF8") : this.getReturnUrl();
            return this.returnCompleteWithInlineRedirect(returnUrl);
        }
        return result;
    }

    public String getEditName() {
        return this.editName;
    }

    public void setEditName(String editName) {
        this.editName = editName;
    }

    public boolean showActiveCheckbox() {
        if (this.featureManager.isOnDemand()) {
            return false;
        }
        Directory directory = this.userManager.getDirectory(Long.valueOf(this.getEditedUser().getDirectoryId()));
        return directory.getType() != DirectoryType.CONNECTOR;
    }

    public boolean showRenameUser() {
        return this.userManager.canRenameUser(this.getEditedUser());
    }

    private UserManager.UserState getUserState() {
        if (this.userState == null) {
            this.userState = this.userManager.getUserState(this.getEditedUser());
        }
        return this.userState;
    }

    public boolean isInMultipleDirectories() {
        return this.getUserState().isInMultipleDirectories();
    }

    @Override
    public ApplicationUser getEditedUser() {
        if (this.oldUser == null) {
            this.oldUser = this.userManager.getUserByName(this.editName);
        }
        return this.oldUser;
    }
}

