/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.group.GroupRemoveChildMapper;
import com.atlassian.jira.bc.group.GroupService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.customfields.converters.MultiUserConverter;
import com.atlassian.jira.issue.fields.option.ChildGroupOption;
import com.atlassian.jira.issue.fields.option.GroupOption;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.GlobalPermissionGroupAssociationUtil;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

@WebSudoRequired
public class EditNestedGroups
extends JiraWebActionSupport {
    private String[] selectedGroupsStr;
    private List selectedGroups;
    private Set selectedGroupsChildnames;
    private String[] childrenToUnassign;
    private String[] childrenToAssignStr;
    private ArrayList childrenToAssign;
    private String prunedChildrenToAssign;
    private ArrayList membersList;
    private ArrayList overloadedGroups;
    private String assign;
    private String unassign;
    private Integer maxMembers;
    private final MultiUserConverter multiUserConverter;
    private final ApplicationProperties applicationProperties;
    private final GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil;
    private final GroupService groupService;
    private final CrowdService crowdService;
    private final GroupManager groupManager;
    private static final int MAX_LIST_SIZE = 20;
    private static final String OPTION_VALUE_SEPERATOR = "______";

    public EditNestedGroups(MultiUserConverter multiUserConverter, ApplicationProperties applicationProperties, GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil, GroupService groupService, CrowdService crowdService, GroupManager groupManager) {
        this.globalPermissionGroupAssociationUtil = globalPermissionGroupAssociationUtil;
        this.multiUserConverter = multiUserConverter;
        this.applicationProperties = applicationProperties;
        this.groupService = groupService;
        this.crowdService = crowdService;
        this.groupManager = groupManager;
    }

    public void doValidation() {
        super.doValidation();
        if (this.selectedGroupsStr == null || this.selectedGroupsStr.length == 0) {
            this.addErrorMessage(this.getText("admin.editnestedgroups.error.no.group.selected"));
            return;
        }
        if (TextUtils.stringSet((String)this.assign)) {
            if (this.childrenToAssignStr == null || this.childrenToAssignStr.length == 0) {
                this.addErrorMessage(this.getText("admin.editnestedgroups.error.no.children.to.add"));
                return;
            }
            GroupService.BulkEditGroupValidationResult bulkEditGroupValidationResult = this.groupService.validateAddGroupsToGroup(this.getJiraServiceContext(), Arrays.asList(this.selectedGroupsStr), Arrays.asList(this.childrenToAssignStr));
            if (!bulkEditGroupValidationResult.isSuccess()) {
                ArrayList<String> validChildren = new ArrayList<String>();
                validChildren.addAll(Arrays.asList(this.childrenToAssignStr));
                validChildren.removeAll(bulkEditGroupValidationResult.getInvalidChildren());
                this.prunedChildrenToAssign = StringUtils.join(validChildren.iterator(), (String)", ");
            }
        } else if (TextUtils.stringSet((String)this.unassign)) {
            if (this.childrenToUnassign == null || this.childrenToUnassign.length <= 0) {
                this.addErrorMessage(this.getText("admin.editnestedgroups.error.no.children.to.remove"));
                return;
            }
            this.groupService.validateRemoveGroupsFromGroups(this.getJiraServiceContext(), this.getGroupRemoveChildMapper());
        }
    }

    @RequiresXsrfCheck
    public String doExecute() throws Exception {
        if (TextUtils.stringSet((String)this.assign)) {
            this.groupService.addGroupsToGroups(this.getJiraServiceContext(), Arrays.asList(this.selectedGroupsStr), Arrays.asList(this.childrenToAssignStr));
        } else if (TextUtils.stringSet((String)this.unassign)) {
            this.groupService.removeGroupsFromGroups(this.getJiraServiceContext(), this.getGroupRemoveChildMapper());
        }
        return this.redirectToView();
    }

    public Collection getAllVisibleGroups() {
        return this.globalPermissionGroupAssociationUtil.getNonAdminGroups(new ArrayList<Group>(this.groupManager.getAllGroups()));
    }

    public boolean getIsGroupSelected(Group group) {
        return this.getSelectedGroups() != null && this.getSelectedGroups().contains(group);
    }

    public Collection getMembersList() {
        if (this.membersList != null || this.getSelectedGroups() == null) {
            return this.membersList;
        }
        this.membersList = new ArrayList();
        this.overloadedGroups = new ArrayList();
        boolean singleGroupSelected = this.getSelectedGroups().size() == 1;
        GroupOption allGroupOption = new GroupOption(this.getText("admin.editnestedgroups.all.selected.groups"));
        this.membersList.add(allGroupOption);
        for (Group group : this.getSelectedGroups()) {
            if (group == null) continue;
            int count = 0;
            GroupOption groupOption = new GroupOption(group);
            Collection children = this.groupService.getChildGroupNames(group);
            for (String childName : children) {
                Group child = this.crowdService.getGroup(childName);
                if (++count > this.getMaxChildrenDisplayedPerGroup()) {
                    this.overloadedGroups.add(group.getName());
                    break;
                }
                if (singleGroupSelected || !this.isChildInAllGroupsSelected(childName)) {
                    groupOption.addChildOption(new ChildGroupOption(child));
                    continue;
                }
                allGroupOption.addChildOption(new ChildGroupOption(child));
            }
            if (groupOption.getChildOptions().isEmpty()) continue;
            this.membersList.add(groupOption);
        }
        if (allGroupOption.getChildOptions().isEmpty()) {
            this.membersList.remove((Object)allGroupOption);
        }
        return this.membersList;
    }

    public int getAssignedChildrenCount() {
        int assignedChildrenCount = 0;
        for (GroupOption groupOption : this.getMembersList()) {
            assignedChildrenCount += groupOption.getChildOptions().size();
        }
        return assignedChildrenCount;
    }

    public int getAssignedChildrenListSize() {
        return this.getListSize(this.getAssignedChildrenCount() + this.getMembersList().size());
    }

    public int getListSize(int size) {
        return size < 20 ? size : 20;
    }

    public String getOptionValue(ChildGroupOption childOption) {
        if (childOption != null) {
            GroupOption parentOption = childOption.getParentOption();
            if (parentOption != null && parentOption.getGroup() != null) {
                return childOption.getName() + OPTION_VALUE_SEPERATOR + parentOption.getRawName();
            }
            return childOption.getName();
        }
        return "";
    }

    public String getUnassign() {
        return this.unassign;
    }

    public void setUnassign(String unassign) {
        this.unassign = unassign;
    }

    public String getAssign() {
        return this.assign;
    }

    public void setAssign(String assign) {
        this.assign = assign;
    }

    public String[] getSelectedGroupsStr() {
        return this.selectedGroupsStr;
    }

    public void setSelectedGroupsStr(String[] selectedGroupsStr) {
        this.selectedGroupsStr = selectedGroupsStr;
    }

    public List getSelectedGroups() {
        if (this.selectedGroupsStr == null) {
            return new ArrayList();
        }
        if (this.selectedGroups == null) {
            this.selectedGroups = new ArrayList();
            for (String groupName : this.selectedGroupsStr) {
                Group group = this.crowdService.getGroup(groupName);
                if (group == null) continue;
                this.selectedGroups.add(group);
            }
        }
        return this.selectedGroups;
    }

    public void setChildrenToAssignStr(String[] childrenToAssignStr) {
        this.childrenToAssignStr = childrenToAssignStr;
    }

    public String[] getChildrenToAssignStr() {
        return this.childrenToAssignStr;
    }

    public String getPrunedChildrenToAssign() {
        return this.prunedChildrenToAssign;
    }

    public void setChildrenToUnassign(String[] childrenToUnassign) {
        this.childrenToUnassign = childrenToUnassign;
    }

    public String[] getChildrenToUnassign() {
        return this.childrenToUnassign;
    }

    public boolean isTooManyChildrenListed() {
        return this.overloadedGroups != null && !this.overloadedGroups.isEmpty();
    }

    public int getMaxChildrenDisplayedPerGroup() {
        if (this.maxMembers == null) {
            int MAX_CHILDREN_DISPLAYED_PER_GROUP = 200;
            String maxMembersStr = this.applicationProperties.getDefaultBackedString("jira.usermanagement.maxdisplaymembers");
            if (maxMembersStr != null) {
                try {
                    this.maxMembers = Integer.valueOf(maxMembersStr.trim());
                }
                catch (NumberFormatException e) {
                    this.log.warn((Object)("Invalid format of 'jira.usermanagement.maxdisplaymembers' property: '" + maxMembersStr + "'. Value should be an integer. Using " + 200));
                    this.maxMembers = new Integer(200);
                }
            } else {
                this.log.debug((Object)"'jira.usermanagement.maxdisplaymembers' is missing. Using 200 instead.");
                this.maxMembers = new Integer(200);
            }
        }
        return this.maxMembers;
    }

    public String getPrettyPrintOverloadedGroups() {
        StringBuilder sb = new StringBuilder();
        int length = this.overloadedGroups.size();
        for (int i = 0; i < length; ++i) {
            sb.append(this.overloadedGroups.get(i));
            if (i == length - 2 && length > 1) {
                sb.append(" ").append(this.getText("common.words.and")).append(" ");
                continue;
            }
            if (i >= length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private GroupRemoveChildMapper getGroupRemoveChildMapper() {
        GroupRemoveChildMapper groupRemoveChildMapper = new GroupRemoveChildMapper(Arrays.asList(this.selectedGroupsStr));
        for (String aChildrenToUnassign : this.childrenToUnassign) {
            String childname = this.extractChildName(aChildrenToUnassign);
            String groupname = this.extractGroupName(aChildrenToUnassign);
            if (groupname != null) {
                groupRemoveChildMapper.register(childname, groupname);
                continue;
            }
            groupRemoveChildMapper.register(childname);
        }
        return groupRemoveChildMapper;
    }

    private String extractChildName(String optionValue) {
        int splitIndex = optionValue.indexOf(OPTION_VALUE_SEPERATOR);
        if (splitIndex >= 1) {
            return optionValue.substring(0, splitIndex);
        }
        return optionValue;
    }

    private String extractGroupName(String optionValue) {
        int splitIndex = optionValue.indexOf(OPTION_VALUE_SEPERATOR);
        if (splitIndex >= 1) {
            return optionValue.substring(splitIndex + OPTION_VALUE_SEPERATOR.length());
        }
        return null;
    }

    private String redirectToView() {
        StringBuilder redirectUrl = new StringBuilder("EditNestedGroups!default.jspa?");
        Iterator groups = this.getSelectedGroups().iterator();
        while (groups.hasNext()) {
            Group group = (Group)groups.next();
            redirectUrl.append("selectedGroupsStr=").append(JiraUrlCodec.encode((String)group.getName()));
            if (!groups.hasNext()) continue;
            redirectUrl.append("&");
        }
        return this.getRedirect(redirectUrl.toString());
    }

    private boolean isChildInAllGroupsSelected(String childname) {
        if (this.selectedGroupsChildnames == null) {
            this.selectedGroupsChildnames = new HashSet();
            Iterator selectedGroups = this.getSelectedGroups().iterator();
            if (selectedGroups.hasNext()) {
                Group group = (Group)selectedGroups.next();
                this.selectedGroupsChildnames.addAll(this.groupService.getChildGroupNames(group));
                while (selectedGroups.hasNext()) {
                    group = (Group)selectedGroups.next();
                    this.selectedGroupsChildnames.retainAll(this.groupService.getChildGroupNames(group));
                }
            }
        }
        return this.selectedGroupsChildnames.contains(childname);
    }
}

