/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.user;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.filter.SearchRequestService;
import com.atlassian.jira.bc.group.GroupService;
import com.atlassian.jira.bc.issue.worklog.TimeTrackingConfiguration;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.subscription.SubscriptionManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.web.action.IssueActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class DeleteGroup
extends IssueActionSupport {
    String name;
    String swapGroup;
    boolean confirm;
    private final SubscriptionManager subscriptionManager;
    private final SearchRequestService searchRequestService;
    private final GroupService groupService;
    private final GroupManager groupManager;
    private final CrowdService crowdService;

    public DeleteGroup(IssueManager issueManager, CustomFieldManager customFieldManager, AttachmentManager attachmentManager, ProjectManager projectManager, PermissionManager permissionManager, VersionManager versionManager, SubscriptionManager subscriptionManager, SearchRequestService searchRequestService, GroupService groupService, UserIssueHistoryManager userHistoryManager, TimeTrackingConfiguration timeTrackingConfiguration, GroupManager groupManager, CrowdService crowdService) {
        super(issueManager, customFieldManager, attachmentManager, projectManager, permissionManager, versionManager, userHistoryManager, timeTrackingConfiguration);
        this.subscriptionManager = subscriptionManager;
        this.searchRequestService = searchRequestService;
        this.groupService = groupService;
        this.groupManager = groupManager;
        this.crowdService = crowdService;
    }

    public String doDefault() throws Exception {
        this.groupService.isAdminDeletingSysAdminGroup(this.getJiraServiceContext(), this.name);
        this.groupService.areOnlyGroupsGrantingUserAdminPermissions(this.getJiraServiceContext(), (Collection)EasyList.build((Object)this.name));
        return super.doDefault();
    }

    protected void doValidation() {
        this.groupService.validateDelete(this.getJiraServiceContext(), this.name, this.swapGroup);
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.confirm) {
            this.groupService.delete(this.getJiraServiceContext(), this.name, this.swapGroup);
        }
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.getRedirect("GroupBrowser.jspa");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isConfirm() {
        return this.confirm;
    }

    public void setConfirm(boolean confirm) {
        this.confirm = confirm;
    }

    public String getSwapGroup() {
        return this.swapGroup;
    }

    public void setSwapGroup(String swapGroup) {
        this.swapGroup = swapGroup;
    }

    public long getMatchingCommentsAndWorklogsCount() throws GenericEntityException {
        return this.groupService.getCommentsAndWorklogsGuardedByGroupCount(this.name);
    }

    public Collection getOtherGroups() {
        ArrayList<String> otherGroups = new ArrayList<String>();
        try {
            Collection groups = this.groupManager.getAllGroups();
            for (Group group : groups) {
                if (group.getName().equals(this.name)) continue;
                otherGroups.add(group.getName());
            }
        }
        catch (Exception e) {
            this.addErrorMessage(this.getText("admin.errors.groups.error.occured.getting.other.groups"));
        }
        return otherGroups;
    }

    public boolean hasSubscriptions() {
        try {
            List subList = this.subscriptionManager.getAllSubscriptions();
            for (GenericValue gv : subList) {
                if (!this.name.equals(gv.getString("group"))) continue;
                return true;
            }
        }
        catch (DataAccessException e) {
            this.log.error((Object)e, (Throwable)e);
        }
        return false;
    }

    public Collection getSubscriptions() {
        try {
            List subList = this.subscriptionManager.getAllSubscriptions();
            ArrayList<String> subscriptions = new ArrayList<String>();
            for (GenericValue gv : subList) {
                if (!this.name.equals(gv.getString("group"))) continue;
                String userkey = gv.getString("username");
                Long filterID = gv.getLong("filterID");
                ApplicationUser user = this.getUserManager().getUserByKey(userkey);
                JiraServiceContextImpl ctx = new JiraServiceContextImpl(user);
                SearchRequest request = this.searchRequestService.getFilter((JiraServiceContext)ctx, filterID);
                if (request == null) continue;
                String filterName = request.getName();
                String username = user == null ? null : user.getUsername();
                String text = this.getText("admin.deletegroup.subscriptions.item", filterName, username);
                subscriptions.add(text);
            }
            return subscriptions;
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            return Collections.EMPTY_LIST;
        }
    }
}

