/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.subtasks;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.opensymphony.util.TextUtils;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class EditSubTaskIssueTypes
extends JiraWebActionSupport {
    private final SubTaskManager subTaskManager;
    private final ConstantsManager constantsManager;
    private String id;
    private String name;
    private Long sequence;
    private String description;
    private String iconurl;

    public EditSubTaskIssueTypes(SubTaskManager subTaskManager, ConstantsManager constantsManager) {
        this.subTaskManager = subTaskManager;
        this.constantsManager = constantsManager;
    }

    public String doDefault() throws Exception {
        if (!this.isSubtasksEnabled()) {
            this.addErrorMessage(this.getText("admin.errors.subtasks.disabled"));
            return this.getResult();
        }
        if (!TextUtils.stringSet((String)this.getId())) {
            this.addErrorMessage(this.getText("admin.errors.no.id.set"));
            return this.getResult();
        }
        GenericValue subTaskIssueTypeGV = this.subTaskManager.getSubTaskIssueTypeById(this.getId());
        this.setName(subTaskIssueTypeGV.getString("name"));
        this.setSequence(subTaskIssueTypeGV.getLong("sequence"));
        this.setDescription(subTaskIssueTypeGV.getString("description"));
        this.setIconurl(subTaskIssueTypeGV.getString("iconurl"));
        return "input";
    }

    protected void doValidation() {
        if (!this.isSubtasksEnabled()) {
            this.addErrorMessage(this.getText("admin.errors.subtasks.are.disabled"));
            return;
        }
        if (!TextUtils.stringSet((String)this.getId())) {
            this.addErrorMessage(this.getText("admin.errors.no.id.set"));
        } else if (!TextUtils.stringSet((String)this.getName())) {
            this.addError("name", this.getText("admin.errors.specify.a.name.for.this.new.sub.task.issue.type"));
        } else {
            IssueConstant subTaskIssueType = this.constantsManager.getIssueConstantByName("IssueType", this.getName());
            if (subTaskIssueType != null && !this.getId().equals(subTaskIssueType.getId())) {
                this.addError("name", this.getText("admin.errors.issue.type.with.this.name.already.exists"));
            }
        }
        if (!TextUtils.stringSet((String)this.getIconurl())) {
            this.addError("iconurl", this.getText("admin.errors.must.specify.a.url.for.the.icon"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.subTaskManager.updateSubTaskIssueType(this.getId(), this.getName(), this.getSequence(), this.getDescription(), this.getIconurl());
        return this.getRedirect("ManageSubTasks.jspa");
    }

    private boolean isSubtasksEnabled() {
        return this.subTaskManager.isSubTasksEnabled();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getSequence() {
        return this.sequence;
    }

    public void setSequence(Long sequence) {
        this.sequence = sequence;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getIconurl() {
        return this.iconurl;
    }

    public void setIconurl(String iconurl) {
        this.iconurl = iconurl;
    }
}

