/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.priorities;

import com.atlassian.jira.config.PriorityManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.Colours;
import com.atlassian.jira.web.action.admin.constants.AbstractEditConstant;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

@WebSudoRequired
public class EditPriority
extends AbstractEditConstant {
    private boolean preview = false;
    private String statusColor;
    private final PriorityManager priorityManager;

    public EditPriority(PriorityManager priorityManager) {
        this.priorityManager = priorityManager;
    }

    @Override
    public String doDefault() throws Exception {
        this.setStatusColor(this.getConstant().getString("statusColor"));
        return super.doDefault();
    }

    @Override
    protected void doValidation() {
        if (!this.isPreview()) {
            if (StringUtils.isBlank((String)this.getIconurl())) {
                this.addError("iconurl", this.getText("admin.errors.must.specify.url.for.icon"));
            }
            if (StringUtils.isBlank((String)this.getStatusColor())) {
                this.addError("statusColor", this.getText("admin.errors.must.specify.priority.color"));
            } else if (!Colours.isHexColour(this.getStatusColor())) {
                this.addError("statusColor", this.getText("admin.errors.must.specify.priority.color.as.hex.value"));
            }
            super.doValidation();
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.isPreview()) {
            return "input";
        }
        Priority priority = this.priorityManager.getPriority(this.id);
        this.priorityManager.editPriority(priority, this.name, this.description, this.iconurl, this.statusColor);
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.getRedirect(this.getRedirectPage());
    }

    @Override
    protected String getConstantEntityName() {
        return "Priority";
    }

    @Override
    protected String getNiceConstantName() {
        return this.getText("admin.issue.constant.priority.lowercase");
    }

    @Override
    protected String getIssueConstantField() {
        return "priority";
    }

    @Override
    protected GenericValue getConstant(String id) {
        Priority priorityObject = this.getConstantsManager().getPriorityObject(id);
        return priorityObject != null ? priorityObject.getGenericValue() : null;
    }

    @Override
    protected String getRedirectPage() {
        return "ViewPriorities.jspa";
    }

    @Override
    protected Collection<GenericValue> getConstants() {
        return this.getConstantsManager().getPriorities();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshPriorities();
    }

    public String getStatusColor() {
        return this.statusColor;
    }

    public void setStatusColor(String statusColor) {
        this.statusColor = statusColor;
    }

    public boolean isPreview() {
        return this.preview;
    }

    public void setPreview(boolean preview) {
        this.preview = preview;
    }
}

