/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.mail;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.projectroles.ProjectRoleService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.comparator.UserComparator;
import com.atlassian.jira.mail.CssInliner;
import com.atlassian.jira.mail.JiraMailQueueUtils;
import com.atlassian.jira.mail.TemplateContext;
import com.atlassian.jira.mail.TemplateContextFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.security.roles.ProjectRoleActors;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.template.TemplateSources;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.mail.Email;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

@WebSudoRequired
public class SendBulkMail
extends JiraWebActionSupport {
    private static final transient Logger log = Logger.getLogger(SendBulkMail.class);
    private boolean sendToRoles = true;
    private String[] groups;
    private String[] projects;
    private String[] roles;
    private String subject;
    private String messageType;
    private String message;
    private String status;
    private String replyTo;
    private boolean sendBlind = false;
    private List<User> users;
    private int RECIPIENT_BATCH_SIZE = 100;
    protected static final int MAX_MULTISELECT_SIZE = 6;
    private final MailServerManager mailServerManager;
    private final PermissionManager permissionManager;
    private final ProjectRoleService projectRoleService;
    private final ProjectManager projectManager;
    private final UserUtil userUtil;
    private final GroupManager groupManager;
    private String bodyTemplateName = "emailfromadmin.vm";

    public SendBulkMail(MailServerManager mailServerManager, PermissionManager permissionManager, ProjectRoleService projectRoleService, ProjectManager projectManager, UserUtil userUtil, GroupManager groupManager) {
        this.mailServerManager = mailServerManager;
        this.permissionManager = permissionManager;
        this.projectRoleService = projectRoleService;
        this.projectManager = projectManager;
        this.userUtil = userUtil;
        this.groupManager = groupManager;
        try {
            this.RECIPIENT_BATCH_SIZE = Integer.parseInt(this.getApplicationProperties().getDefaultBackedString("jira.sendmail.recipient.batch.size"));
        }
        catch (Exception e) {
            log.warn((Object)("Exception whilst trying to get property for jira.sendmail.recipient.batch.size. Defaulting to using " + this.RECIPIENT_BATCH_SIZE));
        }
    }

    public String doDefault() {
        this.sendBlind = true;
        return "input";
    }

    protected void doValidation() {
        if (!this.isHasMailServer()) {
            if (!this.invalidInput()) {
                this.addErrorMessage(this.getText("admin.errors.no.mail.server"));
            }
            return;
        }
        if (this.isSendToRoles()) {
            boolean roleNotSelected;
            boolean projectNotSelected = this.getProjects() == null || this.getProjects().length == 0;
            boolean bl = roleNotSelected = this.getRoles() == null || this.getRoles().length == 0;
            if (projectNotSelected && roleNotSelected) {
                this.addError("sendToRoles", this.getText("admin.errors.select.one.project.and.role"));
            } else if (projectNotSelected) {
                this.addError("sendToRoles", this.getText("admin.errors.select.one.project"));
            } else if (roleNotSelected) {
                this.addError("sendToRoles", this.getText("admin.errors.select.one.role"));
            }
            if (!this.invalidInput()) {
                User remoteUser = this.getLoggedInUser();
                HashSet<ProjectRole> projectRoles = new HashSet<ProjectRole>();
                for (String roleIdAsString : this.getAsCollection(this.getRoles())) {
                    Long roleId = Long.valueOf(roleIdAsString);
                    projectRoles.add(this.projectRoleService.getProjectRole(remoteUser, roleId, (ErrorCollection)this));
                }
                HashSet recipientUsers = Sets.newHashSet();
                for (String s : this.getAsCollection(this.getProjects())) {
                    Long projectId = Long.valueOf(s);
                    Project project = this.projectManager.getProjectObj(projectId);
                    for (ProjectRole projectRole : projectRoles) {
                        ProjectRoleActors roleActors = this.projectRoleService.getProjectRoleActors(remoteUser, projectRole, project, (ErrorCollection)this);
                        recipientUsers.addAll(roleActors.getUsers());
                    }
                }
                this.users = new ArrayList<User>();
                for (User recipientUser : recipientUsers) {
                    this.users.add(recipientUser);
                }
                if (this.users.isEmpty()) {
                    this.addError("sendToRoles", this.getText("admin.errors.empty.projectroles"));
                }
            }
        } else if (this.getGroups() == null || this.getGroups().length == 0) {
            this.addError("sendToRoles", this.getText("admin.errors.select.one.group"));
        } else {
            this.users = Lists.newArrayList((Iterable)this.userUtil.getUsersInGroupNames(this.getAsCollection(this.getGroups())));
            if (this.users.isEmpty()) {
                this.addError("sendToRoles", this.getText("admin.errors.empty.groups"));
            }
        }
        if (!this.invalidInput()) {
            Collections.sort(this.users, new UserComparator());
        }
        if (TextUtils.stringSet((String)this.getReplyTo()) && !TextUtils.verifyEmail((String)this.getReplyTo())) {
            this.addError("replyTo", this.getText("admin.errors.invalid.email"));
        }
        if (!TextUtils.stringSet((String)this.getSubject())) {
            this.addError("subject", this.getText("admin.errors.no.subject"));
        }
        if (!TextUtils.stringSet((String)this.getMessageType())) {
            this.addError("messageType", this.getText("admin.errors.no.message.type"));
        }
        if (!TextUtils.stringSet((String)this.getMessage())) {
            this.addError("message", this.getText("admin.errors.no.body"));
        }
        super.doValidation();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        StringBuilder mailSentRecipients = new StringBuilder();
        Iterator<User> recipients = this.users.iterator();
        while (recipients.hasNext()) {
            StringBuilder toList = new StringBuilder();
            for (int i = 0; i < this.RECIPIENT_BATCH_SIZE && recipients.hasNext(); ++i) {
                User user = recipients.next();
                toList.append(user.getEmailAddress()).append(",");
            }
            if (toList.length() > 0) {
                toList.deleteCharAt(toList.length() - 1);
            }
            try {
                User user = this.getLoggedInUser();
                SMTPMailServer server = this.mailServerManager.getDefaultSMTPMailServer();
                com.atlassian.jira.mail.Email email = new com.atlassian.jira.mail.Email(this.sendBlind ? null : toList.toString(), null, this.sendBlind ? toList.toString() : null);
                email.setFromName(user.getName());
                email.setReplyTo(user.getEmailAddress());
                if (TextUtils.stringSet((String)this.getReplyTo())) {
                    email.setReplyTo(this.getReplyTo());
                }
                if ("html".equals(this.getMessageType())) {
                    email.setMimeType("text/html");
                    email.setSubject(this.getSubject());
                    email.setBody(this.renderEmailBody());
                } else {
                    email.setMimeType("text/plain");
                    email.setSubject(this.getSubject());
                    email.setBody(this.getMessage());
                }
                server.send((Email)email);
                this.status = this.getText("admin.errors.message.sent.successfully");
                mailSentRecipients.append(toList.toString());
            }
            catch (Exception e) {
                this.status = this.getText("admin.errors.failed.to.send", "<font color=\"bb0000\">", "</font>");
                this.addErrorMessage(this.getText("admin.errors.the.error.was") + " " + e.getMessage());
                log.error((Object)("Failed to send email to : " + toList));
                log.error((Object)"Error sending e-mail.", (Throwable)e);
            }
        }
        if (mailSentRecipients.length() > 0) {
            log.debug((Object)("Email successfully sent to : " + mailSentRecipients));
        }
        return this.getResult();
    }

    private Collection<String> getAsCollection(String[] array) {
        if (array != null) {
            return Arrays.asList(array);
        }
        return Collections.emptyList();
    }

    public Collection getAllGroups() {
        return this.groupManager.getAllGroups();
    }

    public Collection getAllProjects() {
        return this.permissionManager.getProjects(10, this.getLoggedInUser());
    }

    public Collection getAllRoles() {
        return this.projectRoleService.getProjectRoles(this.getLoggedInUser(), (ErrorCollection)this);
    }

    public boolean isSendToRoles() {
        return this.sendToRoles;
    }

    public void setSendToRoles(boolean sendToRoles) {
        this.sendToRoles = sendToRoles;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public void setGroups(String[] groups) {
        this.groups = groups;
    }

    public String[] getProjects() {
        return this.projects;
    }

    public void setProjects(String[] projects) {
        this.projects = projects;
    }

    public String[] getRoles() {
        return this.roles;
    }

    public void setRoles(String[] roles) {
        this.roles = roles;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public Map getMimeTypes() {
        return EasyMap.build((Object)"html", (Object)"HTML", (Object)"text", (Object)"Text");
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getStatus() {
        return this.status;
    }

    public int getGroupsFieldSize() {
        return Math.min(this.getAllGroups().size() + 1, 6);
    }

    public int getProjectsRolesFieldSize() {
        int largestFieldSize = Math.max(this.getAllProjects().size() + 1, this.getAllRoles().size() + 1);
        return Math.min(largestFieldSize, 6);
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public boolean isSendBlind() {
        return this.sendBlind;
    }

    public void setSendBlind(boolean sendBlind) {
        this.sendBlind = sendBlind;
    }

    public boolean isHasMailServer() {
        return this.mailServerManager.getDefaultSMTPMailServer() != null;
    }

    public Collection getUsers() {
        return this.users;
    }

    private String renderEmailBody() {
        CssInliner cssInliner = (CssInliner)ComponentAccessor.getComponent(CssInliner.class);
        String bodyTemplatePath = "templates/email/html/" + this.bodyTemplateName;
        String renderedHtml = this.getTemplatingEngine().render(TemplateSources.file((String)bodyTemplatePath)).applying(this.getContextParams()).asHtml();
        return cssInliner.applyStyles(renderedHtml);
    }

    @VisibleForTesting
    VelocityTemplatingEngine getTemplatingEngine() {
        return (VelocityTemplatingEngine)ComponentAccessor.getComponent(VelocityTemplatingEngine.class);
    }

    Map<String, Object> getContextParams() {
        TemplateContextFactory templateContextFactory = (TemplateContextFactory)ComponentAccessor.getComponent(TemplateContextFactory.class);
        TemplateContext ctx = templateContextFactory.getTemplateContext(this.getLocale());
        Map<String, Object> params = JiraMailQueueUtils.getContextParamsBody(ctx.getTemplateParams());
        params.put("content", this.getMessage());
        params.put("subject", this.getSubject());
        params.put("author", this.getLoggedInApplicationUser());
        return params;
    }
}

