/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.JiraArrayUtils;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.issuetypes.AddIssueTypeAction;
import com.atlassian.jira.web.action.admin.issuetypes.ManageableOptionType;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;

@WebSudoRequired
public class AddNewIssueTypeToScheme
extends JiraWebActionSupport
implements AddIssueTypeAction {
    private static final String PARAM_SCHEME_NAME = "schemeName";
    private static final String PARAM_SCHEME_ID = "schemeId";
    private static final String PARAM_FIELD_ID = "fieldId";
    private static final String PARAM_PROJECT_ID = "projectId";
    private static final String PARAM_SCHEME_DESCRIPTION = "schemeDescription";
    private static final String PARAM_SELECTED_OPTIONS = "selectedOptions";
    private static final String PARAM_DEFAULT_OPTION = "defaultOption";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_DESCRIPTION = "description";
    private final ManageableOptionType manageableOptionType;
    private final ConstantsManager constantsManager;
    private final IssueTypeSchemeManager schemeManager;
    private String iconurl = "/images/icons/issuetypes/genericissue.png";
    private String style;
    private String name;
    private String description;
    private IssueType newIssueType;
    private String fieldId;
    private Long schemeId;
    private Long projectId;
    private String schemeName;
    private String schemeDescription;
    private String[] selectedOptions;
    private String defaultOption;

    public AddNewIssueTypeToScheme(ManageableOptionType manageableOptionType, ConstantsManager constantsManager, IssueTypeSchemeManager schemeManager) {
        this.manageableOptionType = manageableOptionType;
        this.constantsManager = constantsManager;
        this.schemeManager = schemeManager;
    }

    @Override
    public String getIconurl() {
        return this.iconurl;
    }

    @Override
    public void setIconurl(String iconUrl) {
        this.iconurl = iconUrl;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public void setStyle(String style) {
        this.style = style;
    }

    @Override
    public String getSubmitUrl() {
        return "AddNewIssueTypeToScheme.jspa";
    }

    @Override
    public String getCancelUrl() {
        return this.createViewUrl(null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public void setFieldId(String fieldId) {
        this.fieldId = fieldId;
    }

    public Long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public String getDefaultOption() {
        return this.defaultOption;
    }

    public void setDefaultOption(String defaultOption) {
        this.defaultOption = defaultOption;
    }

    public String[] getSelectedOptions() {
        return this.selectedOptions;
    }

    public void setSelectedOptions(String[] selectedOptions) {
        this.selectedOptions = JiraArrayUtils.isContainsOneBlank(selectedOptions) ? new String[0] : selectedOptions;
    }

    public String getSchemeName() {
        return this.schemeName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }

    public String getSchemeDescription() {
        return this.schemeDescription;
    }

    public void setSchemeDescription(String schemeDescription) {
        this.schemeDescription = schemeDescription;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @Override
    public List<Pair<String, Object>> getHiddenFields() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)Pair.nicePairOf((Object)PARAM_SCHEME_NAME, (Object)this.getSchemeName()));
        builder.add((Object)Pair.nicePairOf((Object)PARAM_SCHEME_DESCRIPTION, (Object)this.getSchemeDescription()));
        builder.add((Object)Pair.nicePairOf((Object)PARAM_SCHEME_ID, (Object)this.getSchemeId()));
        builder.add((Object)Pair.nicePairOf((Object)PARAM_PROJECT_ID, (Object)this.getProjectId()));
        builder.add((Object)Pair.nicePairOf((Object)PARAM_FIELD_ID, (Object)this.getFieldId()));
        builder.add((Object)Pair.nicePairOf((Object)PARAM_DEFAULT_OPTION, (Object)this.getDefaultOption()));
        String[] options = this.getSelectedOptions();
        if (options != null) {
            for (String s : options) {
                builder.add((Object)Pair.nicePairOf((Object)PARAM_SELECTED_OPTIONS, (Object)s));
            }
        }
        return builder.build();
    }

    @Override
    public ManageableOptionType getManageableOption() {
        return this.manageableOptionType;
    }

    public IssueConstantOption getNewIssueType() {
        return this.newIssueType == null ? null : new IssueConstantOption((IssueConstant)this.newIssueType);
    }

    public Collection<IssueConstantOption> getAllOptions() {
        Collection constants = this.constantsManager.getConstantObjects(this.getManageableOption().getFieldId());
        return ImmutableList.copyOf((Collection)Collections2.transform((Collection)constants, (Function)new Function<Object, IssueConstantOption>(){

            public IssueConstantOption apply(Object input) {
                return new IssueConstantOption((IssueConstant)input);
            }
        }));
    }

    public String doInput() {
        return "input";
    }

    protected void doValidation() {
        this.constantsManager.validateCreateIssueType(this.getName(), this.getStyle(), this.getDescription(), this.getIconurl(), (ErrorCollection)this, PARAM_NAME);
    }

    @RequiresXsrfCheck
    public String doExecute() throws CreateException {
        this.newIssueType = this.constantsManager.insertIssueType(this.getName(), null, this.getStyle(), this.getDescription(), this.getIconurl());
        String createdId = this.newIssueType.getId();
        this.schemeManager.addOptionToDefault(createdId);
        if (this.isInlineDialogMode()) {
            this.returnComplete();
            return "success";
        }
        return this.getRedirect(this.createViewUrl(createdId));
    }

    private String createViewUrl(String createdId) {
        UrlBuilder builder = new UrlBuilder("ConfigureOptionSchemes!input.jspa");
        builder.addParameter(PARAM_NAME, this.getSchemeName()).addParameter(PARAM_DESCRIPTION, this.getSchemeDescription());
        builder.addParameter(PARAM_SCHEME_ID, (Object)this.getSchemeId()).addParameter(PARAM_FIELD_ID, this.getFieldId());
        builder.addParameter(PARAM_PROJECT_ID, (Object)this.getProjectId());
        builder.addParameter(PARAM_DEFAULT_OPTION, this.getDefaultOption());
        String[] options = this.getSelectedOptions();
        if (options != null) {
            for (String selectedOption : options) {
                builder.addParameter(PARAM_SELECTED_OPTIONS, selectedOption);
            }
        }
        if (createdId != null) {
            builder.addParameter(PARAM_SELECTED_OPTIONS, createdId);
        }
        return builder.asUrlString();
    }
}

