/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.screens;

import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenScheme;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenSchemeManager;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.issue.operation.ScreenableIssueOperation;
import com.atlassian.jira.web.action.admin.issuefields.screens.AbstractFieldScreenSchemeAction;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;

public class AbstractFieldScreenSchemeItemAction
extends AbstractFieldScreenSchemeAction {
    private final FieldScreenManager fieldScreenManager;
    private Long issueOperationId;
    private Long fieldScreenId;
    private Collection<FieldScreen> fieldScreens;
    private List<ScreenableIssueOperation> addableIssueOperations;

    public AbstractFieldScreenSchemeItemAction(FieldScreenSchemeManager fieldScreenSchemeManager, FieldScreenManager fieldScreenManager) {
        super(fieldScreenSchemeManager);
        this.fieldScreenManager = fieldScreenManager;
    }

    @Override
    protected String redirectToView() {
        return this.returnComplete("ConfigureFieldScreenScheme.jspa?id=" + this.getId());
    }

    protected void validateIssueOperationId() {
        if (this.issueOperationId != null && IssueOperations.getIssueOperation((Long)this.issueOperationId) == null) {
            this.addError("issueOperationId", this.getText("admin.errors.screens.invalid.issue.operation.id"));
        }
    }

    protected void validateFieldScreenId() {
        if (this.getFieldScreenId() == null) {
            this.addError("fieldScreenId", this.getText("admin.errors.screens.please.select.screen"));
        } else if (this.getFieldScreenManager().getFieldScreen(this.getFieldScreenId()) == null) {
            this.addError("fieldScreenId", this.getText("admin.errors.screens.invalid.id"));
        }
    }

    public Long getIssueOperationId() {
        return this.issueOperationId;
    }

    public void setIssueOperationId(Long issueOperationId) {
        this.issueOperationId = issueOperationId;
    }

    public Long getFieldScreenId() {
        return this.fieldScreenId;
    }

    public void setFieldScreenId(Long fieldScreenId) {
        this.fieldScreenId = fieldScreenId;
    }

    public Collection<FieldScreen> getFieldScreens() {
        if (this.fieldScreens == null) {
            this.fieldScreens = this.fieldScreenManager.getFieldScreens();
        }
        return this.fieldScreens;
    }

    protected FieldScreenManager getFieldScreenManager() {
        return this.fieldScreenManager;
    }

    public IssueOperation getIssueOperation() {
        if (this.getIssueOperationId() != null) {
            return IssueOperations.getIssueOperation((Long)this.getIssueOperationId());
        }
        return null;
    }

    public Collection<ScreenableIssueOperation> getAddableIssueOperations() {
        if (this.addableIssueOperations == null) {
            DefaultIssueOperation defaultIssueOperation = new DefaultIssueOperation();
            this.addableIssueOperations = Lists.newLinkedList();
            FieldScreenScheme fieldScreenScheme = this.getFieldScreenScheme();
            if (fieldScreenScheme != null) {
                this.addableIssueOperations.add(defaultIssueOperation);
                this.addableIssueOperations.addAll(IssueOperations.getIssueOperations());
                for (FieldScreenSchemeItem fieldScreenSchemeItem : fieldScreenScheme.getFieldScreenSchemeItems()) {
                    ScreenableIssueOperation issueOperation = fieldScreenSchemeItem.getIssueOperation();
                    if (issueOperation != null) {
                        this.addableIssueOperations.remove(issueOperation);
                        continue;
                    }
                    this.addableIssueOperations.remove(defaultIssueOperation);
                }
            }
        }
        return this.addableIssueOperations;
    }

    private static class DefaultIssueOperation
    implements ScreenableIssueOperation {
        private String nameKey = "admin.common.words.default";
        private String description = "";

        private DefaultIssueOperation() {
        }

        public Long getId() {
            return null;
        }

        public String getNameKey() {
            return this.nameKey;
        }

        public String getDescriptionKey() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IssueOperation)) {
                return false;
            }
            ScreenableIssueOperation issueOperation = (ScreenableIssueOperation)o;
            if (this.description != null ? !this.description.equals(issueOperation.getDescriptionKey()) : issueOperation.getDescriptionKey() != null) {
                return false;
            }
            if (issueOperation.getId() != null) {
                return false;
            }
            return !(this.nameKey != null ? !this.nameKey.equals(issueOperation.getNameKey()) : issueOperation.getNameKey() != null);
        }

        public int hashCode() {
            int result = 0;
            result = 29 * result + (this.nameKey != null ? this.nameKey.hashCode() : 0);
            result = 29 * result + (this.description != null ? this.description.hashCode() : 0);
            return result;
        }
    }
}

